/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.FilteredTreeController;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisEntitySelectorControllerJTree
extends AbstractDisposable
implements VCSGisEntitySelectorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisEntitySelectorControllerJTree.class);
    private final JTextComponent txtFilter;
    private final JTree treeEntities;
    private Set<String> checkedEntityCodes;
    private Map<String, String> categoryOfCheckedEntity;
    private Map<String, VCSGisEntity> entities;
    private final JButton btnEntities;
    private FilteredTreeController filteredTree;
    private ActionListenerSupport actionListeners;
    private ChangeListenerHelper changeListeners;
    private VCSGisWorkspace workspace;
    private boolean processing;
    private boolean enabled;
    private Predicate<VCSGisEntity> viewFilter = ALL_ENTITIES;
    private Predicate<VCSGisEntity> filter = ALL_ENTITIES;
    private boolean checksEnabled;
    private JButton btnCheckAll;
    private JButton btnUnCheckAll;
    private Thread lastThread;
    private Function<VCSGisEntity, String> labelEntityFormatter;

    public VCSGisEntitySelectorControllerJTree(JTree treeEntities) {
        this(treeEntities, null, null, null, null);
    }

    public VCSGisEntitySelectorControllerJTree(JTree treeEntities, JTextComponent txtFilter, JButton btnTable, JButton btnCheckAll, JButton btnUnCheckAll) {
        this.treeEntities = treeEntities;
        this.checkedEntityCodes = new HashSet<String>();
        this.categoryOfCheckedEntity = new HashMap<String, String>();
        this.entities = new HashMap<String, VCSGisEntity>();
        this.txtFilter = txtFilter == null ? new JTextField() : txtFilter;
        this.btnEntities = btnTable == null ? new JButton() : btnTable;
        this.btnCheckAll = btnCheckAll == null ? new JButton() : btnCheckAll;
        this.btnUnCheckAll = btnUnCheckAll == null ? new JButton() : btnCheckAll;
        this.processing = false;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.actionListeners = toolsSwingManager.createActionListenerSupport();
        this.changeListeners = toolsSwingManager.createChangeListenerHelper();
        this.btnEntities.setCursor(Cursor.getPredefinedCursor(12));
        this.treeEntities.getSelectionModel().setSelectionMode(1);
        this.treeEntities.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)e.getPath().getParentPath().getLastPathComponent();
                    DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                    if (parent != null) {
                        String category = (String)parent.getUserObject();
                        VCSGisEntity entity = (VCSGisEntity)((LabeledValue)current.getUserObject()).getValue();
                        if (entity != null) {
                            VCSGisEntitySelectorControllerJTree.this.categoryOfCheckedEntity.put(entity.getEntityCode(), category);
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't set category for current entity", (Throwable)ex);
                }
                VCSGisEntitySelectorControllerJTree.this.fireActionEvent(new ActionEvent(this, 0, "select"));
            }
        });
        this.treeEntities.setRootVisible(false);
        this.treeEntities.setShowsRootHandles(true);
        this.filteredTree = toolsSwingManager.createFilteredTreeController(this.treeEntities, this.txtFilter, this.btnEntities);
        this.filteredTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        EntityCellRenderer cellRenderer = new EntityCellRenderer();
        this.treeEntities.setCellRenderer(cellRenderer);
        this.setChecksEnabled(true);
        this.btnCheckAll.addActionListener(e -> this.checkAll());
        this.btnUnCheckAll.addActionListener(e -> this.clearChecks());
        this.treeEntities.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = VCSGisEntitySelectorControllerJTree.this.treeEntities.getPathForLocation(e.getX(), e.getY());
                if (path != null) {
                    VCSGisEntitySelectorControllerJTree.this.treeEntities.startEditingAtPath(path);
                }
            }
        });
        this.treeEntities.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                TreePath path = VCSGisEntitySelectorControllerJTree.this.treeEntities.getPathForLocation(e.getX(), e.getY());
                VCSGisEntitySelectorControllerJTree.this.doMouseMoved(path);
            }
        });
    }

    private void doMouseMoved(TreePath path) {
        if (path == null) {
            return;
        }
        Object x = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (!(x instanceof LabeledValue)) {
            this.treeEntities.setToolTipText("");
            return;
        }
        LabeledValue lv = (LabeledValue)x;
        if (lv.getValue() instanceof VCSGisEntity) {
            VCSGisEntity entity = (VCSGisEntity)lv.getValue();
            VCSGisWorkspaceEntity lentity = this.workspace.getWorkspaceEntityByCode(entity.getEntityCode());
            String s = StringUtils.isBlank((CharSequence)entity.getRepositoryRevisionCode()) ? VCSGisSwingCommons.getStateDescription(((VCSGisWorkspaceEntity)entity).getState()) : VCSGisSwingCommons.getStateDescription(lentity == null ? 32 : lentity.getState());
            s = StringUtils.equalsIgnoreCase((CharSequence)entity.getEntityCode(), (CharSequence)entity.getLabel()) ? "<html>" + entity.getLabelOrName() + "<br>" + s + "</html>" : "<html>" + entity.getLabel() + "<br>" + entity.getEntityName() + "<br>" + s + "</html>";
            this.treeEntities.setToolTipText(s);
        } else {
            this.treeEntities.setToolTipText("");
        }
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public VCSGisEntity getSelectedEntity() {
        if (this.workspace == null) {
            return null;
        }
        TreePath path = this.treeEntities.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode lastComponent = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = lastComponent.getUserObject();
        if (userObject == null || !(userObject instanceof LabeledValue)) {
            return null;
        }
        LabeledValue selected = (LabeledValue)userObject;
        VCSGisEntity entity = (VCSGisEntity)selected.getValue();
        if (!this.filter.test(entity)) {
            return null;
        }
        return entity;
    }

    public void setSelectedEntity(VCSGisEntity entity) {
        if (this.workspace == null) {
            return;
        }
        for (int i = 0; i < this.treeEntities.getRowCount(); ++i) {
            TreePath path = this.treeEntities.getPathForRow(i);
            DefaultMutableTreeNode lc = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object x = lc.getUserObject();
            if (!(x instanceof LabeledValue)) continue;
            VCSGisEntity value = (VCSGisEntity)((LabeledValue)x).getValue();
            if (!StringUtils.equals((CharSequence)entity.getEntityCode(), (CharSequence)value.getEntityCode())) continue;
            this.treeEntities.setSelectionPath(path);
            return;
        }
    }

    public String getCategory(VCSGisEntity entity) {
        String category = this.categoryOfCheckedEntity.get(entity.getEntityCode());
        if (StringUtils.isBlank((CharSequence)category)) {
            category = entity.getFirstCategory();
        }
        return category;
    }

    public List<VCSGisEntity> getCheckedEntities() {
        ArrayList<VCSGisEntity> checkedEntities = new ArrayList<VCSGisEntity>();
        for (String entityCode : this.checkedEntityCodes) {
            VCSGisEntity entity = this.entities.get(entityCode);
            if (entity == null) continue;
            checkedEntities.add(entity);
        }
        Collections.sort(checkedEntities, new CompareUtils.NullSafeComparator<VCSGisEntity>(){

            public int safeCompare(VCSGisEntity o1, VCSGisEntity o2) {
                return StringUtils.compare((String)o1.getLabelOrName(), (String)o2.getLabelOrName(), (boolean)true);
            }
        });
        return checkedEntities;
    }

    public void setWorkspace(VCSGisWorkspace workspace) {
        this.checkedEntityCodes.clear();
        this.categoryOfCheckedEntity.clear();
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
        this.workspace = workspace;
        DisposeUtils.bind((Disposable)this.workspace);
        this.reloadEntities();
    }

    public VCSGisWorkspace getWorkspace() {
        return this.workspace;
    }

    public void reloadEntities() {
        this.entities.clear();
        if (this.workspace == null) {
            this.filteredTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
            return;
        }
        if (this.processing) {
            LOGGER.info("Reentrada");
            return;
        }
        Thread task = new Thread(() -> this.reloadEntities(this.workspace), "VCSGisEntitySelectorTreeReloadEntities");
        task.start();
        this.lastThread = task;
    }

    private boolean isCancelled() {
        return Thread.currentThread() != this.lastThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadEntities(VCSGisWorkspace workspace) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            this.fireActionEvent(new ActionEvent((Object)this, 3, "begin_processing"));
            SwingUtilities.invokeLater(() -> this.treeEntities.setCursor(Cursor.getPredefinedCursor(3)));
            this.processing = true;
            this.doUpdateComponents();
            workspace.updateEntitiesFromRepository();
            List allEntities = workspace.getRepositoryEntities();
            List localEntities = workspace.getWorkspaceEntities();
            for (VCSGisWorkspaceEntity localEntity : localEntities) {
                if (this.isCancelled()) {
                    return;
                }
                if (!StringUtils.isBlank((CharSequence)localEntity.getRepositoryRevisionCode())) continue;
                allEntities.add(localEntity);
            }
            Collections.sort(allEntities, new CompareUtils.NullSafeComparator<VCSGisEntity>(){

                public int safeCompare(VCSGisEntity o1, VCSGisEntity o2) {
                    return StringUtils.compare((String)o1.getLabelOrName(), (String)o2.getLabelOrName(), (boolean)true);
                }
            });
            TreeMap<String, DefaultMutableTreeNode> theEntityNodes = new TreeMap<String, DefaultMutableTreeNode>((o1, o2) -> StringUtils.compare((String)o1, (String)o2, (boolean)false));
            HashMap<String, VCSGisEntity> theEntities = new HashMap<String, VCSGisEntity>();
            for (VCSGisEntity entity : allEntities) {
                if (this.isCancelled()) {
                    return;
                }
                VCSGisWorkspaceEntity lentity = workspace.getWorkspaceEntityByCode(entity.getEntityCode());
                String s = StringUtils.isBlank((CharSequence)entity.getRepositoryRevisionCode()) ? VCSGisSwingCommons.getHTMLColorTag(((VCSGisWorkspaceEntity)entity).getState(), this.getLabelOfEntity(entity)) : VCSGisSwingCommons.getHTMLColorTag(lentity == null ? 32 : lentity.getState(), this.getLabelOfEntity(entity));
                if (lentity != null && this.viewFilter.test((VCSGisEntity)lentity)) {
                    entity = lentity;
                } else if (!this.viewFilter.test(entity)) {
                    entity = null;
                }
                if (entity == null) continue;
                theEntities.put(entity.getEntityCode(), entity);
                LabeledValueImpl entry = new LabeledValueImpl(s, (Object)entity);
                List categories = entity.getCategoriesAsList();
                if (CollectionUtils.isNotEmpty((Collection)categories)) {
                    for (String cat : categories) {
                        String category = StringUtils.trimToNull((String)cat);
                        this.addNodeEntity(theEntityNodes, category, (LabeledValue)entry);
                    }
                    continue;
                }
                String category = StringUtils.trimToNull((String)entity.getCategory());
                this.addNodeEntity(theEntityNodes, category, (LabeledValue)entry);
            }
            this.entities = theEntities;
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            for (DefaultMutableTreeNode node : theEntityNodes.values()) {
                if (this.isCancelled()) {
                    return;
                }
                root.add(node);
            }
            if (!this.isCancelled()) {
                this.postReloadEntities(root);
            }
        }
        catch (Exception e) {
            LOGGER.warn("_Cant_retrieve_entities_from_repository", (Throwable)e);
            if (!this.isCancelled()) {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("_Cant_retrieve_entities_from_repository") + "\n" + e.getMessage(), i18n.getTranslation("_VCS_Checkout"), 2);
            }
        }
        finally {
            SwingUtilities.invokeLater(() -> this.treeEntities.setCursor(Cursor.getPredefinedCursor(0)));
            if (!this.isCancelled()) {
                this.processing = false;
                this.doUpdateComponents();
                this.fireActionEvent(new ActionEvent((Object)this, 4, "end_processing"));
            }
        }
    }

    private String getLabelOfEntity(VCSGisEntity entity) {
        String s;
        if (entity == null) {
            return null;
        }
        if (this.labelEntityFormatter == null) {
            return this.workspace.formatEntityLabel(entity);
        }
        try {
            s = this.labelEntityFormatter.apply(entity);
        }
        catch (Exception ex) {
            s = entity.getLabelOrName();
        }
        return s;
    }

    public void setLabelEntityFormatter(Function<VCSGisEntity, String> formatter) {
        this.labelEntityFormatter = formatter;
    }

    public Collection<VCSGisEntity> getEntities() {
        return this.entities.values();
    }

    private void addNodeEntity(Map<String, DefaultMutableTreeNode> theEntityNodes, String category, LabeledValue entry) {
        DefaultMutableTreeNode branch = theEntityNodes.get(category);
        if (branch == null) {
            branch = new DefaultMutableTreeNode(category, true);
            theEntityNodes.put(category, branch);
        }
        branch.add(new DefaultMutableTreeNode(entry, false));
    }

    private void postReloadEntities(DefaultMutableTreeNode entities) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.postReloadEntities(entities))) {
            return;
        }
        this.filteredTree.setModel((TreeModel)new DefaultTreeModel(entities));
        this.expandAllNodes(this.treeEntities);
        this.processing = false;
        this.fireActionEvent(new ActionEvent((Object)this, 2, "reload"));
    }

    private void doUpdateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        this.txtFilter.setEnabled(this.enabled && !this.processing);
        this.btnEntities.setEnabled(this.enabled && !this.processing);
        this.treeEntities.setEnabled(this.enabled && !this.processing);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.treeEntities.setEditable(enabled);
        this.doUpdateComponents();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setChecksEnabled(boolean enabled) {
        this.checksEnabled = enabled;
        if (enabled) {
            this.treeEntities.setCellEditor(new EntityCellEditor());
        } else {
            this.treeEntities.setCellEditor(null);
        }
        this.treeEntities.setEditable(enabled);
    }

    public boolean isChecksEnabled() {
        return this.checksEnabled;
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.addActionListener(al);
    }

    public ActionListener[] getActionListeners() {
        return this.actionListeners.getActionListeners();
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.removeActionListener(al);
    }

    public void removeAllActionListener() {
        this.actionListeners.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent ae) {
        this.actionListeners.fireActionEvent(ae);
    }

    public boolean hasActionListeners() {
        return this.actionListeners.hasActionListeners();
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.addChangeListener(cl);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListeners.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.removeChangeListener(cl);
    }

    public void removeAllChangeListener() {
        this.changeListeners.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListeners.hasChangeListeners();
    }

    public void setViewFilter(Predicate<VCSGisEntity> viewFilter) {
        this.viewFilter = viewFilter;
    }

    public void setFilter(Predicate<VCSGisEntity> filter) {
        this.filter = filter;
    }

    public void check(VCSGisEntity entity) {
        this.checkedEntityCodes.add(entity.getEntityCode());
        this.categoryOfCheckedEntity.put(entity.getEntityCode(), entity.getFirstCategory());
        this.treeEntities.repaint();
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    public void setCheck(Collection<String> entityCodes, boolean check) {
        if (CollectionUtils.isEmpty(entityCodes)) {
            return;
        }
        for (String entityCode : entityCodes) {
            if (check) {
                this.checkedEntityCodes.add(entityCode);
                VCSGisEntity entity = this.entities.get(entityCode);
                if (entity == null) continue;
                this.categoryOfCheckedEntity.put(entityCode, entity.getFirstCategory());
                continue;
            }
            this.checkedEntityCodes.remove(entityCode);
        }
        this.treeEntities.repaint();
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    public void unCheck(VCSGisEntity entity) {
        this.checkedEntityCodes.remove(entity.getEntityCode());
        this.treeEntities.repaint();
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    public void checkAll() {
        for (Map.Entry<String, VCSGisEntity> entry : this.entities.entrySet()) {
            this.checkedEntityCodes.add(entry.getValue().getEntityCode());
        }
        this.treeEntities.repaint();
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    public void clearChecks() {
        this.checkedEntityCodes.clear();
        this.treeEntities.stopEditing();
        this.treeEntities.repaint();
        this.fireActionEvent(new ActionEvent((Object)this, 1, "check"));
    }

    private void expandAllNodes(JTree tree) {
        int j = tree.getRowCount();
        for (int i = 0; i < j; ++i) {
            tree.expandRow(i);
            j = tree.getRowCount();
        }
    }

    private boolean areSelectedAllEntitiesFromCategory(String category) {
        for (Map.Entry<String, VCSGisEntity> entry : this.entities.entrySet()) {
            VCSGisEntity entity = entry.getValue();
            if (!(StringUtils.isBlank((CharSequence)category) ? StringUtils.isBlank((CharSequence)entity.getCategory()) && !this.checkedEntityCodes.contains(entity.getEntityCode()) : entity.getCategoriesAsList().contains(category) && !this.checkedEntityCodes.contains(entity.getEntityCode()))) continue;
            return false;
        }
        return true;
    }

    private Set<String> getAllEntityCodesFromCategory(String category) {
        HashSet<String> entityCodes = new HashSet<String>();
        for (Map.Entry<String, VCSGisEntity> entry : this.entities.entrySet()) {
            VCSGisEntity entity = entry.getValue();
            if (StringUtils.isBlank((CharSequence)category)) {
                if (!StringUtils.isBlank((CharSequence)entity.getCategory())) continue;
                entityCodes.add(entity.getEntityCode());
                continue;
            }
            if (!entity.getCategoriesAsList().contains(category)) continue;
            entityCodes.add(entity.getEntityCode());
        }
        return entityCodes;
    }

    public void clear() {
        this.setWorkspace(null);
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
    }

    public void collapseAll() {
        TreeModel model = this.treeEntities.getModel();
        Object root = model.getRoot();
        for (int i = 0; i < model.getChildCount(root); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getChild(root, i);
            TreePath path = new TreePath(node.getPath());
            this.treeEntities.collapsePath(path);
        }
    }

    public void expandAll() {
        this.expandAllNodes(this.treeEntities);
    }

    private class EntityCellRenderer
    extends DefaultTreeCellRenderer {
        private final JCheckBox check = new JCheckBox();
        private final JPanel panel;
        private final JLabel label = new JLabel();

        public EntityCellRenderer() {
            this.panel = new JPanel();
            this.label.setOpaque(true);
            this.panel.setOpaque(false);
            this.check.setOpaque(false);
            this.panel.setLayout(new FlowLayout(2, 2, 1));
            this.panel.add(this.check);
            this.panel.add(this.label);
            this.setLeafIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Color backgroundColor = UIManager.getColor("Tree.textBackground");
            Color foregroundColor = UIManager.getColor("Tree.textForeground");
            if (selected) {
                backgroundColor = UIManager.getColor("Tree.selectionBackground");
                foregroundColor = UIManager.getColor("Tree.selectionForeground");
            }
            this.label.setBackground(backgroundColor);
            this.label.setForeground(foregroundColor);
            this.label.setText(Objects.toString(value));
            if (VCSGisEntitySelectorControllerJTree.this.checksEnabled) {
                this.check.setVisible(true);
                this.check.setForeground(foregroundColor);
                this.check.setBackground(backgroundColor);
                this.check.setEnabled(false);
                this.check.setSelected(false);
                if (value instanceof DefaultMutableTreeNode) {
                    Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                    if (userObject instanceof LabeledValue) {
                        VCSGisEntity entity = (VCSGisEntity)((LabeledValue)userObject).getValue();
                        if (entity != null) {
                            this.check.setEnabled(true);
                            this.check.setSelected(VCSGisEntitySelectorControllerJTree.this.checkedEntityCodes.contains(entity.getEntityCode()));
                        }
                    } else if (userObject instanceof String || userObject == null) {
                        this.check.setEnabled(true);
                        this.check.setSelected(VCSGisEntitySelectorControllerJTree.this.areSelectedAllEntitiesFromCategory((String)userObject));
                        if (StringUtils.isBlank((CharSequence)((String)userObject))) {
                            I18nManager i18n = ToolsLocator.getI18nManager();
                            this.label.setText(i18n.getTranslation("_Others"));
                        } else {
                            this.label.setText((String)userObject);
                        }
                    }
                }
            } else {
                Object userObject;
                this.check.setVisible(false);
                if (value instanceof DefaultMutableTreeNode && ((userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof String || userObject == null)) {
                    if (StringUtils.isBlank((CharSequence)((String)userObject))) {
                        I18nManager i18n = ToolsLocator.getI18nManager();
                        this.label.setText(i18n.getTranslation("_Others"));
                    } else {
                        this.label.setText((String)userObject);
                    }
                }
            }
            return this.panel;
        }

        protected JCheckBox getCheckBox() {
            return this.check;
        }
    }

    private class EntityCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final JCheckBox check = new JCheckBox();
        private final JPanel panel;
        private final JLabel label = new JLabel();
        private Object currentUserObject;
        private TreePath currentRow;

        public EntityCellEditor() {
            this.panel = new JPanel();
            this.label.setOpaque(true);
            this.panel.setOpaque(false);
            this.check.setOpaque(false);
            this.panel.setLayout(new FlowLayout(2, 2, 1));
            this.panel.add(this.check);
            this.panel.add(this.label);
            this.currentUserObject = null;
            this.currentRow = null;
            this.check.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EntityCellEditor.this.currentUserObject == null) {
                        if (EntityCellEditor.this.check.isSelected()) {
                            VCSGisEntitySelectorControllerJTree.this.checkedEntityCodes.addAll(VCSGisEntitySelectorControllerJTree.this.getAllEntityCodesFromCategory(null));
                        } else {
                            VCSGisEntitySelectorControllerJTree.this.checkedEntityCodes.removeAll(VCSGisEntitySelectorControllerJTree.this.getAllEntityCodesFromCategory(null));
                        }
                        EntityCellEditor.this.postCheck();
                        return;
                    }
                    if (!(EntityCellEditor.this.currentUserObject instanceof LabeledValue)) {
                        String category = (String)EntityCellEditor.this.currentUserObject;
                        if (EntityCellEditor.this.check.isSelected()) {
                            Set x = VCSGisEntitySelectorControllerJTree.this.getAllEntityCodesFromCategory(category);
                            VCSGisEntitySelectorControllerJTree.this.checkedEntityCodes.addAll(x);
                            for (String entityCode : x) {
                                VCSGisEntitySelectorControllerJTree.this.categoryOfCheckedEntity.put(entityCode, category);
                            }
                        } else {
                            Set x = VCSGisEntitySelectorControllerJTree.this.getAllEntityCodesFromCategory(category);
                            VCSGisEntitySelectorControllerJTree.this.checkedEntityCodes.removeAll(x);
                            for (String entityCode : x) {
                                VCSGisEntitySelectorControllerJTree.this.categoryOfCheckedEntity.remove(entityCode);
                            }
                        }
                        EntityCellEditor.this.postCheck();
                        return;
                    }
                    VCSGisEntity entity = (VCSGisEntity)((LabeledValue)EntityCellEditor.this.currentUserObject).getValue();
                    if (entity == null) {
                        return;
                    }
                    String entityCode = entity.getEntityCode();
                    if (EntityCellEditor.this.check.isSelected()) {
                        VCSGisEntitySelectorControllerJTree.this.checkedEntityCodes.add(entityCode);
                        VCSGisEntitySelectorControllerJTree.this.categoryOfCheckedEntity.put(entityCode, EntityCellEditor.this.getCategoryFromCurrentRow());
                    } else {
                        VCSGisEntitySelectorControllerJTree.this.checkedEntityCodes.remove(entityCode);
                        VCSGisEntitySelectorControllerJTree.this.categoryOfCheckedEntity.remove(entityCode);
                    }
                    EntityCellEditor.this.postCheck();
                }
            });
        }

        private String getCategoryFromCurrentRow() {
            try {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.currentRow.getParentPath().getLastPathComponent();
                if (parent == null) {
                    return null;
                }
                return (String)parent.getUserObject();
            }
            catch (Exception ex) {
                return null;
            }
        }

        private void postCheck() {
            this.stopCellEditing();
            VCSGisEntitySelectorControllerJTree.this.treeEntities.repaint();
            VCSGisEntitySelectorControllerJTree.this.fireActionEvent(new ActionEvent(this, 1, "check"));
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentUserObject;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            Color backgroundColor = UIManager.getColor("Tree.textBackground");
            Color foregroundColor = UIManager.getColor("Tree.textForeground");
            if (selected) {
                backgroundColor = UIManager.getColor("Tree.selectionBackground");
                foregroundColor = UIManager.getColor("Tree.selectionForeground");
            }
            this.label.setBackground(backgroundColor);
            this.label.setForeground(foregroundColor);
            I18nManager i18n = ToolsLocator.getI18nManager();
            if (VCSGisEntitySelectorControllerJTree.this.checksEnabled) {
                this.check.setVisible(true);
                this.check.setEnabled(false);
                this.check.setSelected(false);
                if (value instanceof DefaultMutableTreeNode) {
                    this.currentUserObject = ((DefaultMutableTreeNode)value).getUserObject();
                    this.currentRow = tree.getPathForRow(row);
                    if (this.currentUserObject instanceof LabeledValue) {
                        VCSGisEntity entity = (VCSGisEntity)((LabeledValue)this.currentUserObject).getValue();
                        if (entity != null) {
                            this.check.setEnabled(true);
                            this.check.setSelected(VCSGisEntitySelectorControllerJTree.this.checkedEntityCodes.contains(entity.getEntityCode()));
                            this.label.setText(((LabeledValue)this.currentUserObject).getLabel());
                        }
                    } else if (this.currentUserObject instanceof String || this.currentUserObject == null) {
                        this.check.setEnabled(true);
                        this.check.setSelected(VCSGisEntitySelectorControllerJTree.this.areSelectedAllEntitiesFromCategory((String)this.currentUserObject));
                        if (StringUtils.isBlank((CharSequence)((String)this.currentUserObject))) {
                            this.label.setText(i18n.getTranslation("_Others"));
                        } else {
                            this.label.setText(i18n.getTranslation((String)this.currentUserObject));
                        }
                    }
                }
            } else {
                this.check.setVisible(false);
            }
            return this.panel;
        }
    }
}

