/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.MapBuilder;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisSwingCommons {
    public static final String BOOKMARKSANDHISTORY_REPOSITORY_URL = "VCSGisRepositoryURL";
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisSwingCommons.class);
    private static final String ID_COLOR_LOCAL_NEW = "COLOR_LOCAL_NEW";
    private static final String ID_COLOR_LOCAL_MODIFIED = "COLOR_LOCAL_MODIFIED";
    private static final String ID_COLOR_LOCAL_UNMODIFIED = "COLOR_LOCAL_UNMODIFIED";
    private static final String ID_COLOR_LOCAL_AND_REPOSITORY_MODIFIED = "COLOR_LOCAL_AND_REPOSITORY_MODIFIED";
    private static final String ID_COLOR_REPOSITORY_NEW = "COLOR_REPOSITORY_NEW";
    private static final String ID_COLOR_REPOSITORY_MODIFIED = "COLOR_REPOSITORY_MODIFIED";
    private static final String ID_COLOR_CONFLICT = "COLOR_CONFLICT";
    private static final String ID_COLOR_UNKNOWN_STATE = "COLOR_UNKNOWN_STATE";
    private static final String ID_COLOR_DISCONNECTED_STATE = "COLOR_DISCONNETED_STATE";
    private static final Color COLOR_LOCAL_NEW = Color.GREEN.darker();
    private static final Color COLOR_LOCAL_MODIFIED = Color.BLUE.darker();
    private static final Color COLOR_LOCAL_UNMODIFIED = Color.BLACK;
    private static final Color COLOR_LOCAL_AND_REPOSITORY_MODIFIED = Color.RED.brighter();
    private static final Color COLOR_REPOSITORY_NEW = Color.ORANGE.darker().darker();
    private static final Color COLOR_REPOSITORY_MODIFIED = Color.MAGENTA.darker();
    private static final Color COLOR_CONFLICT = Color.RED;
    private static final Color COLOR_UNKNOWN_STATE = Color.LIGHT_GRAY;
    private static final Color COLOR_DISCONNECTED_STATE = Color.DARK_GRAY;
    private static Map<String, Color> entityColors = null;
    private static final Map<Integer, String> OPERATION_LABELS_UI = new MapBuilder().add((Object)0, (Object)"_VCS_operation_delete").add((Object)1, (Object)"_VCS_operation_update").add((Object)2, (Object)"_VCS_operation_insert").add((Object)3, (Object)"_VCS_operation_add_entity").build();

    public static String getHTMLColorTag(Color color, String text) {
        return VCSGisSwingCommons.getHTMLColorTag(color, false, text);
    }

    public static String getHTMLColorTag(Color color, boolean bold, String text) {
        return VCSGisSwingCommons.getHTMLColorTag(color, bold, false, text);
    }

    public static String getHTMLColorTag(Color color, boolean bold, boolean strikethrough, String text) {
        String pattern = bold && strikethrough ? "<html><font color='rgb(%s, %s, %s)'><i><s>%s</i></s></font></html>" : (bold ? "<html><font color='rgb(%s, %s, %s)'><i>%s</i></font></html>" : (strikethrough ? "<html><font color='rgb(%s, %s, %s)'><s>%s</s></font></html>" : "<html><font color='rgb(%s, %s, %s)'>%s</font></html>"));
        String tag = String.format(pattern, color.getRed(), color.getGreen(), color.getBlue(), text);
        return tag;
    }

    public static String getHTMLColorTag(int state, String text) {
        switch (state) {
            case 256: 
            case 384: {
                return VCSGisSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_DISCONNECTED_STATE), false, true, text);
            }
            case 128: {
                return VCSGisSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_DISCONNECTED_STATE), false, text);
            }
            case 1: {
                return VCSGisSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_LOCAL_UNMODIFIED), false, text);
            }
            case 2: {
                return VCSGisSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_LOCAL_NEW), false, text);
            }
            case 4: {
                return VCSGisSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_LOCAL_MODIFIED), false, text);
            }
            case 6: {
                return VCSGisSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_REPOSITORY_MODIFIED), false, text);
            }
            case 8: {
                return VCSGisSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_LOCAL_AND_REPOSITORY_MODIFIED), false, text);
            }
            case 16: {
                return VCSGisSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_CONFLICT), false, text);
            }
            case 32: {
                return VCSGisSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_REPOSITORY_NEW), false, text);
            }
        }
        return VCSGisSwingCommons.getHTMLColorTag(entityColors.get(ID_COLOR_UNKNOWN_STATE), false, text);
    }

    public static String getHTMLColorTag(VCSGisWorkspace workspace, String entityName) {
        if (workspace == null) {
            return entityName;
        }
        VCSGisEntity rentity = workspace.getRepositoryEntity(entityName);
        VCSGisWorkspaceEntity lentity = workspace.getWorkspaceEntity(entityName);
        if (rentity == null && lentity == null) {
            return entityName;
        }
        if (lentity == null) {
            return VCSGisSwingCommons.getHTMLColorTag(32, entityName);
        }
        return VCSGisSwingCommons.getHTMLColorTag(lentity.getState(), entityName);
    }

    public static String getStateDescription(VCSGisWorkspace workspace, String entityName) {
        if (workspace == null) {
            return VCSGisSwingCommons.getStateDescription(0);
        }
        VCSGisEntity rentity = workspace.getRepositoryEntity(entityName);
        VCSGisWorkspaceEntity lentity = workspace.getWorkspaceEntity(entityName);
        if (rentity == null && lentity == null) {
            return VCSGisSwingCommons.getStateDescription(64);
        }
        if (lentity == null) {
            return VCSGisSwingCommons.getStateDescription(32);
        }
        return VCSGisSwingCommons.getStateDescription(lentity.getState());
    }

    public static String getStateDescription(int state) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        switch (state) {
            case 128: {
                return i18n.getTranslation("_Disconnected");
            }
            case 256: {
                return i18n.getTranslation("_Corrupt");
            }
            case 384: {
                return i18n.getTranslation("_Corrupt") + "/" + i18n.getTranslation("_Disconnected");
            }
            case 1: {
                return i18n.getTranslation("_Unmodified_locally");
            }
            case 2: {
                return i18n.getTranslation("_New_locally");
            }
            case 4: {
                return i18n.getTranslation("_Modified_locally");
            }
            case 6: {
                return i18n.getTranslation("_Modified_in_the_repository");
            }
            case 8: {
                return i18n.getTranslation("_Modified_in_the_repository_and_locally");
            }
            case 16: {
                return i18n.getTranslation("_Conflict");
            }
            case 32: {
                return i18n.getTranslation("_New_in_the_repository");
            }
            case 64: {
                return i18n.getTranslation("_It_is_not_in_local_or_in_the_repository");
            }
        }
        return i18n.getTranslation("_Unknow_state");
    }

    public static void setColorCompoment(Component c, Color color, boolean bold) {
        VCSGisSwingCommons.setColorCompoment(c, color, bold, false);
    }

    public static void setColorCompoment(Component c, Color color, boolean bold, boolean strikethrough) {
        if (bold) {
            Font f = c.getFont();
            Map<TextAttribute, ?> attributes = f.getAttributes();
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            c.setFont(c.getFont().deriveFont(attributes));
        }
        c.setForeground(color);
    }

    public static void setColorCompoment(Component c, int state) {
        switch (state) {
            case 256: 
            case 384: {
                VCSGisSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_DISCONNECTED_STATE), false, true);
                break;
            }
            case 128: {
                VCSGisSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_DISCONNECTED_STATE), false);
                break;
            }
            case 1: {
                VCSGisSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_LOCAL_UNMODIFIED), false);
                break;
            }
            case 2: {
                VCSGisSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_LOCAL_NEW), false);
                break;
            }
            case 4: {
                VCSGisSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_LOCAL_MODIFIED), false);
                break;
            }
            case 6: {
                VCSGisSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_REPOSITORY_MODIFIED), false);
                break;
            }
            case 8: {
                VCSGisSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_LOCAL_AND_REPOSITORY_MODIFIED), false);
                break;
            }
            case 16: {
                VCSGisSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_CONFLICT), false);
                break;
            }
            case 32: {
                VCSGisSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_REPOSITORY_NEW), false);
                break;
            }
            default: {
                VCSGisSwingCommons.setColorCompoment(c, entityColors.get(ID_COLOR_UNKNOWN_STATE), false);
            }
        }
    }

    public static boolean notInSwingThreadInvokeLater(Runnable x) {
        if (SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        SwingUtilities.invokeLater(x);
        return true;
    }

    public static void cleanHighligthed() {
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        swingManager.getDefaultServices().cleanHighligthed();
    }

    public static void refreshDocument(FeatureStore store) {
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        swingManager.getDefaultServices().refreshDocument(store);
    }

    public static void refreshDocument(Set<FeatureStore> stores) {
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        swingManager.getDefaultServices().refreshDocument(stores);
    }

    public static Geometry createBBox(Geometry geom1, Geometry geom2) {
        if (geom1 == null && geom2 == null) {
            return null;
        }
        Envelope env = GeometryUtils.createEnvelope((int)0);
        if (geom1 != null) {
            env.add(geom1);
        }
        if (geom2 != null) {
            env.add(geom2);
        }
        return env.getGeometry();
    }

    public static boolean showAuthenticationErrors(String title, VCSGisRuntimeException ex) {
        return VCSGisSwingCommons.showAuthenticationErrors(title, ex.getErrnum(), ex.getMessage());
    }

    public static boolean showAuthenticationErrors(String title, int errNum) {
        return VCSGisSwingCommons.showAuthenticationErrors(title, errNum, null);
    }

    public static boolean showAuthenticationErrors(String title, int errNum, String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            message = VCSGisLocator.getManager().getErrorMessage(errNum);
        }
        switch (errNum) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                I18nManager i18n = ToolsLocator.getI18nManager();
                dialogs.messageDialog("[" + errNum + "] " + message, i18n.getTranslation(title), 2);
                return true;
            }
        }
        return false;
    }

    public static boolean showAuthenticationRequiredMessage(String title) {
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        dialogs.messageDialog(i18n.getTranslation("_Authorization_required_for_this_operation"), i18n.getTranslation(title), 2);
        return true;
    }

    private static void loadColors() {
        entityColors = new HashMap<String, Color>();
        entityColors.put(ID_COLOR_LOCAL_NEW, COLOR_LOCAL_NEW);
        entityColors.put(ID_COLOR_LOCAL_MODIFIED, COLOR_LOCAL_MODIFIED);
        entityColors.put(ID_COLOR_LOCAL_UNMODIFIED, COLOR_LOCAL_UNMODIFIED);
        entityColors.put(ID_COLOR_LOCAL_AND_REPOSITORY_MODIFIED, COLOR_LOCAL_AND_REPOSITORY_MODIFIED);
        entityColors.put(ID_COLOR_REPOSITORY_NEW, COLOR_REPOSITORY_NEW);
        entityColors.put(ID_COLOR_REPOSITORY_MODIFIED, COLOR_REPOSITORY_MODIFIED);
        entityColors.put(ID_COLOR_CONFLICT, COLOR_CONFLICT);
        entityColors.put(ID_COLOR_UNKNOWN_STATE, COLOR_UNKNOWN_STATE);
        entityColors.put(ID_COLOR_DISCONNECTED_STATE, COLOR_DISCONNECTED_STATE);
        InputStream x = VCSGisSwingCommons.class.getClassLoader().getResourceAsStream("/VCSGisEntityColors.properties");
        Coercion toColor = ToolsLocator.getDataTypesManager().getCoercion(96);
        if (x != null) {
            try {
                Properties prop = new Properties();
                prop.load(x);
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    try {
                        entityColors.put((String)entry.getKey(), (Color)toColor.coerce(entry.getValue()));
                    }
                    catch (CoercionException ex) {
                        LOGGER.trace("Can't parse color " + Objects.toString(entry.getKey()), (Throwable)ex);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.trace("Can't load colors.", (Throwable)ex);
            }
        }
    }

    public static String getOperationLabel(int operation) {
        return OPERATION_LABELS_UI.getOrDefault(operation, "unknown");
    }

    public static boolean hasConflictTheDatamodelWithOtherModelAlreadyRegistered(VCSGisWorkspace workspace, String dataModelName) {
        DataManager dataManager = DALLocator.getDataManager();
        String wsUrl = workspace.getExplorerParameters().getUrl();
        StoresRepository globalRepository = dataManager.getStoresRepository();
        for (VCSGisEntity entity : workspace.getRepositoryEntities()) {
            String registeredUrl;
            DataStoreParameters params;
            List entityModels = entity.getDataModelsAsList();
            if (!entityModels.contains(dataModelName) || !((params = (DataStoreParameters)globalRepository.get((Object)entity.getEntityName())) instanceof JDBCStoreParameters) || StringUtils.equals((CharSequence)wsUrl, (CharSequence)(registeredUrl = ((JDBCStoreParameters)params).getUrl()))) continue;
            return true;
        }
        return false;
    }

    static {
        VCSGisSwingCommons.loadColors();
    }
}

