/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.changes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonObject;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.lib.api.TopologyManager;
import org.gvsig.topology.lib.api.TopologyPlan;
import org.gvsig.topology.lib.api.TopologyServices;
import org.gvsig.topology.swing.api.JTopologyReport;
import org.gvsig.topology.swing.api.TopologySwingLocator;
import org.gvsig.topology.swing.api.TopologySwingManager;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatus;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;

public class TopologyPlansExecutor {
    public boolean execute(VCSGisWorkspace ws, List<VCSGisEntity> entities, List<VCSGisTopologyPlanStatus> topologicPlanStatusList, boolean autoClose) {
        String topologyPlanCode;
        I18nManager i18n = ToolsLocator.getI18nManager();
        TopologyManager topologyManager = TopologyLocator.getTopologyManager();
        TopologySwingManager swingManager = TopologySwingLocator.getTopologySwingManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        VCSGisManager manager = VCSGisLocator.getManager();
        HashMap<String, VCSGisTopologyPlanStatus> topologicPlanStatusMap = new HashMap<String, VCSGisTopologyPlanStatus>();
        HashMap<String, TopologyPlan> topologyPlans = new HashMap<String, TopologyPlan>();
        for (VCSGisEntity vCSGisEntity : entities) {
            topologyPlanCode = vCSGisEntity.getTopologyPlanCode();
            VCSGisTopologyPlan topologyPlan = ws.getTopologyPlan(topologyPlanCode);
            if (topologyPlan == null || StringUtils.isBlank((CharSequence)topologyPlan.getData())) continue;
            TopologyPlan plan = topologyManager.createTopologyPlan();
            JsonObject planJson = Json.createObject((String)topologyPlan.getData());
            plan.fromJson(planJson);
            VCSGisTopologyPlanServices topologyServices = new VCSGisTopologyPlanServices(ws, plan.getTopologyServices());
            plan.setTopologyServices((TopologyServices)topologyServices);
            if (!plan.hasRules()) continue;
            topologyPlans.put(topologyPlanCode, plan);
            VCSGisTopologyPlanStatus topologyPlanStatus = manager.createTopologyPlanStatus(topologyPlanCode, topologyPlan.getHashCode(), false);
            topologicPlanStatusMap.put(topologyPlanCode, topologyPlanStatus);
        }
        if (topologyPlans.isEmpty()) {
            return true;
        }
        for (Map.Entry entry : topologyPlans.entrySet()) {
            topologyPlanCode = (String)entry.getKey();
            TopologyPlan plan = (TopologyPlan)entry.getValue();
            JTopologyReport panel = swingManager.createJTopologyReport(plan);
            panel.put(plan);
            SwingUtilities.invokeLater(() -> winManager.showWindow(panel.asJComponent(), i18n.getTranslation("_Topology_plan_error_inspector") + " (" + plan.getName() + ")", WindowManager.MODE.TOOL));
            try {
                VCSGisTopologyPlanStatus status;
                boolean passed;
                plan.execute();
                boolean bl = passed = plan.getReport().getStatus() == 0;
                if (passed) {
                    if (autoClose) {
                        SwingUtilities.invokeLater(() -> panel.asJComponent().setVisible(false));
                    }
                } else {
                    for (VCSGisEntity entity : entities) {
                        String code = entity.getTopologyPlanCode();
                        int mode = entity.getTopologyPlanMode();
                        if (StringUtils.equals((CharSequence)code, (CharSequence)topologyPlanCode) && mode == 1) {
                            return false;
                        }
                        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                        int res = dialogs.confirmDialog(i18n.getTranslation("_Topology_plan_execution_failed_Do_you_wish_to_continue"), i18n.getTranslation("_Topology_plan"), 0, 3);
                        if (res == 0) continue;
                        return false;
                    }
                }
                if ((status = (VCSGisTopologyPlanStatus)topologicPlanStatusMap.get(topologyPlanCode)) == null) continue;
                status.setPassed(passed);
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (topologicPlanStatusList != null) {
            topologicPlanStatusList.clear();
            topologicPlanStatusList.addAll(topologicPlanStatusMap.values());
        }
        return true;
    }

    private static class VCSGisTopologyPlanServices
    implements TopologyServices {
        private final VCSGisWorkspace ws;
        private final TopologyServices topologyServices;

        public VCSGisTopologyPlanServices(VCSGisWorkspace ws, TopologyServices topologyServices) {
            this.ws = ws;
            this.topologyServices = topologyServices;
        }

        public FeatureStore getFeatureStore(TopologyDataSet tds) {
            FeatureStore store = this.ws.openFeatureStore(tds.getName(), false);
            if (store == null) {
                store = this.topologyServices.getFeatureStore(tds);
            }
            return store;
        }
    }
}

