/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.checkoutDataModel;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.ContainerUtils;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.VCSGisJCheckoutDataModel;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.checkoutDataModel.VCSGisJCheckoutDataModelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJCheckoutDataModelImpl
extends VCSGisJCheckoutDataModelView
implements Component,
VCSGisJCheckoutDataModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJCheckoutDataModelImpl.class);
    private Dialog dialog;
    private boolean processing = false;
    private PickerController<VCSGisWorkspace> workspacePicker;
    private TaskStatusController taskStatusController;
    private VCSGisEntitySelectorController entitySelector;
    private List<VCSGisEntity> validCheckoutEntities;
    private List<VCSGisEntity> validUpdateEntities;
    private String defaultModel = null;

    public VCSGisJCheckoutDataModelImpl() {
        this.initComponents();
    }

    public VCSGisJCheckoutDataModelImpl(VCSGisWorkspace workspace, String model) {
        this();
        this.defaultModel = model;
        SwingUtilities.invokeLater(() -> this.workspacePicker.set((Object)workspace));
    }

    private void initComponents() {
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        this.translate();
        this.btnCheckAllEntities.setCursor(Cursor.getPredefinedCursor(12));
        this.btnUnCheckAllEntities.setCursor(Cursor.getPredefinedCursor(12));
        this.entitySelector = VCSGisSwingLocator.getVCSGisSwingManager().createEntitySelectorController(this.lstTables, (JTextComponent)this.txtFilter, this.btnTable, this.btnCheckAllEntities, this.btnUnCheckAllEntities);
        this.entitySelector.setFilter(VCSGisEntitySelectorController.ALL_ENTITIES);
        this.entitySelector.setViewFilter(VCSGisEntitySelectorController.ALL_ENTITIES);
        this.entitySelector.setChecksEnabled(true);
        this.entitySelector.addChangeListener(e -> this.doUpdateComponents());
        this.entitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 2: {
                    SwingUtilities.invokeLater(() -> this.doCheckDefaultEntities());
                    break;
                }
                case 3: {
                    this.doUpdateComponents();
                    break;
                }
                case 4: {
                    this.doUpdateComponents();
                    break;
                }
                case 1: {
                    this.doChangeCheckedEntities();
                }
            }
        });
        this.taskStatusController = taskStatusManager.createTaskStatusController(this.lblStatusTitle, this.lblStatusMessages, this.pbStatus);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind(ToolsLocator.getTaskStatusManager());
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspaces, this.btnInitWorkspace);
        this.workspacePicker.addChangeListener(e -> {
            this.doChangeWorkspace();
            this.doUpdateComponents();
        });
        this.cboDataModels.addItemListener(e -> this.doChangeDataModel());
        if (ToolsSwingLocator.getToolsSwingManager().isModalDialogShowing()) {
            this.chkCloseWindowOnConnect.setSelected(true);
            this.chkCloseWindowOnConnect.setEnabled(false);
        }
        ComboBoxModel viewDocumentsModel = services.getViewDocumentsComboBoxModel();
        this.showMessage(" ", null);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)22, (int)60);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusTitle.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblStatusMessages.setVisible(true);
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeWorkspace() {
        Cursor savedCursor = this.getCursor();
        try {
            this.processing = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            VCSGisWorkspace ws = this.getWorkspace();
            this.entitySelector.clear();
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel();
            this.cboDataModels.setModel(model);
            this.cboDataModels.setSelectedIndex(-1);
            if (ws != null) {
                if (ws.isOffline() || ws.authenticate(null)) {
                    List dataModels = ws.getDataModels();
                    if (!CollectionUtils.isEmpty((Collection)dataModels)) {
                        this.entitySelector.setWorkspace(ws);
                        model = new DefaultComboBoxModel<String>(dataModels.toArray(new String[0]));
                        this.cboDataModels.setModel(model);
                        if (model.getSize() == 1) {
                            this.cboDataModels.setSelectedIndex(0);
                            this.doChangeDataModel();
                        } else {
                            this.cboDataModels.setSelectedIndex(-1);
                        }
                        if (StringUtils.isNotBlank((CharSequence)this.defaultModel)) {
                            this.cboDataModels.setSelectedItem(this.defaultModel);
                        }
                        this.doUpdateComponents();
                        return;
                    }
                } else {
                    VCSGisSwingCommons.showAuthenticationRequiredMessage("_VCS_Checkout");
                }
            }
            this.doUpdateComponents();
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't set workspace.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Checkout", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't set workspace.", (Throwable)e2);
        }
        finally {
            this.processing = false;
            this.setCursor(savedCursor);
        }
    }

    public VCSGisWorkspace getWorkspace() {
        return (VCSGisWorkspace)this.workspacePicker.get();
    }

    private void doUpdateComponents() {
        boolean canConnect;
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        this.showMessage("");
        I18nManager i18n = ToolsLocator.getI18nManager();
        VCSGisWorkspace workspace = this.getWorkspace();
        boolean isProcessing = this.processing || this.entitySelector.isProcessing();
        boolean bl = canConnect = !VCSGisLocator.getVCSGisManager().IsThereConflictingStoresInEdition();
        if (!canConnect) {
            this.showMessage(i18n.getTranslation("_There_is_some_table_that_can_be_conflicting_in_editing_mode"));
        }
        canConnect = canConnect && !isProcessing && workspace != null && this.cboDataModels.getSelectedIndex() >= 0;
        this.workspacePicker.setEnabled(!isProcessing);
        this.cboDataModels.setEnabled(workspace != null);
        this.entitySelector.setEnabled(!isProcessing && this.cboDataModels.getModel().getSize() > 0);
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, canConnect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int connectToModel() {
        int n;
        I18nManager i18n = ToolsLocator.getI18nManager();
        List checkedEntities = this.entitySelector.getCheckedEntities();
        VCSGisWorkspace workspace = this.getWorkspace();
        String dataModelName = this.getDataModel();
        if (workspace == null) {
            return 0;
        }
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Connect to model");
        status.setAutoremove(true);
        status.add();
        status.message(i18n.getTranslation("_Connecting_to_{0}", new String[]{this.getDataModel()}));
        status.setRangeOfValues(0L, (long)checkedEntities.size());
        status.setCurValue(0L);
        try {
            ThreadSafeDialogsManager dialogs2;
            int n2;
            if (VCSGisSwingCommons.hasConflictTheDatamodelWithOtherModelAlreadyRegistered(workspace, dataModelName) && (n2 = (dialogs2 = ToolsSwingLocator.getThreadSafeDialogsManager()).confirmDialog(i18n.getTranslation("_The_name_of_some_tables_of_the_data_model_coincide_with_those_of_another_model_already_registered") + "\n" + i18n.getTranslation("_If_you_connect_to_this_model_and_have_tables_or_layers_loaded_from_the_previous_model_you_may_notice_inconsistencies_in_the_data") + "\n" + i18n.getTranslation("_Do_you_want_to_connect_with_the_current_model_anyway"), i18n.getTranslation("_VCS_Connect_to_datamodel"), 0, 3)) != 0) {
                int n3 = 10000;
                return n3;
            }
            if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
                this.registerDataModelRepository(workspace, dataModelName);
                this.setVisibleStatus(false);
                status.terminate();
                Thread.sleep(1000L);
                this.showMessage(i18n.getTranslation("_Connected_to_{0}", new String[]{this.getDataModel()}), null);
                if (this.chkCloseWindowOnConnect.isSelected()) {
                    this.setVisible(false);
                }
                int dialogs2 = 0;
                return dialogs2;
            }
            Collection allEntities = this.entitySelector.getEntities();
            this.setVisibleStatus(true);
            this.processing = true;
            this.doUpdateComponents();
            this.showMessage(i18n.getTranslation("_Processing"), null);
            ArrayList<String> entityNamesToCheckout = new ArrayList<String>();
            ArrayList<String> entityNamesToUpdate = new ArrayList<String>();
            for (VCSGisEntity entity : checkedEntities) {
                if (this.canCheckout(entity) && !this.isResource(checkedEntities, entity)) {
                    entityNamesToCheckout.add(entity.getEntityName());
                }
                if (!this.canUpdate(entity)) continue;
                entityNamesToUpdate.add(entity.getEntityName());
            }
            int res = 0;
            if (!entityNamesToCheckout.isEmpty()) {
                res = workspace.checkout(entityNamesToCheckout, status);
            }
            if (res == 0) {
                if (!entityNamesToUpdate.isEmpty()) {
                    res = workspace.update(entityNamesToUpdate, status);
                }
                status.message("Updating custom resources");
                for (VCSGisEntity entity : allEntities) {
                    VCSGisEntity lEntity = workspace.getEntity(entity.getEntityCode());
                    if (!StringUtils.isNotBlank((CharSequence)lEntity.getResources())) continue;
                    workspace.getExplorer().setCustomResources(entity.getEntityName(), lEntity.getResources(), true);
                }
                status.message("Register model");
                status.message("");
                this.postConnectToModel(res, checkedEntities, dataModelName);
            }
            status.terminate();
            int n4 = res;
            return n4;
        }
        catch (UserCancelledException ex) {
            LOGGER.warn("Can't connect to model.", (Throwable)ex);
            status.cancel();
            n = 600;
            return n;
        }
        catch (Throwable t) {
            status.abort();
            LOGGER.warn("Can't connect to model.", t);
            n = 600;
            return n;
        }
        finally {
            if (status.isRunning()) {
                status.terminate();
            }
            this.processing = false;
            this.doUpdateComponents();
        }
    }

    private void postConnectToModel(int checkoutStatus, List<VCSGisEntity> entities, String model) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.postConnectToModel(checkoutStatus, entities, model))) {
            return;
        }
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        VCSGisWorkspace workspace = this.getWorkspace();
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Connect to model");
        status.add();
        try {
            if (checkoutStatus == 0) {
                this.registerDataModelRepository(workspace, model);
                HashSet<FeatureStore> stores = new HashSet<FeatureStore>();
                for (VCSGisEntity entity : entities) {
                    FeatureStore store = workspace.getFeatureStore(entity.getEntityName());
                    stores.add(store);
                }
                for (FeatureStore store : stores) {
                    if (store != null) {
                        status.message("Updating table/layer " + store.getName());
                        services.refreshDocument(store);
                    }
                    DisposeUtils.dispose((Disposable)store);
                }
            } else {
                this.setVisibleStatus(true);
            }
            this.entitySelector.reloadEntities();
            this.doCheckDefaultEntities();
            this.processing = false;
            status.terminate();
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.showMessage(i18n.getTranslation("_Connected_to_{0}", new String[]{this.getDataModel()}), null);
            this.doUpdateComponents();
            if (this.chkCloseWindowOnConnect.isSelected()) {
                this.setVisible(false);
            }
        }
        catch (Exception e) {
            status.abort();
        }
    }

    private boolean isResource(List<VCSGisEntity> entities, VCSGisEntity entity) {
        if (entities == null || entities.isEmpty()) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        String resourceName = entity.getEntityName();
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            return false;
        }
        for (VCSGisEntity entity1 : entities) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)resourceName, (CharSequence)entity1.getResources())) continue;
            return true;
        }
        return false;
    }

    private void showMessage(String message) {
        this.showMessage(message, null);
    }

    private void showMessage(String message, String toolTipText) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.showMessage(message, toolTipText))) {
            return;
        }
        this.lblStatusMessages.setText(message);
        this.lblStatusMessages.setToolTipText(toolTipText);
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspace);
        swingManager.translate(this.lblDataModel);
        swingManager.translate((AbstractButton)this.btnCheckAllEntities);
        swingManager.translate((AbstractButton)this.btnUnCheckAllEntities);
        swingManager.translate((AbstractButton)this.chkCloseWindowOnConnect);
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public static void selfRegister() {
        String[][] iconsInfo = new String[][]{{"VCSGis", "vcsgis", "vcsgis-common-checkout"}};
        VCSGisSwingManagerImpl.registerIcons(iconsInfo);
    }

    public String getDataModel() {
        return (String)this.cboDataModels.getSelectedItem();
    }

    private void doChangeDataModel() {
        String selectedDataModel = this.getDataModel();
        this.entitySelector.clearChecks();
        this.entitySelector.setViewFilter(t -> ContainerUtils.contains((Collection)t.getDataModelsAsList(), (Object)selectedDataModel, (Comparator)ContainerUtils.EQUALS_IGNORECASE_COMPARATOR));
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    private void calculateUpdateAndCheckoutEntities() {
        VCSGisWorkspace ws = this.getWorkspace();
        if (ws == null) {
            this.validCheckoutEntities = new ArrayList<VCSGisEntity>();
            this.validUpdateEntities = new ArrayList<VCSGisEntity>();
            return;
        }
        ArrayList<VCSGisEntity> theValidUpdateEntities = new ArrayList<VCSGisEntity>();
        ArrayList<VCSGisEntity> theValidCheckoutEntities = new ArrayList<VCSGisEntity>();
        Collection entities = this.entitySelector.getEntities();
        for (VCSGisEntity entity : entities) {
            if (ws.existsInWorkspace(entity)) {
                VCSGisWorkspaceEntity lentity = ws.getWorkspaceEntityByCode(entity.getEntityCode());
                switch (lentity.getState()) {
                    default: {
                        break;
                    }
                    case 6: 
                    case 32: {
                        theValidUpdateEntities.add(entity);
                        break;
                    }
                }
                continue;
            }
            theValidCheckoutEntities.add(entity);
        }
        this.validCheckoutEntities = theValidCheckoutEntities;
        this.validUpdateEntities = theValidUpdateEntities;
    }

    private boolean canCheckout(VCSGisEntity entity) {
        return ContainerUtils.contains(this.validCheckoutEntities, (Object)entity, (o1, o2) -> StringUtils.compareIgnoreCase((String)o1.getEntityName(), (String)o2.getEntityName()));
    }

    private boolean canUpdate(VCSGisEntity entity) {
        return ContainerUtils.contains(this.validUpdateEntities, (Object)entity, (o1, o2) -> StringUtils.compareIgnoreCase((String)o1.getEntityName(), (String)o2.getEntityName()));
    }

    private void doCheckDefaultEntities() {
        VCSGisWorkspace ws = this.getWorkspace();
        if (ws == null) {
            this.doUpdateComponents();
            return;
        }
        this.calculateUpdateAndCheckoutEntities();
        this.entitySelector.clearChecks();
        Collection entities = this.entitySelector.getEntities();
        for (VCSGisEntity entity : entities) {
            if (!this.canCheckout(entity) && !this.canUpdate(entity)) continue;
            this.entitySelector.check(entity);
        }
        this.doUpdateComponents();
    }

    private void doChangeCheckedEntities() {
        VCSGisWorkspace ws = this.getWorkspace();
        if (ws == null) {
            return;
        }
        List checkedEntities = this.entitySelector.getCheckedEntities();
        for (VCSGisEntity entity : checkedEntities) {
            if (this.canCheckout(entity) || this.canUpdate(entity)) continue;
            this.entitySelector.unCheck(entity);
        }
        this.doUpdateComponents();
    }

    private void registerDataModelRepository(VCSGisWorkspace workspace, String dataModelName) {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        workspace.registerDataModelRepository(dataModelName);
        services.connectedToModel(workspace, dataModelName);
    }
}

