/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.downloadworkspace;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.compress.utils.CountingOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.TextFieldWithHistoryAndBookmarkController;
import org.gvsig.tools.swing.api.pickercontroller.FolderPickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisPreparedWorkingCopyInformation;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJDownloadWorkingcopy;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.downloadworkspace.DownloadWorkingcopyImplView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadWorkingcopyImpl
extends DownloadWorkingcopyImplView
implements VCSGisJDownloadWorkingcopy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadWorkingcopyImpl.class);
    private static final String LAST_USED_FOLDER_FOR_DOWNLOAD_WC = "LAST_USED_FOLDER_FOR_DOWNLOAD_WC";
    private Dialog dialog;
    private boolean processing = false;
    private FolderPickerController downloadFolderPicker;
    private TextFieldWithHistoryAndBookmarkController urlrepositoryController;
    private TaskStatusController taskStatusController;

    public DownloadWorkingcopyImpl() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        FoldersManager foldersManager = ToolsLocator.getFoldersManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        toolsSwingManager.translate(this.lblDownloadFoder);
        toolsSwingManager.translate(this.lblURLRepository);
        toolsSwingManager.translate(this.lbllAvailableWorkingCopies);
        toolsSwingManager.translate((AbstractButton)this.chkOverwriteExistingWorkingCopy);
        toolsSwingManager.translate((AbstractButton)this.chkCreateConnectionToDatabase);
        this.taskStatusController = ToolsSwingLocator.getTaskStatusSwingManager().createTaskStatusController(this.lblStatusCaption, this.lblStatusMsg, this.pbStatus);
        this.taskStatusController.bind((TaskStatus)ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Downloading")));
        this.downloadFolderPicker = toolsSwingManager.createFolderPickerController((JTextComponent)this.txtDownloadFolder, this.btnDownloadFolder);
        this.downloadFolderPicker.addChangeListener(e -> this.doChangeDownloadFolder());
        this.downloadFolderPicker.set((Object)foldersManager.getLastPath(LAST_USED_FOLDER_FOR_DOWNLOAD_WC));
        this.urlrepositoryController = toolsSwingManager.createTextFieldWithHistoryAndBookmarkController("VCSGisRepositoryURL", (JTextComponent)this.txtURLRepository, this.btnURLRepositoryApply, this.btnURLRepositoryHistory, this.btnURLRepositoryBookmarks);
        this.urlrepositoryController.addActionListener(e -> this.doUpdateAvailableWorkingcopies());
        this.tbllAvailableWorkingCopies.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.doChangeSelectionOfAvailableWorkingCopy();
            }
        });
        this.tbllAvailableWorkingCopies.setModel(new AvailableWorkingcopiesTableModel());
        this.chkOverwriteExistingWorkingCopy.setSelected(false);
        this.setStatusVisible(false);
        this.doUpdateCompmentsEnabled();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)15, (int)100, (int)24, (int)120);
    }

    private void doChangeDownloadFolder() {
        this.doUpdateCompmentsEnabled();
    }

    private void doChangeSelectionOfAvailableWorkingCopy() {
        this.doUpdateCompmentsEnabled();
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void setStatusVisible(boolean visible) {
        this.lblStatusCaption.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblStatusMsg.setVisible(true);
    }

    private void message(String msg) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.message(msg))) {
            return;
        }
        this.lblStatusMsg.setText(StringUtils.trimToEmpty((String)msg));
    }

    private void doUpdateAvailableWorkingcopies() {
        URL url;
        I18nManager i18n = ToolsLocator.getI18nManager();
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        String urlbase = StringUtils.trimToNull((String)this.urlrepositoryController.getText());
        if (urlbase == null) {
            this.tbllAvailableWorkingCopies.setModel(new AvailableWorkingcopiesTableModel());
            return;
        }
        try {
            url = new URL(urlbase);
        }
        catch (MalformedURLException ex) {
            dialogs.messageDialog(i18n.getTranslation("_The_entered_URL_is_not_valid"), i18n.getTranslation("_VCS_Download_workingcopy"), 2);
            this.tbllAvailableWorkingCopies.setModel(new AvailableWorkingcopiesTableModel());
            return;
        }
        this.setStatusVisible(true);
        SimpleTaskStatus status = this.taskStatusController.getSimpleTaskStatus();
        status.restart();
        Thread th = new Thread(() -> {
            try {
                this.processing = true;
                this.doUpdateCompmentsEnabled();
                status.message(i18n.getTranslation("_Downloading_list_of_available_working_copies"));
                List preparedWorkspaces = manager.getPreparedWorkingCopyInformation(url);
                this.urlrepositoryController.addHistory(url.toString());
                this.doPostUpdateAvailableWorkingcopies(preparedWorkspaces);
            }
            catch (Exception ex) {
                dialogs.messageDialog(i18n.getTranslation("_Cant_retrieve_the_list_of_available_working_copies"), i18n.getTranslation("_VCS_Download_workingcopy"), 2);
                SwingUtilities.invokeLater(() -> this.tbllAvailableWorkingCopies.setModel(new AvailableWorkingcopiesTableModel()));
            }
            finally {
                status.restart();
                SwingUtilities.invokeLater(() -> this.setStatusVisible(false));
                this.processing = false;
                this.doUpdateCompmentsEnabled();
            }
        }, "VCSGisListPreparedWorkingcopies");
        th.start();
    }

    private void doPostUpdateAvailableWorkingcopies(List<VCSGisPreparedWorkingCopyInformation> preparedWorkspaces) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doPostUpdateAvailableWorkingcopies(preparedWorkspaces))) {
            return;
        }
        AvailableWorkingcopiesTableModel model = new AvailableWorkingcopiesTableModel(preparedWorkspaces);
        this.tbllAvailableWorkingCopies.setModel(model);
        this.taskStatusController.setVisible(false);
        this.doUpdateCompmentsEnabled();
    }

    private void doUpdateCompmentsEnabled() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doUpdateCompmentsEnabled())) {
            return;
        }
        if (this.processing) {
            this.urlrepositoryController.setEnabled(false);
            this.tbllAvailableWorkingCopies.setEnabled(false);
            this.downloadFolderPicker.setEnabled(false);
            this.chkOverwriteExistingWorkingCopy.setEnabled(false);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            this.taskStatusController.setVisible(true);
            return;
        }
        this.urlrepositoryController.setEnabled(true);
        this.tbllAvailableWorkingCopies.setEnabled(true);
        this.downloadFolderPicker.setEnabled(true);
        boolean enableOk = true;
        List<VCSGisPreparedWorkingCopyInformation> information = this.getWorkingcopies();
        List<File> targetZip_files = this.getTargetZipFiles(information);
        List<URI> targetZip_uris = this.getTargetZipURIs(information);
        List<URL> downloadURLs = this.getDownloadURLs(information);
        boolean enableOverwrite = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.needOverwrite(), (boolean)true);
        for (int i = 0; i < information.size(); ++i) {
            File targetZip_file = targetZip_files.get(i);
            URI targetZip_uri = targetZip_uris.get(i);
            URL downloadURL = downloadURLs.get(i);
            if (targetZip_file != null && downloadURL != null && targetZip_uri != null) continue;
            enableOk = false;
            enableOverwrite = false;
        }
        this.chkOverwriteExistingWorkingCopy.setEnabled(enableOverwrite);
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, enableOk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadFile(URL url, File file, final SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        status.push();
        try {
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            long completeFileSize = httpConnection.getContentLength();
            status.message(file.getName());
            status.setRangeOfValues(0L, completeFileSize);
            status.setCurValue(0L);
            InputStream is = httpConnection.getInputStream();
            CountingOutputStream os = new CountingOutputStream(new FileOutputStream(file)){

                protected void count(long written) {
                    super.count(written);
                    status.setCurValue(this.getBytesWritten());
                }
            };
            IOUtils.copy((InputStream)is, (OutputStream)os);
            status.message("");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't download from '" + Objects.toString(url) + "' to  file '" + Objects.toString(file) + "'.", (Throwable)ex);
            status.message(i18n.getTranslation("_Cant_download_working_copy"));
            boolean bl = false;
            return bl;
        }
        finally {
            status.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadText(URL url, final SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            long completeFileSize = httpConnection.getContentLength();
            status.push();
            status.message(i18n.getTranslation("_Downloading"));
            status.setRangeOfValues(0L, completeFileSize);
            InputStream is = httpConnection.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            CountingOutputStream os = new CountingOutputStream(bos){

                protected void count(long written) {
                    super.count(written);
                    status.setCurValue(this.getBytesWritten());
                }
            };
            IOUtils.copy((InputStream)is, (OutputStream)os);
            status.message("");
            String string = bos.toString();
            return string;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't download from '" + Objects.toString(url) + "'.", (Throwable)ex);
            status.message(i18n.getTranslation("_Cant_download_working_copy"));
            String string = null;
            return string;
        }
        finally {
            status.pop();
        }
    }

    private List<File> getTargetZipFiles(List<VCSGisPreparedWorkingCopyInformation> information) {
        File folder = (File)this.downloadFolderPicker.get();
        if (folder == null || information == null || information.isEmpty()) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (VCSGisPreparedWorkingCopyInformation info : information) {
            File target = new File(folder, info.getName() + ".zip");
            files.add(target);
        }
        return files;
    }

    private List<URI> getTargetZipURIs(List<VCSGisPreparedWorkingCopyInformation> information) {
        if (information == null || information.isEmpty()) {
            return null;
        }
        List<File> zipfiles = this.getTargetZipFiles(information);
        ArrayList<URI> uris = new ArrayList<URI>();
        for (File zipfile : zipfiles) {
            try {
                URI uri = zipfile.toURI();
                uris.add(uri);
            }
            catch (Exception ex) {
                uris.add(null);
            }
        }
        return uris;
    }

    private List<VCSGisPreparedWorkingCopyInformation> getWorkingcopies() {
        int[] row = this.tbllAvailableWorkingCopies.getSelectedRows();
        if (row == null || row.length < 0) {
            return Collections.EMPTY_LIST;
        }
        AvailableWorkingcopiesTableModel model = (AvailableWorkingcopiesTableModel)this.tbllAvailableWorkingCopies.getModel();
        ArrayList<VCSGisPreparedWorkingCopyInformation> selecteds = new ArrayList<VCSGisPreparedWorkingCopyInformation>();
        for (int i = 0; i < row.length; ++i) {
            selecteds.add(model.getElement(row[i]));
        }
        return selecteds;
    }

    private List<String> getWorkingcopyNames() {
        List<VCSGisPreparedWorkingCopyInformation> elements = this.getWorkingcopies();
        if (elements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (VCSGisPreparedWorkingCopyInformation element : elements) {
            names.add(element.getName());
        }
        return names;
    }

    private List<URL> getDownloadURLs(List<VCSGisPreparedWorkingCopyInformation> information) {
        if (information == null || information.isEmpty()) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (VCSGisPreparedWorkingCopyInformation element : information) {
            String urlbase = StringUtils.trimToNull((String)this.urlrepositoryController.getText());
            String s = element.getLocation();
            try {
                URL url = new URL(urlbase);
                URIBuilder builder = new URIBuilder();
                builder.setScheme(url.getProtocol());
                builder.setHost(url.getHost());
                builder.setPort(url.getPort());
                builder.setPath(url.getPath() + "/" + s);
                URI uri = builder.build();
                urls.add(uri.toURL());
            }
            catch (MalformedURLException | URISyntaxException ex) {
                urls.add(null);
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int download(boolean quietly) {
        if (this.tbllAvailableWorkingCopies.isEditing()) {
            this.tbllAvailableWorkingCopies.getCellEditor().stopCellEditing();
        }
        try {
            this.processing = true;
            this.doUpdateCompmentsEnabled();
            VCSGisManager manager = VCSGisLocator.getVCSGisManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            if (manager.IsThereConflictingStoresInEdition()) {
                dialogs.messageDialog(i18n.getTranslation("_It_is_not_possible_to_download_working_copies_while_you_have_a_table_in_edit"), i18n.getTranslation("_VCS_Download_workingcopy"), 2);
                int n = 25;
                return n;
            }
            List<VCSGisPreparedWorkingCopyInformation> information = this.getWorkingcopies();
            List<File> targetZip_files = this.getTargetZipFiles(information);
            List<URI> targetZip_uris = this.getTargetZipURIs(information);
            List<URL> urls = this.getDownloadURLs(information);
            List<String> labels = this.getLabels(information);
            boolean addToConnectionPool = this.chkCreateConnectionToDatabase.isSelected();
            block9: for (int i = 0; i < information.size(); ++i) {
                int n = this.download(quietly, targetZip_files.get(i), targetZip_uris.get(i), urls.get(i), labels.get(i), addToConnectionPool);
                switch (n) {
                    case 0: {
                        continue block9;
                    }
                    case 10000: {
                        continue block9;
                    }
                    default: {
                        dialogs.messageDialog(i18n.getTranslation("_Cant_download_working_copy"), i18n.getTranslation("_VCS_Download_workingcopy"), 2);
                        int n2 = 25;
                        return n2;
                    }
                }
            }
            int n = 0;
            return n;
        }
        finally {
            this.processing = false;
            this.doUpdateCompmentsEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int download(boolean quietly, File targetZip_file, URI targetZip_uri, URL url, String label, boolean addToConnectionPool) {
        boolean overwrite;
        VCSGisWorkspace ws;
        VCSGisManager manager;
        FoldersManager foldersManager;
        ThreadSafeDialogsManager dialogs;
        I18nManager i18n;
        block27: {
            block28: {
                int n;
                i18n = ToolsLocator.getI18nManager();
                dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                foldersManager = ToolsLocator.getFoldersManager();
                manager = VCSGisLocator.getVCSGisManager();
                ws = null;
                if (targetZip_file == null || url == null || targetZip_uri == null) {
                    if (!quietly) {
                        dialogs.messageDialog(i18n.getTranslation("_Unable_to_download_working_copy_The_selected_copy_or_destination_folder_is_invalid"), i18n.getTranslation("_VCS_Download_workingcopy"), 2);
                    }
                    this.doUpdateCompmentsEnabled();
                    LOGGER.info("Can't download working copy, target or url are null.");
                    return 25;
                }
                boolean bl = overwrite = this.chkOverwriteExistingWorkingCopy.isEnabled() && this.chkOverwriteExistingWorkingCopy.isSelected();
                if (!overwrite && BooleanUtils.toBooleanDefaultIfNull((Boolean)this.needOverwrite(), (boolean)true)) {
                    if (!quietly) {
                        dialogs.messageDialog(i18n.getTranslation("_A_downloaded_working_copy_already_exists_Check_the_option_to_overwrite_if_you_want_to_download_it_or_select_another_destination_folder"), i18n.getTranslation("_VCS_Download_workingcopy"), 2);
                    }
                    LOGGER.info("Can't overwrite working copy, select check in GUI.");
                    return 25;
                }
                boolean existsPreviousDatabase = false;
                for (File f : H2SpatialUtils.getH2Files((File)targetZip_file)) {
                    if (!f.exists()) continue;
                    existsPreviousDatabase = true;
                    break;
                }
                if (!existsPreviousDatabase || (ws = manager.openWorkspace(H2SpatialUtils.normalizeH2File((File)targetZip_file))) == null || !ws.isInMyDatabase("VCSGIS_ENTITIES")) break block27;
                if (!ws.hasLocalChanges(null) || (n = dialogs.confirmDialog(i18n.getTranslation("A local working copy with changes already exists. If you continue your changes will be lost. Do you want to continue with the download?"), i18n.getTranslation("_VCS_Download_workingcopy"), 0, 2)) == 0) break block28;
                LOGGER.info("User cancel download working copy for changes in existing copy");
                int n2 = 10000;
                DisposeUtils.dispose((Disposable)ws);
                ws = null;
                return n2;
            }
            try {
                JDBCServerExplorer explorer = ws.getExplorer();
                try {
                    explorer.execute("SHUTDOWN");
                }
                catch (Exception ex) {
                    LOGGER.debug("Expected exception after database shutdown", (Throwable)ex);
                }
            }
            finally {
                DisposeUtils.dispose(ws);
                ws = null;
            }
        }
        this.setStatusVisible(true);
        SimpleTaskStatus status = this.taskStatusController.getSimpleTaskStatus();
        status.restart();
        try {
            if (overwrite) {
                FileUtils.deleteQuietly((File)targetZip_file);
            }
            status.message(i18n.getTranslation("_Stoping_h2_server"));
            H2SpatialUtils.server_stop();
            this.sleep(3);
            status.message(i18n.getTranslation("_Download_working_copy"));
            this.sleep(1);
            LOGGER.info("Download working copy from '" + url.toString() + "' in '" + targetZip_file.toString() + "'");
            this.downloadFile(url, targetZip_file, status);
            if (overwrite) {
                File[] files;
                status.message(i18n.getTranslation("_Removing_previous_working_copy"));
                LOGGER.info("Removing previous working copy");
                this.sleep(1);
                for (File file : files = H2SpatialUtils.getH2Files((File)targetZip_file)) {
                    Path path;
                    if (file == null || !Files.exists(path = file.toPath(), new LinkOption[0])) continue;
                    Files.delete(path);
                }
            }
            status.message(i18n.getTranslation("_Extracting_local_working_copy"));
            this.sleep(1);
            LOGGER.info("Unzip working copy " + targetZip_uri + " in " + targetZip_file.getParentFile());
            this.unzip(targetZip_uri, targetZip_file.getParentFile(), status);
            foldersManager.setLastPath(LAST_USED_FOLDER_FOR_DOWNLOAD_WC, targetZip_file.getParentFile());
        }
        catch (Exception ex) {
            LOGGER.warn("Can't unzip doanloaded working copy (zipfile='" + Objects.toString(targetZip_file) + "', zipuri='" + Objects.toString(targetZip_uri) + "'),", (Throwable)ex);
            if (!quietly) {
                dialogs.messageDialog(i18n.getTranslation("_Cant_unzip_downloaded_working_copy"), i18n.getTranslation("_VCS_Download_workingcopy"), 2);
            }
            status.abort();
            this.doUpdateCompmentsEnabled();
            int n = -1;
            return n;
        }
        finally {
            H2SpatialUtils.server_start();
        }
        status.message(i18n.getTranslation("_Registering_working_copy"));
        this.sleep(1);
        try {
            File dbfile = H2SpatialUtils.normalizeH2File((File)targetZip_file);
            manager.deregisterWorkspace(dbfile);
            if (StringUtils.isBlank((CharSequence)label)) {
                SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm");
                label = FilenameUtils.getBaseName((String)targetZip_file.getName()) + " [" + sdf.format(new Date()) + "]";
            }
            LOGGER.info("Force working copy label to '" + label + "'.");
            ws = manager.openWorkspace(dbfile, label);
            if (addToConnectionPool) {
                LOGGER.info("Register database connection");
                ws.addToConnectionPool();
            }
            LOGGER.info("Process models in working copy.");
            this.process_models(ws);
            VCSGisSwingServices services = VCSGisSwingLocator.getVCSGisSwingManager().getDefaultServices();
            LOGGER.info("Refresh documents");
            services.refreshDocuments();
            status.message(i18n.getTranslation("_Dounload_terminate"));
            status.terminate();
            this.setStatusVisible(false);
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't register workspace", (Throwable)ex);
            status.message(i18n.getTranslation("_Cant_register_workspace"));
            status.abort();
            int n = 25;
            return n;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)ws);
            this.doUpdateCompmentsEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(URI zip, File folder, final SimpleTaskStatus status) throws IOException {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            status.push();
            HashMap<String, String> zip_properties = new HashMap<String, String>();
            zip_properties.put("create", "false");
            try (FileSystem zipfs = this.newFileSystem(Paths.get(zip), zip_properties);){
                Stream<Path> walk = Files.walk(zipfs.getPath("/", new String[0]), 1, new FileVisitOption[0]);
                int numfiles = 0;
                Iterator it = walk.iterator();
                while (it.hasNext()) {
                    Path path = (Path)it.next();
                    ++numfiles;
                }
                status.message(i18n.getTranslation("_Uncompressing"));
                status.setRangeOfValues(0L, (long)numfiles);
                walk = Files.walk(zipfs.getPath("/", new String[0]), 1, new FileVisitOption[0]);
                it = walk.iterator();
                while (it.hasNext()) {
                    Path src = (Path)it.next();
                    Path fileName = src.getFileName();
                    if (fileName == null) continue;
                    String fname = fileName.toString();
                    status.push();
                    status.message(i18n.getTranslation("_Uncompressing") + "... " + fname);
                    status.setRangeOfValues(0L, Files.size(src));
                    FileOutputStream target_os = new FileOutputStream(new File(folder, fname));
                    CountingOutputStream target_cos = new CountingOutputStream(target_os){

                        protected void count(long written) {
                            super.count(written);
                            status.setCurValue(this.getBytesWritten());
                        }
                    };
                    Files.copy(src, (OutputStream)target_cos);
                    status.pop();
                }
            }
        }
        finally {
            status.pop();
        }
    }

    private void sleep(int secs) {
        try {
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Boolean needOverwrite() {
        List<VCSGisPreparedWorkingCopyInformation> information = this.getWorkingcopies();
        if (information == null || information.isEmpty()) {
            return null;
        }
        List<File> zip_files = this.getTargetZipFiles(information);
        if (zip_files == null || zip_files.isEmpty()) {
            return null;
        }
        for (File zip_file : zip_files) {
            File[] files;
            if (zip_file.exists()) {
                return true;
            }
            for (File file : files = H2SpatialUtils.getH2Files((File)zip_file)) {
                if (!file.exists()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean changes_in_localcopy(File targetZip_file) {
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisWorkspace ws = manager.openWorkspace(H2SpatialUtils.normalizeH2File((File)targetZip_file));
        if (ws == null) {
            return false;
        }
        return ws.hasLocalChanges(null);
    }

    private void process_models(final VCSGisWorkspace ws) {
        final List dataModels = ws.getDataModels();
        if (dataModels.isEmpty()) {
            LOGGER.info("The working copy has no models defined");
            return;
        }
        LOGGER.info("Detected models: " + StringUtils.join((Iterable)dataModels, (String)","));
        List rentities = ws.getRepositoryEntities();
        for (VCSGisEntity rentity : rentities) {
            if (dataModels.isEmpty()) break;
            ArrayList<String> dataModelToRemove = new ArrayList<String>();
            for (String dataModel : dataModels) {
                if (!rentity.getDataModelsAsList().contains(dataModel) || ws.getWorkspaceEntityByCode(rentity.getEntityCode()) != null) continue;
                LOGGER.info("Table '" + rentity.getEntityName() + "' of model '" + dataModel + "' is missing.");
                dataModelToRemove.add(dataModel);
            }
            for (String dataModel : dataModelToRemove) {
                dataModels.remove(dataModel);
            }
        }
        if (dataModels.isEmpty()) {
            LOGGER.info("No models to connect. There are models that are missing tables. Use the connect to model tool to test this.");
            return;
        }
        Runnable process_task = new Runnable(){

            @Override
            public void run() {
                DefaultListModel<String> model = new DefaultListModel<String>();
                for (String dataModel : dataModels) {
                    model.addElement(dataModel);
                }
                I18nManager i18n = ToolsLocator.getI18nManager();
                JList list = new JList(model);
                ToolsSwingUtils.ensureRowsCols(list, (int)10, (int)60, (int)15, (int)80);
                WindowManager_v2 manager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
                Dialog theDialog = manager.createDialog(list, i18n.getTranslation("_Connect_to_models"), i18n.getTranslation("_Select_the_models_to_connect"), 1);
                theDialog.show(WindowManager.MODE.DIALOG);
                if (theDialog.getAction() == 1) {
                    for (String modelName : list.getSelectedValuesList()) {
                        ThreadSafeDialogsManager dialogs;
                        int n;
                        if (VCSGisSwingCommons.hasConflictTheDatamodelWithOtherModelAlreadyRegistered(ws, modelName) && (n = (dialogs = ToolsSwingLocator.getThreadSafeDialogsManager()).confirmDialog(i18n.getTranslation("_The_name_of_some_tables_of_the_data_model_coincide_with_those_of_another_model_already_registered") + " (" + modelName + ")\n" + i18n.getTranslation("_If_you_connect_to_this_model_and_have_tables_or_layers_loaded_from_the_previous_model_you_may_notice_inconsistencies_in_the_data") + "\n" + i18n.getTranslation("_Do_you_want_to_connect_with_the_current_model_anyway"), i18n.getTranslation("_VCS_Connect_to_datamodel"), 0, 3)) != 0) continue;
                        DownloadWorkingcopyImpl.this.registerDataModelRepository(ws, modelName);
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            process_task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(process_task);
            }
            catch (Exception ex) {
                LOGGER.warn("Problems processing dara models.", (Throwable)ex);
            }
        }
    }

    private void registerDataModelRepository(VCSGisWorkspace workspace, String dataModelName) {
        LOGGER.info("Connect to model '" + dataModelName + "'.");
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        workspace.registerDataModelRepository(dataModelName);
        services.connectedToModel(workspace, dataModelName);
    }

    private List<String> getLabels(List<VCSGisPreparedWorkingCopyInformation> infos) {
        ArrayList<String> labels = new ArrayList<String>();
        AvailableWorkingcopiesTableModel model = (AvailableWorkingcopiesTableModel)this.tbllAvailableWorkingCopies.getModel();
        for (VCSGisPreparedWorkingCopyInformation info : infos) {
            labels.add(model.getLabel(info.getName()));
        }
        return labels;
    }

    private FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            try {
                return provider.newFileSystem(path, env);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new ProviderNotFoundException("Provider not found");
    }

    private static class AvailableWorkingcopiesTableModel
    extends AbstractTableModel {
        private List<VCSGisPreparedWorkingCopyInformation> data;
        private final Class[] columnClass;
        private final String[] columnName;
        private Map<String, String> labels;

        public AvailableWorkingcopiesTableModel() {
            this(null);
        }

        public AvailableWorkingcopiesTableModel(List<VCSGisPreparedWorkingCopyInformation> data) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.labels = new HashMap<String, String>();
            this.data = data;
            this.columnClass = new Class[]{String.class, String.class, String.class};
            this.columnName = new String[]{i18n.getTranslation("Nombre"), i18n.getTranslation("Fecha"), i18n.getTranslation("Etiqueta")};
            if (data != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm");
                for (VCSGisPreparedWorkingCopyInformation info : data) {
                    String label = info.getName() + " [" + sdf.format(new Date()) + "]";
                    this.labels.put(info.getName(), label);
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClass[columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            return this.columnName[column];
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnName.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.data == null) {
                return null;
            }
            VCSGisPreparedWorkingCopyInformation element = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return element.getName();
                }
                case 1: {
                    return element.getDate().toString();
                }
                case 2: {
                    return this.labels.get(element.getName());
                }
            }
            return null;
        }

        private VCSGisPreparedWorkingCopyInformation getElement(int row) {
            if (this.data == null) {
                return null;
            }
            VCSGisPreparedWorkingCopyInformation element = this.data.get(row);
            return element;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                default: {
                    return false;
                }
                case 2: 
            }
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (this.data == null) {
                return;
            }
            VCSGisPreparedWorkingCopyInformation element = this.data.get(rowIndex);
            switch (columnIndex) {
                default: {
                    return;
                }
                case 2: 
            }
            this.labels.put(element.getName(), (String)aValue);
        }

        public String getLabel(String name) {
            return this.labels.get(name);
        }
    }
}

