/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.export;

import java.sql.Timestamp;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.DatePickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.VCSGisJExport;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.export.VCSGisJExportView;
import org.gvsig.vcsgis.swing.impl.revisions.VCSGisRevisionPickerControllerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJExportImpl
extends VCSGisJExportView
implements Component,
VCSGisJExport {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJExportImpl.class);
    private Dialog dialog;
    private PickerController<VCSGisWorkspace> workspacePicker;
    private DatePickerController efectivePicker;
    private VCSGisEntitySelectorController entitySelector;
    private VCSGisRevisionPickerControllerImpl revisionPicker;
    private boolean processing;
    private TaskStatusController taskStatusController;
    private String searchedTable;
    private boolean existsInDataBaseSearchedTable;

    public VCSGisJExportImpl() {
        this.translate();
        this.processing = false;
        this.initComponents();
    }

    private void initComponents() {
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspaces, this.btnInitWorkspace);
        this.workspacePicker.addChangeListener(e -> {
            this.doChangeWorkspace();
            this.doUpdateComponents();
        });
        this.taskStatusController = taskStatusManager.createTaskStatusController(this.lblStatusTitle, this.lblStatusMessages, this.pbStatus);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind(ToolsLocator.getTaskStatusManager());
        SwingUtilities.invokeLater(() -> this.taskStatusController.setVisible(false));
        this.entitySelector = VCSGisSwingLocator.getVCSGisSwingManager().createEntitySelectorController(this.lstTables, (JTextComponent)this.txtFilter, this.btnTable);
        this.entitySelector.setFilter(VCSGisEntitySelectorController.REMOTE_ENTITIES);
        this.entitySelector.setViewFilter(VCSGisEntitySelectorController.REMOTE_ENTITIES);
        this.entitySelector.setChecksEnabled(false);
        this.entitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 2: 
                case 3: 
                case 4: {
                    this.doUpdateComponents();
                    break;
                }
                case 0: {
                    this.doChangeTable();
                    this.doChangeTableName();
                }
            }
        });
        this.entitySelector.addChangeListener(e -> this.doUpdateComponents());
        this.rdbEffectiveDate.addActionListener(e -> this.doUpdateComponents());
        this.rdbRevision.addActionListener(e -> this.doUpdateComponents());
        this.efectivePicker = toolsSwingManager.createDatePickerController((JTextComponent)this.txtEffectiveDate, this.btnEffectiveDate);
        this.efectivePicker.addChangeListener(e -> this.doChangeTableName());
        this.revisionPicker = new VCSGisRevisionPickerControllerImpl(this.txtRevision, this.btnRevision);
        this.revisionPicker.addChangeListener(e -> this.doChangeTableName());
        ComboBoxModel viewDocumentsModel = services.getViewDocumentsComboBoxModel();
        this.cboView.setModel(viewDocumentsModel);
        this.cboView.addActionListener(e -> this.doUpdateComponents());
        this.rdbDontAddToProject.addActionListener(e -> this.doUpdateComponents());
        this.rdbAddLayerToView.addActionListener(e -> this.doUpdateComponents());
        this.rdbAddTableToProject.addActionListener(e -> this.doUpdateComponents());
        this.txtTableName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                VCSGisJExportImpl.this.doUpdateComponents();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VCSGisJExportImpl.this.doUpdateComponents();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                VCSGisJExportImpl.this.doUpdateComponents();
            }
        });
        this.chkExportOnlyExtentOfCurrentView.setSelected(false);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)25, (int)80);
        this.doUpdateComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateComponents();
    }

    private void doChangeWorkspace() {
        try {
            VCSGisWorkspace ws = this.getWorkspace();
            if (ws == null) {
                this.entitySelector.setWorkspace(ws);
                this.revisionPicker.setWorkspace(ws);
                return;
            }
            if (ws.isOffline() || ws.authenticate(null)) {
                this.entitySelector.setWorkspace(ws);
                this.revisionPicker.setWorkspace(ws);
                Thread task = new Thread(() -> {
                    try {
                        LOGGER.info("Entro en el thread");
                        this.processing = true;
                        this.doUpdateComponents();
                        ws.getRepositoryEntities();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't retrieve repository entities", (Throwable)ex);
                    }
                    finally {
                        LOGGER.info("Salgo del thread");
                        this.processing = false;
                        this.doUpdateComponents();
                    }
                }, "VCSGisExportGetRepositoryEntities");
                this.processing = true;
                LOGGER.info("Creando thread");
                this.doUpdateComponents();
                task.start();
                return;
            }
            VCSGisSwingCommons.showAuthenticationRequiredMessage("_VCS_Checkout");
            this.workspacePicker.set(null);
            this.doChangeWorkspace();
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't set workspace.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Checkout", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't set workspace.", (Throwable)e2);
        }
    }

    private void doChangeTable() {
        VCSGisEntity selectedTable = this.entitySelector.getSelectedEntity();
        this.revisionPicker.setEntity(selectedTable);
        this.efectivePicker.set(null);
        this.txtTableName.setText("");
        boolean isLayer = this.isLayer(selectedTable);
        this.rdbAddLayerToView.setSelected(isLayer && !this.rdbDontAddToProject.isSelected());
        this.rdbAddTableToProject.setSelected(!isLayer && !this.rdbDontAddToProject.isSelected());
        if (isLayer) {
            if (this.cboView.getModel().getSize() > 0) {
                this.cboView.setEnabled(true);
                if (this.cboView.getModel().getSize() == 2) {
                    this.cboView.setSelectedIndex(1);
                } else {
                    this.cboView.setSelectedIndex(0);
                }
            } else {
                this.cboView.setEnabled(false);
            }
        }
        this.doUpdateComponents();
    }

    private void doChangeTableName() {
        String suffix;
        VCSGisEntity selectedTable = this.entitySelector.getSelectedEntity();
        if (selectedTable == null) {
            this.txtTableName.setText("");
            return;
        }
        if (this.rdbEffectiveDate.isSelected() && this.efectivePicker.get() != null) {
            Timestamp timestamp = DataTypeUtils.toTimestamp((Date)((Date)this.efectivePicker.get()));
            suffix = timestamp.toString();
        } else if (this.rdbRevision.isSelected() && this.revisionPicker.get() != null) {
            VCSGisRevision revision = this.revisionPicker.get();
            suffix = "r" + revision.getNumber() + " " + revision.getRevisionDate().toString();
        } else {
            Timestamp timestamp = DataTypeUtils.toTimestamp((Date)new Date());
            suffix = timestamp.toString();
        }
        this.txtTableName.setText(this.normalizeTableName(selectedTable.getEntityName() + "_" + suffix));
    }

    public VCSGisWorkspace getWorkspace() {
        return (VCSGisWorkspace)this.workspacePicker.get();
    }

    public VCSGisEntity getTable() {
        return this.entitySelector.getSelectedEntity();
    }

    private void doUpdateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        try {
            boolean canExport;
            boolean isProcessing = this.processing || this.entitySelector.isProcessing();
            this.workspacePicker.setEnabled(!isProcessing);
            VCSGisWorkspace workspace = this.getWorkspace();
            VCSGisEntity selectedTable = this.entitySelector.getSelectedEntity();
            String tableName = this.txtTableName.getText();
            boolean exists = workspace != null && selectedTable != null && this.existsInDataBase();
            boolean isThereTableSelected = !isProcessing && workspace != null && selectedTable != null;
            boolean bl = canExport = isThereTableSelected && StringUtils.isNotBlank((CharSequence)tableName) && !exists && workspace.getEntity(tableName) == null;
            if (exists) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                this.showMessage(i18n.getTranslation("_Table_already_exists_in_working_copy"), i18n.getTranslation("_You_can_rename_the_table"));
                this.setVisibleStatus(true);
            } else {
                this.showMessage("", "");
                this.setVisibleStatus(true);
            }
            this.entitySelector.setEnabled(!isProcessing && workspace != null);
            this.rdbRevision.setEnabled(isThereTableSelected);
            this.revisionPicker.setEnabled(isThereTableSelected && this.rdbRevision.isSelected());
            this.rdbEffectiveDate.setEnabled(isThereTableSelected);
            this.efectivePicker.setEnabled(isThereTableSelected && this.rdbEffectiveDate.isSelected());
            this.rdbDontAddToProject.setEnabled(canExport);
            this.rdbAddTableToProject.setEnabled(canExport);
            if (canExport) {
                if (this.isLayer(selectedTable)) {
                    this.rdbAddLayerToView.setEnabled(canExport);
                    this.cboView.setEnabled(canExport && this.rdbAddLayerToView.isSelected());
                } else {
                    this.rdbAddLayerToView.setEnabled(false);
                    this.cboView.setEnabled(false);
                }
            } else {
                this.rdbAddLayerToView.setEnabled(false);
                this.cboView.setEnabled(false);
            }
            this.entitySelector.setEnabled(!isProcessing && workspace != null);
            this.lblTableName.setEnabled(isThereTableSelected);
            this.txtTableName.setEnabled(isThereTableSelected);
            this.pbStatus.setVisible(isProcessing);
            this.lblStatusTitle.setVisible(isProcessing);
            if (this.dialog != null) {
                LabeledValue selectedView = (LabeledValue)this.cboView.getSelectedItem();
                boolean dontAddNothing = this.rdbDontAddToProject.isSelected();
                boolean addLayerToView = this.rdbAddLayerToView.isSelected() && selectedView != null && selectedView.getValue() != null;
                boolean addTableToProject = this.rdbAddTableToProject.isSelected();
                this.dialog.setButtonEnabled(1, canExport && (dontAddNothing || addLayerToView || addTableToProject));
            }
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't updating components.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Export", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
                this.doUpdateComponents();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't updating components.", (Throwable)e2);
        }
    }

    private boolean isLayer(VCSGisEntity entity) {
        if (entity == null) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)entity.getGeometryFieldName());
    }

    private boolean isLayer(FeatureStore store) {
        FeatureType ft = store.getDefaultFeatureTypeQuietly();
        if (ft == null) {
            return false;
        }
        return ft.getDefaultGeometryAttribute() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int export() {
        VCSGisSwingManager swingManager;
        VCSGisSwingServices services;
        I18nManager i18n = ToolsLocator.getI18nManager();
        Geometry roi = null;
        boolean exportOnlyExtentOfCurrentView = this.chkExportOnlyExtentOfCurrentView.isSelected();
        if (exportOnlyExtentOfCurrentView && (roi = (services = (swingManager = VCSGisSwingLocator.getVCSGisSwingManager()).getDefaultServices()).getExtentOfCurrentDocument()) == null) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_Cant_retrieve_extent_of_active_document"), i18n.getTranslation("_VCS_Export"), 1);
            return 900;
        }
        VCSGisEntity entity = this.entitySelector.getSelectedEntity();
        VCSGisWorkspace workspace = this.getWorkspace();
        VCSGisRevision revision = this.revisionPicker.get();
        if (workspace != null && entity != null) {
            try {
                this.processing = true;
                this.doUpdateComponents();
                this.showMessage(i18n.getTranslation("_Processing"), null);
                String tableName = this.txtTableName.getText();
                int res = workspace.export(entity.getEntityName(), tableName, revision == null ? null : revision.getRevisionCode(), DataTypeUtils.toTimestamp((Date)((Date)this.efectivePicker.get())), roi.getEnvelope(), null);
                this.postExport(res, tableName);
                this.showMessage(i18n.getTranslation("_Ended_process"), null);
                int n = res;
                return n;
            }
            finally {
                this.processing = false;
                this.doUpdateComponents();
            }
        }
        return 900;
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspace);
        swingManager.translate(this.lblTable);
        swingManager.translate((AbstractButton)this.rdbEffectiveDate);
        swingManager.translate((AbstractButton)this.rdbRevision);
        swingManager.translate((AbstractButton)this.rdbDontAddToProject);
        swingManager.translate((AbstractButton)this.rdbAddLayerToView);
        swingManager.translate((AbstractButton)this.rdbAddTableToProject);
        swingManager.translate(this.lblTableName);
        swingManager.translate(this.lblAddTableToProject);
        swingManager.translate((AbstractButton)this.chkExportOnlyExtentOfCurrentView);
    }

    public boolean isProcessing() {
        return this.processing;
    }

    private void postExport(int checkoutStatus, String tableName) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.postExport(checkoutStatus, tableName))) {
            return;
        }
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        VCSGisWorkspace workspace = this.getWorkspace();
        if (checkoutStatus == 0) {
            FeatureStore store = workspace.openFeatureStore(tableName, false);
            if (!this.rdbDontAddToProject.isSelected()) {
                if (this.rdbAddLayerToView.isSelected() && this.isLayer(store)) {
                    services.addLayerToView(store, (LabeledValue)this.cboView.getSelectedItem(), null, tableName, false);
                }
                if (this.rdbAddTableToProject.isSelected()) {
                    String newLayerName = this.txtTableName.getText();
                    services.addTableToProject(workspace, store, newLayerName);
                }
            }
            this.setVisibleStatus(false);
        } else {
            this.setVisibleStatus(true);
        }
        this.searchedTable = null;
        this.doUpdateComponents();
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusTitle.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblStatusMessages.setVisible(true);
    }

    private void showMessage(String message, String toolTipText) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.showMessage(message, toolTipText))) {
            return;
        }
        this.lblStatusMessages.setText(message);
        this.lblStatusMessages.setToolTipText(toolTipText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsInDataBase() {
        boolean bl;
        String tableName = this.txtTableName.getText();
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)this.searchedTable)) {
            return this.existsInDataBaseSearchedTable;
        }
        VCSGisWorkspace ws = this.getWorkspace();
        FeatureStore store = null;
        try {
            store = ws.openFeatureStore(tableName, true);
            this.searchedTable = tableName;
            bl = this.existsInDataBaseSearchedTable = store != null;
        }
        catch (Exception ex) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)store);
            return bl2;
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return bl;
    }

    private String normalizeTableName(String tableName) {
        return tableName.replaceAll("[-:]", "").replaceAll("[ .]", "_").toUpperCase();
    }
}

