/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.importhistory.process;

import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.impl.importhistory.AbstractImportProcess;

public class ImportHistoryWithDate_minimize_time
extends AbstractImportProcess {
    protected String fieldDateName;
    protected long groupEvery;
    protected ChronoUnit groupEveryUnit;
    private String sourceFieldDateName;

    public ImportHistoryWithDate_minimize_time(boolean onlyLocal, VCSGisWorkspace workspace, FeatureStore sourceStore, VCSGisEntity targetEntity, String fieldCodeName, String fieldDateName, String fieldOrderName, String sortOrder, Expression deletedCondition, long groupEvery, ChronoUnit groupEveryUnit, SimpleTaskStatus status) {
        super(onlyLocal, workspace, sourceStore, targetEntity, fieldCodeName, fieldOrderName, sortOrder, deletedCondition, status);
        this.fieldDateName = fieldDateName;
        this.groupEvery = groupEvery;
        this.groupEveryUnit = groupEveryUnit;
    }

    @Override
    protected FeatureQuery getSourceQuery() throws DataException {
        FeatureQuery sourceQuery = this.sourceStore.createFeatureQuery();
        ExpressionBuilder expBuilder = ExpressionUtils.createExpressionBuilder();
        sourceQuery.getOrder().add(this.sourceFieldDateName, true);
        String sourceFieldOrderName = this.getSourceFieldOrderName();
        if (sourceFieldOrderName != null) {
            sourceQuery.getOrder().add(sourceFieldOrderName, this.sortOrder);
        }
        return sourceQuery;
    }

    protected Set<Object> createInsertedSet(long sourceSize) {
        return new HashSet<Object>((int)sourceSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int process() {
        int n;
        FeatureSet sourceFeatures;
        block15: {
            int n2;
            block14: {
                int n3;
                block13: {
                    int n4;
                    block12: {
                        if (StringUtils.isBlank((CharSequence)this.fieldDateName)) {
                            LOGGER.warn("fieldDateName can't be blank,");
                            return 25;
                        }
                        sourceFeatures = null;
                        try {
                            this.status.message("Preparing data...");
                            FeatureAttributeDescriptor sourceAttrDateName = this.getSourceFeatureType().getAttributeDescriptor(this.fieldDateName);
                            if (sourceAttrDateName == null) {
                                LOGGER.warn("Field '" + this.fieldDateName + "' (fieldDateName) has not been found in the source table.");
                                n4 = 25;
                                DisposeUtils.disposeQuietly((Disposable)sourceFeatures);
                                break block12;
                            }
                            this.sourceFieldDateName = sourceAttrDateName.getName();
                            FeatureQuery theSourceQuery = this.getSourceQuery();
                            sourceFeatures = this.sourceStore.getFeatureSet(theSourceQuery);
                            this.sourceSize = sourceFeatures.size64();
                            Set<Object> inserteds = this.createInsertedSet(this.sourceSize);
                            this.status.setRangeOfValues(0L, this.sourceSize);
                            this.status.setCurValue(0L);
                            int result = this.process_minimize_time(sourceFeatures, this.createGroupByRevisionDate(this.fieldDateName, this.groupEveryUnit, this.groupEvery), this.fieldDateName, inserteds);
                            if (result != 0) {
                                this.status.abort();
                                FeatureStore.cancelEditingQuietly((FeatureStore)this.getTargetStore());
                                n3 = result;
                                DisposeUtils.disposeQuietly((Disposable)sourceFeatures);
                                break block13;
                            }
                            this.status.message("Finished.");
                            this.status.terminate();
                            if (this.hasErrors()) {
                                FeatureStore.cancelEditingQuietly((FeatureStore)this.getTargetStore());
                                n2 = 25;
                                DisposeUtils.disposeQuietly((Disposable)sourceFeatures);
                                break block14;
                            }
                            n = 0;
                            DisposeUtils.disposeQuietly((Disposable)sourceFeatures);
                            break block15;
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Can't import history", (Throwable)ex);
                            this.status.abort();
                            FeatureStore.cancelEditingQuietly((FeatureStore)this.getTargetStore());
                            int n5 = 25;
                            return n5;
                        }
                    }
                    this.disposeTargetStore();
                    return n4;
                }
                this.disposeTargetStore();
                return n3;
            }
            this.disposeTargetStore();
            return n2;
        }
        this.disposeTargetStore();
        return n;
        finally {
            DisposeUtils.disposeQuietly(sourceFeatures);
            this.disposeTargetStore();
        }
    }
}

