/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.importhistory.process;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.impl.importhistory.AbstractImportProcess;

public class ImportHistoryWithRevision_minimize_memory
extends AbstractImportProcess {
    protected String fieldEfectiveDateName;
    protected String fieldRevisionName;
    private String sourceFieldRevisionName;
    private String sourceFieldEfectiveDateName;

    public ImportHistoryWithRevision_minimize_memory(boolean onlyLocal, VCSGisWorkspace workspace, FeatureStore sourceStore, VCSGisEntity targetEntity, String fieldCodeName, String fieldRevisionName, String fieldEfectiveDateName, String fieldOrderName, String sortOrder, Expression deletedCondition, SimpleTaskStatus status) {
        super(onlyLocal, workspace, sourceStore, targetEntity, fieldCodeName, fieldOrderName, sortOrder, deletedCondition, status);
        this.fieldEfectiveDateName = fieldEfectiveDateName;
        this.fieldRevisionName = fieldRevisionName;
    }

    @Override
    protected FeatureQuery getSourceQuery() throws DataException {
        FeatureQuery sourceQuery = this.sourceStore.createFeatureQuery();
        ExpressionBuilder expBuilder = ExpressionUtils.createExpressionBuilder();
        sourceQuery.getOrder().add(this.sourceFieldRevisionName, true);
        String sourceFieldOrderName = this.getSourceFieldOrderName();
        if (sourceFieldOrderName != null) {
            sourceQuery.getOrder().add(sourceFieldOrderName, this.sortOrder);
        }
        return sourceQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int process() {
        int n;
        FeatureSet sourceFeatures;
        block15: {
            int n2;
            block14: {
                int n3;
                block13: {
                    if (StringUtils.isBlank((CharSequence)this.fieldRevisionName)) {
                        LOGGER.warn("fieldRevisionName can't be blank,");
                        return 25;
                    }
                    sourceFeatures = null;
                    try {
                        this.status.message("Preparing data...");
                        FeatureAttributeDescriptor sourceAttrRevisionName = this.getSourceFeatureType().getAttributeDescriptor(this.fieldRevisionName);
                        if (sourceAttrRevisionName == null) {
                            LOGGER.warn("Field '" + this.fieldRevisionName + "' (fieldRevisionName) has not been found in the source table.");
                            int n4 = 25;
                            return n4;
                        }
                        this.sourceFieldRevisionName = sourceAttrRevisionName.getName();
                        if (StringUtils.isNotBlank((CharSequence)this.fieldEfectiveDateName)) {
                            this.sourceFieldEfectiveDateName = this.getSourceFeatureType().getAttributeDescriptor(this.fieldEfectiveDateName).getName();
                        }
                        FeatureQuery theSourceQuery = this.getSourceQuery();
                        sourceFeatures = this.sourceStore.getFeatureSet(theSourceQuery);
                        this.sourceSize = sourceFeatures.size64();
                        this.status.setRangeOfValues(0L, this.sourceSize);
                        this.status.setCurValue(0L);
                        int result = this.process_minimize_memory(sourceFeatures, this.createGroupByRevisionNumber(this.sourceFieldRevisionName), false, this.sourceFieldEfectiveDateName);
                        if (result != 0) {
                            this.status.abort();
                            n3 = result;
                            DisposeUtils.disposeQuietly((Disposable)sourceFeatures);
                            break block13;
                        }
                        this.status.message("Finished.");
                        this.status.terminate();
                        if (this.hasErrors()) {
                            n2 = 25;
                            DisposeUtils.disposeQuietly((Disposable)sourceFeatures);
                            break block14;
                        }
                        n = 0;
                        DisposeUtils.disposeQuietly((Disposable)sourceFeatures);
                        break block15;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't import history", (Throwable)ex);
                        this.status.abort();
                        FeatureStore.cancelEditingQuietly((FeatureStore)this.getTargetStore());
                        int n5 = 25;
                        return n5;
                    }
                }
                this.disposeTargetStore();
                return n3;
            }
            this.disposeTargetStore();
            return n2;
        }
        this.disposeTargetStore();
        return n;
        finally {
            DisposeUtils.disposeQuietly(sourceFeatures);
            this.disposeTargetStore();
        }
    }
}

