/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.initserver;

import java.awt.Cursor;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.ProjectionPickerController;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.swing.VCSGisJInitServer;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.initserver.VCSGisJInitServerView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJInitServerImpl
extends VCSGisJInitServerView
implements Component,
VCSGisJInitServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJInitServerImpl.class);
    private PickerController<JDBCServerExplorerParameters> connectionPicker;
    private Dialog dialog;
    private JDBCServerExplorerParameters connection;
    private JDBCServerExplorer server;
    private ProjectionPickerController crsPickerController;
    private PickerController<Envelope> bboxPickerController;

    public VCSGisJInitServerImpl() {
        this.translate();
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        VCSGisSwingServices vcsgisservices = VCSGisSwingLocator.getVCSGisSwingManager().getDefaultServices();
        LabeledValue mapControl = vcsgisservices.getActiveMapControl();
        this.btnAddConnection.setCursor(Cursor.getPredefinedCursor(12));
        toolsSwingManager.translate(this.lblConnection);
        this.connectionPicker = DALSwingLocator.getSwingManager().createJDBCConnectionPickerController(this.cboConnections, this.btnAddConnection);
        this.connectionPicker.addChangeListener(e -> {
            this.connection = null;
            this.server = null;
            this.doUpdateEnableComponents();
        });
        this.bboxPickerController = mapControlManager.createEnvelopePickerController((MapControl)mapControl.getValue(), (JTextComponent)this.txtBbox, this.btnBBoxFromMapcontrol, this.btnBboxCapture);
        this.crsPickerController = dataSwingManager.createProjectionPickerController(this.txtCRS, this.btnCRS);
        this.crsPickerController.set((Object)CRSFactory.getCRS((String)"EPSG:25830"));
        this.bboxPickerController.set(null);
        this.chkInedxGeometries.setSelected(true);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)5, (int)80, (int)10, (int)140);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateEnableComponents();
    }

    private void doUpdateEnableComponents() {
        boolean enableInit;
        boolean bl = enableInit = this.getServer() != null;
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, enableInit);
        }
    }

    public int initialize() {
        if (this.getServer() != null) {
            VCSGisManager manager = VCSGisLocator.getVCSGisManager();
            IProjection crs = (IProjection)this.crsPickerController.get();
            Envelope bbox = (Envelope)this.bboxPickerController.get();
            boolean indexGeometries = this.chkInedxGeometries.isSelected();
            return manager.initRepository(this.server.getParameters(), crs, bbox, indexGeometries, null);
        }
        return -1;
    }

    public JDBCServerExplorerParameters getConnection() {
        if (this.connection == null) {
            this.connection = (JDBCServerExplorerParameters)this.connectionPicker.get();
        }
        return this.connection;
    }

    public String getConnectionLabel() {
        String label = "";
        if (this.getConnection() != null) {
            ListElement item = (ListElement)this.cboConnections.getSelectedItem();
            label = item.getLabel();
        }
        return label;
    }

    public JDBCServerExplorer getServer() {
        if (this.server == null) {
            try {
                DataManager dataManager = DALLocator.getDataManager();
                if (this.getConnection() != null) {
                    this.server = (JDBCServerExplorer)dataManager.openServerExplorer(this.getConnection().getExplorerName(), (DataServerExplorerParameters)this.getConnection());
                }
            }
            catch (InitializeException | ProviderNotRegisteredException | ValidateDataParametersException ex) {
                LOGGER.warn("Can't open server " + this.getConnection().getExplorerName());
            }
        }
        return this.server;
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblConnection);
        swingManager.translate(this.lblBbox);
        swingManager.translate(this.lblCRS);
        swingManager.translate(this.lblIndexGeometries);
    }

    public boolean isProcessing() {
        return false;
    }
}

