/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.initworkspace;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.TextFieldWithHistoryAndBookmarkController;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceDescriptor;
import org.gvsig.vcsgis.swing.VCSGisJInitWorkspace;
import org.gvsig.vcsgis.swing.impl.initworkspace.VCSGisJInitWorkspaceView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJInitWorkspaceImpl
extends VCSGisJInitWorkspaceView
implements Component,
VCSGisJInitWorkspace {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJInitWorkspaceImpl.class);
    private Dialog dialog;
    private PickerController<JDBCServerExplorerParameters> repositoryServerPicker;
    private JDBCServerExplorer repositoryServer;
    private VCSGisRepository repository;
    private JDBCServerExplorer workspaceServer;
    private FilePickerController workspaceFilePicker;
    private PickerController<JDBCServerExplorerParameters> workspaceServerPicker;
    private TextFieldWithHistoryAndBookmarkController repositoryServiceURLController;
    private Map<JDBCServerExplorerParameters, Boolean> validRepsitoties;

    public VCSGisJInitWorkspaceImpl() {
        this.translate();
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        this.workspaceServerPicker = dataSwingManager.createJDBCConnectionPickerController(this.cboWorkspaceConnection, this.btnWorkspaceConnection);
        this.workspaceServerPicker.addChangeListener(e -> SwingUtilities.invokeLater(() -> {
            this.workspaceServer = null;
            if (StringUtils.isBlank((CharSequence)this.txtName.getText())) {
                JDBCServerExplorerParameters server = (JDBCServerExplorerParameters)this.workspaceServerPicker.get();
                this.txtName.setText(server.getDBName());
            }
            this.doUpdateEnableComponents();
        }));
        this.repositoryServerPicker = dataSwingManager.createJDBCConnectionPickerController(this.cboRepositoryConnection, this.btnRepositoryConnection);
        this.repositoryServerPicker.addChangeListener(e -> {
            this.repositoryServer = null;
            this.repository = null;
            this.doUpdateEnableComponents();
        });
        this.workspaceFilePicker = toolsSwingManager.createFilePickerController((JTextComponent)this.txtWorkspaceFile, this.btnWorkspaceFile);
        this.workspaceFilePicker.addChangeListener(e -> {
            File file;
            if (StringUtils.isBlank((CharSequence)this.txtName.getText()) && (file = (File)this.workspaceFilePicker.get()) != null) {
                this.txtName.setText(H2SpatialUtils.removeH2FileNameExtension((String)file.getName()));
            }
            this.doUpdateEnableComponents();
        });
        this.txtWorkspaceFile.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                VCSGisJInitWorkspaceImpl.this.doUpdateEnableComponents();
            }
        });
        this.rdbRepositoryDatabaseServer.addActionListener(e -> {
            if (this.rdbRepositoryDatabaseServer.isSelected()) {
                this.repositoryServerPicker.setEnabled(true);
                this.repositoryServiceURLController.setEnabled(false);
                this.repository = null;
                this.repositoryServer = null;
                this.doUpdateEnableComponents();
            }
        });
        this.rdbRepositoryService.addActionListener(e -> {
            if (this.rdbRepositoryService.isSelected()) {
                this.repositoryServerPicker.setEnabled(false);
                this.repositoryServiceURLController.setEnabled(true);
                this.repository = null;
                this.repositoryServer = null;
                this.doUpdateEnableComponents();
            }
        });
        this.txtName.addActionListener(e -> this.doUpdateEnableComponents());
        this.txtName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                VCSGisJInitWorkspaceImpl.this.doUpdateEnableComponents();
            }
        });
        this.rdbWorkspacePersonalDatabase.addActionListener(e -> {
            if (this.rdbWorkspacePersonalDatabase.isSelected()) {
                this.workspaceFilePicker.setEnabled(true);
                this.chkCreateConnectionToDatabase.setEnabled(true);
                this.workspaceServerPicker.setEnabled(false);
                this.workspaceServer = null;
                this.doUpdateEnableComponents();
            }
        });
        this.rdbWorkspaceServerDatabase.addActionListener(e -> {
            if (this.rdbWorkspaceServerDatabase.isSelected()) {
                this.workspaceFilePicker.setEnabled(false);
                this.chkCreateConnectionToDatabase.setEnabled(false);
                this.workspaceServerPicker.setEnabled(true);
                this.workspaceServer = null;
                this.doUpdateEnableComponents();
            }
        });
        this.repositoryServiceURLController = toolsSwingManager.createTextFieldWithHistoryAndBookmarkController("VCSGisRepositoryURL", (JTextComponent)this.txtRepositoryServiceURL, null, this.btnRepositoryServiceURLHistory, this.btnRepositoryServiceURLBookmarks);
        this.rdbWorkspaceServerDatabase.setSelected(true);
        this.repositoryServiceURLController.setEnabled(false);
        this.rdbWorkspacePersonalDatabase.setSelected(true);
        SwingUtilities.invokeLater(() -> this.lblMsg.setText(""));
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)23, (int)70);
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateEnableComponents();
    }

    private void doUpdateEnableComponents() {
        this.message("");
        String wsname = this.txtName.getText();
        boolean enableInit = true;
        if (this.rdbRepositoryDatabaseServer.isSelected()) {
            if (this.getRepository() == null) {
                if (this.getRepositoryConnection() == null) {
                    this.message2(enableInit, "_It_is_necessary_to_select_a_valid_database_connection_as_repository");
                } else if (this.getRepositoryServer() == null) {
                    this.message2(enableInit, "_The_repository_selected_is_not_a_valid_database");
                } else {
                    this.message2(enableInit, "_The_repository_selected_is_not_a_valid_repository");
                }
                enableInit = false;
            } else {
                enableInit = true;
            }
        } else if (this.rdbRepositoryService.isSelected()) {
            if (this.getRepositoryURL() == null) {
                if (StringUtils.isBlank((CharSequence)this.txtRepositoryServiceURL.getText())) {
                    this.message2(enableInit, "_The_repository_url_is_blank");
                } else {
                    this.message2(enableInit, "_Invalid_repository_url");
                }
                enableInit = false;
            } else {
                enableInit = true;
            }
        }
        if (this.rdbWorkspacePersonalDatabase.isSelected()) {
            File f = this.getWorkspaceFile();
            if (f == null) {
                this.message2(enableInit, "_Selected_working_copy_file_is_not_valid");
                enableInit = false;
            } else if ((f = H2SpatialUtils.normalizeH2File((File)f)).exists()) {
                this.message2(enableInit, "_Selected_working_copy_file_already_exists");
                enableInit = false;
            } else {
                enableInit = true;
            }
        } else if (this.rdbWorkspaceServerDatabase.isSelected()) {
            if (this.getWorkspaceServer() == null) {
                this.message2(enableInit, "_Selected_working_copy_database_is_not_valid");
                enableInit = false;
            } else {
                enableInit = true;
            }
        }
        if (StringUtils.isBlank((CharSequence)wsname)) {
            this.message2(enableInit, "_Need_a_working_copy_name");
            enableInit = false;
        } else {
            VCSGisManager manager = VCSGisLocator.getVCSGisManager();
            VCSGisWorkspaceDescriptor ws = manager.getWorkspaceDescriptor(wsname);
            if (ws != null) {
                this.message2(enableInit, "_A_working_copy_with_that_name_already_exists");
                enableInit = false;
            }
        }
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, enableInit);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.chkCreateConnectionToDatabase);
        swingManager.translate(this.lblName);
        swingManager.translate(this.lblUrl);
        swingManager.translate((JComponent)this.lblRepository);
        swingManager.translate(this.lblRepositoryConnection);
        swingManager.translate(this.lblRepositoryConnection);
        swingManager.translate(this.lblWorkspaceConnection);
        swingManager.translate(this.lblWorkspaceFile);
        swingManager.translate((JComponent)this.lblWorkspaceVCS);
        swingManager.translate((AbstractButton)this.rdbRepositoryDatabaseServer);
        swingManager.translate((AbstractButton)this.rdbRepositoryService);
        swingManager.translate((AbstractButton)this.rdbWorkspacePersonalDatabase);
        swingManager.translate((AbstractButton)this.rdbWorkspaceServerDatabase);
    }

    private boolean isRepository(JDBCServerExplorerParameters connection) {
        Boolean valid;
        if (this.validRepsitoties == null) {
            this.validRepsitoties = new HashMap<JDBCServerExplorerParameters, Boolean>();
        }
        if ((valid = this.validRepsitoties.get(connection)) == null) {
            valid = VCSGisLocator.getManager().isRepository(connection);
            this.validRepsitoties.put(connection, valid);
        }
        return valid;
    }

    private JDBCServerExplorerParameters getRepositoryConnection() {
        JDBCServerExplorerParameters repoConnection;
        if (this.rdbRepositoryDatabaseServer.isEnabled() && this.repositoryServerPicker.isEnabled() && this.isRepository(repoConnection = (JDBCServerExplorerParameters)this.repositoryServerPicker.get())) {
            return repoConnection;
        }
        return null;
    }

    private URL getRepositoryURL() {
        if (this.rdbRepositoryService.isEnabled() && this.repositoryServiceURLController.isEnabled()) {
            URL url;
            String value = this.repositoryServiceURLController.getText();
            DataTypesManager manager = ToolsLocator.getDataTypesManager();
            try {
                url = (URL)manager.coerce(16, (Object)value);
            }
            catch (CoercionException ex) {
                String s = value == null ? "null" : StringUtils.abbreviate((String)value, (int)100);
                LOGGER.warn("Can't coerce value (" + s + ") to " + "URL" + ".", (Throwable)ex);
                return null;
            }
            return url;
        }
        return null;
    }

    private File getWorkspaceFile() {
        File file = (File)this.workspaceFilePicker.get();
        return file;
    }

    public int initializeWorkspace() {
        URL repourl;
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisRepository theRepository = this.getRepository();
        int err = 0;
        if (theRepository != null) {
            try {
                JDBCServerExplorer workspaceServerExplorer;
                if (this.rdbWorkspacePersonalDatabase.isSelected()) {
                    File file = this.getWorkspaceFile();
                    if (file != null && (err = manager.initWorkspace(file, theRepository, this.getWorkspaceName(), null)) == 0 && this.chkCreateConnectionToDatabase.isSelected()) {
                        VCSGisWorkspace ws = manager.openWorkspace(file);
                        ws.addToConnectionPool();
                    }
                } else if (this.rdbWorkspaceServerDatabase.isSelected() && (workspaceServerExplorer = this.getWorkspaceServer()) != null) {
                    err = manager.initWorkspace(workspaceServerExplorer, theRepository, this.getWorkspaceName(), null);
                }
            }
            catch (UserCancelledException ex) {
                LOGGER.info("Cancelled by user.");
                err = 17;
            }
            catch (Exception ex) {
                LOGGER.info("Can't initialize workspace", (Throwable)ex);
                err = 25;
            }
        }
        if (err == 0 && (repourl = this.getRepositoryURL()) != null) {
            this.repositoryServiceURLController.addHistory(repourl.toString());
        }
        return err;
    }

    private VCSGisRepository getRepository() {
        if (this.repository == null) {
            URL url;
            VCSGisManager manager = VCSGisLocator.getVCSGisManager();
            if (this.rdbRepositoryDatabaseServer.isSelected()) {
                JDBCServerExplorer server = this.getRepositoryServer();
                if (server != null) {
                    this.repository = manager.openRepository(server.getParameters());
                }
            } else if (this.rdbRepositoryService.isSelected() && (url = this.getRepositoryURL()) != null) {
                this.repository = manager.openRepository(url);
            }
        }
        return this.repository;
    }

    private JDBCServerExplorer getRepositoryServer() {
        JDBCServerExplorerParameters conn = this.getRepositoryConnection();
        if (this.repositoryServer == null && conn != null) {
            try {
                DataManager dataManager = DALLocator.getDataManager();
                this.repositoryServer = (JDBCServerExplorer)dataManager.openServerExplorer(conn.getExplorerName(), (DataServerExplorerParameters)conn);
            }
            catch (InitializeException | ProviderNotRegisteredException | ValidateDataParametersException ex) {
                LOGGER.warn("Can't open server " + conn.getExplorerName());
                this.repositoryServer = null;
            }
        }
        return this.repositoryServer;
    }

    private JDBCServerExplorerParameters getWorkspaceConnection() {
        if (this.rdbWorkspaceServerDatabase.isEnabled() && this.workspaceServerPicker.isEnabled()) {
            return (JDBCServerExplorerParameters)this.workspaceServerPicker.get();
        }
        return null;
    }

    private JDBCServerExplorer getWorkspaceServer() {
        JDBCServerExplorerParameters conn = this.getWorkspaceConnection();
        if (this.workspaceServer == null && conn != null) {
            try {
                DataManager dataManager = DALLocator.getDataManager();
                this.workspaceServer = (JDBCServerExplorer)dataManager.openServerExplorer(conn.getExplorerName(), (DataServerExplorerParameters)conn);
            }
            catch (InitializeException | ProviderNotRegisteredException | ValidateDataParametersException ex) {
                LOGGER.warn("Can't open server " + conn.getExplorerName());
                this.workspaceServer = null;
            }
        }
        return this.workspaceServer;
    }

    public String getWorkspaceName() {
        return this.txtName.getText();
    }

    public static void selfRegister() {
    }

    public boolean isProcessing() {
        return false;
    }

    private void message2(boolean doMessage, String s) {
        if (doMessage) {
            this.message(s);
        }
    }

    private void message(String s) {
        if (StringUtils.startsWith((CharSequence)s, (CharSequence)"_")) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            s = i18n.getTranslation(s);
        }
        this.lblMsg.setText(s);
    }
}

