/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.managehistory;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupHistory
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupHistory.class);
    public static final String ENTITIES_FILE_PREFIX = "ENTITIES_";
    public static final String REVISIONS_FILE_PREFIX = "REVISIONS_";
    public static final String DATA_FILE_PREFIX = "DATA_";
    private final JDBCServerExplorerParameters repository;
    private final File targetfolder;
    private final VCSGisEntity entity;
    private SimpleTaskStatus status;

    public BackupHistory(JDBCServerExplorerParameters repository, File targetFolder, VCSGisEntity entity, SimpleTaskStatus status) {
        this.repository = repository;
        this.targetfolder = targetFolder;
        this.entity = entity;
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        if (this.status == null) {
            this.status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("vcsgis init");
            this.status.setAutoremove(true);
            this.status.add();
        } else {
            this.status.push();
        }
        DataManager dataManager = DALLocator.getDataManager();
        long t1 = System.currentTimeMillis();
        try {
            LOGGER.info("Backup history started (" + this.entity.getEntityName() + ").");
            JDBCServerExplorer sourceExplorer = (JDBCServerExplorer)dataManager.openServerExplorer(this.repository.getExplorerName(), (DataServerExplorerParameters)this.repository);
            FilesystemServerExplorerParameters targetParameters = (FilesystemServerExplorerParameters)dataManager.createServerExplorerParameters("FilesystemExplorer");
            targetParameters.setRoot(this.targetfolder.getAbsolutePath());
            targetParameters.setInitialpath(this.targetfolder.getAbsolutePath());
            FilesystemServerExplorer targetExplorer = (FilesystemServerExplorer)dataManager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)targetParameters);
            this.exportEntitiesTable(sourceExplorer, targetExplorer, this.entity);
            if (!this.status.isRunning()) {
                Integer n = 17;
                return n;
            }
            Map<String, Long> revisionsMap = this.exportRevisionsTable(sourceExplorer, targetExplorer, this.entity);
            if (!this.status.isRunning()) {
                Integer n = 17;
                return n;
            }
            this.exportDataTable(sourceExplorer, targetExplorer, this.entity, revisionsMap);
            if (!this.status.isRunning()) {
                Integer n = 17;
                return n;
            }
            this.status.terminate();
            LOGGER.info("Backup history finishing (" + this.entity.getEntityName() + ". " + (System.currentTimeMillis() - t1) + " ms).");
            Integer n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't export history.", (Throwable)ex);
            this.status.abort();
            Integer n = 25;
            return n;
        }
        finally {
            LOGGER.info("Backup history finished (" + this.entity.getEntityName() + ", " + (System.currentTimeMillis() - t1) + " ms).");
            this.status.pop();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportEntitiesTable(JDBCServerExplorer sourceExplorer, FilesystemServerExplorer targetExplorer, VCSGisEntity entity) throws Exception {
        FeatureStore targetStore;
        FeatureStore sourceFeatureStore;
        block7: {
            sourceFeatureStore = null;
            targetStore = null;
            try {
                this.status.message("Exporting entities table.");
                String sourceTable = "VCSGISREPO_ENTITIES";
                String targetTable = ENTITIES_FILE_PREFIX + entity.getEntityName();
                String filter = "\"COD_ENTITY\"='" + entity.getEntityCode() + "'";
                DataManager dataManager = DALLocator.getDataManager();
                JDBCStoreParameters sourceOpenParameters = sourceExplorer.getOpenParameters();
                sourceOpenParameters.setTable(sourceTable);
                sourceFeatureStore = (FeatureStore)sourceExplorer.open((DataStoreParameters)sourceOpenParameters);
                File targetFile = new File(targetExplorer.getRoot(), targetTable + ".csv");
                NewFeatureStoreParameters addParameters = (NewFeatureStoreParameters)targetExplorer.getAddParameters(targetFile);
                addParameters.setDefaultFeatureType((FeatureType)sourceFeatureStore.getDefaultFeatureTypeQuietly().getCopy().getEditable());
                targetExplorer.add(addParameters.getProviderName(), (NewDataStoreParameters)addParameters, true);
                FeatureSet features = sourceFeatureStore.getFeatureSet(filter);
                DataStoreParameters openParameters = dataManager.createStoreParameters("CSV");
                openParameters.fromJson(addParameters.toJson());
                targetStore = (FeatureStore)dataManager.openStore(openParameters.getProviderName(), openParameters);
                targetStore.edit(2);
                for (Feature feature : features) {
                    if (this.status.isCancellationRequested()) {
                        this.status.cancel();
                        FeatureStore.cancelEditingQuietly((FeatureStore)targetStore);
                        break block7;
                    }
                    EditableFeature f = targetStore.createNewFeature();
                    f.copyFrom(feature);
                    targetStore.insert(f);
                }
                targetStore.finishEditingQuietly();
            }
            catch (Exception ex) {
                try {
                    LOGGER.warn("Can't export '" + entity.getEntityName() + "'.", (Throwable)ex);
                    FeatureStore.cancelEditingQuietly(targetStore);
                    throw ex;
                }
                catch (Throwable throwable) {
                    DisposeUtils.dispose(sourceFeatureStore);
                    DisposeUtils.dispose(targetStore);
                    throw throwable;
                }
            }
            DisposeUtils.dispose((Disposable)sourceFeatureStore);
            DisposeUtils.dispose((Disposable)targetStore);
            return;
        }
        DisposeUtils.dispose((Disposable)sourceFeatureStore);
        DisposeUtils.dispose((Disposable)targetStore);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Long> exportRevisionsTable(JDBCServerExplorer sourceExplorer, FilesystemServerExplorer targetExplorer, VCSGisEntity entity) throws Exception {
        Map map;
        FeatureStore targetStore;
        FeatureStore sourceFeatureStore;
        block7: {
            Object object;
            sourceFeatureStore = null;
            targetStore = null;
            try {
                this.status.message("Exporting revision table.");
                String sourceTable = "VCSGISREPO_REVISIONS";
                String targetTable = REVISIONS_FILE_PREFIX + entity.getEntityName();
                String filter = "\"COD_ENTITY\"='" + entity.getEntityCode() + "'";
                String order = "+REV_NUMBER";
                DataManager dataManager = DALLocator.getDataManager();
                JDBCStoreParameters sourceOpenParameters = sourceExplorer.getOpenParameters();
                sourceOpenParameters.setTable(sourceTable);
                sourceFeatureStore = (FeatureStore)sourceExplorer.open((DataStoreParameters)sourceOpenParameters);
                File targetFile = new File(targetExplorer.getRoot(), targetTable + ".csv");
                NewFeatureStoreParameters addParameters = (NewFeatureStoreParameters)targetExplorer.getAddParameters(targetFile);
                addParameters.setDefaultFeatureType((FeatureType)sourceFeatureStore.getDefaultFeatureTypeQuietly().getCopy().getEditable());
                targetExplorer.add(addParameters.getProviderName(), (NewDataStoreParameters)addParameters, true);
                FeatureSet features = sourceFeatureStore.getFeatureSet(filter, order);
                Map revisionsMap = dataManager.createLargeMap();
                long cont = 0L;
                DataStoreParameters openParameters = dataManager.createStoreParameters("CSV");
                openParameters.fromJson(addParameters.toJson());
                targetStore = (FeatureStore)dataManager.openStore(openParameters.getProviderName(), openParameters);
                targetStore.edit(2);
                this.status.setRangeOfValues(0L, features.size64());
                this.status.setCurValue(0L);
                for (Feature feature : features) {
                    if (this.status.isCancellationRequested()) {
                        this.status.cancel();
                        FeatureStore.cancelEditingQuietly((FeatureStore)targetStore);
                        map = revisionsMap;
                        break block7;
                    }
                    EditableFeature f = targetStore.createNewFeature();
                    f.copyFrom(feature);
                    revisionsMap.put(f.getString("COD_REVISION"), cont);
                    f.set("REV_NUMBER", (Object)cont++);
                    targetStore.insert(f);
                    this.status.incrementCurrentValue();
                }
                targetStore.finishEditingQuietly();
                object = revisionsMap;
            }
            catch (Exception ex) {
                try {
                    LOGGER.warn("Can't export '" + entity.getEntityName() + "'.", (Throwable)ex);
                    FeatureStore.cancelEditingQuietly(targetStore);
                    throw ex;
                }
                catch (Throwable throwable) {
                    DisposeUtils.dispose(sourceFeatureStore);
                    DisposeUtils.dispose(targetStore);
                    throw throwable;
                }
            }
            DisposeUtils.dispose((Disposable)sourceFeatureStore);
            DisposeUtils.dispose((Disposable)targetStore);
            return object;
        }
        DisposeUtils.dispose((Disposable)sourceFeatureStore);
        DisposeUtils.dispose((Disposable)targetStore);
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportDataTable(JDBCServerExplorer sourceExplorer, FilesystemServerExplorer targetExplorer, VCSGisEntity entity, Map<String, Long> revisionsMap) throws Exception {
        FeatureStore targetStore;
        FeatureStore sourceFeatureStore;
        block9: {
            sourceFeatureStore = null;
            targetStore = null;
            File targetFile = null;
            String cod_data = null;
            try {
                this.status.message("Exporting data table.");
                String sourceTable = "VCSGISREPO_DATA";
                String targetTable = DATA_FILE_PREFIX + entity.getEntityName();
                String filter = "\"COD_ENTITY\"='" + entity.getEntityCode() + "'";
                DataManager dataManager = DALLocator.getDataManager();
                JDBCStoreParameters sourceOpenParameters = sourceExplorer.getOpenParameters();
                sourceOpenParameters.setTable(sourceTable);
                sourceFeatureStore = (FeatureStore)sourceExplorer.open((DataStoreParameters)sourceOpenParameters);
                targetFile = new File(targetExplorer.getRoot(), targetTable + ".csv");
                NewFeatureStoreParameters addParameters = (NewFeatureStoreParameters)targetExplorer.getAddParameters(targetFile);
                addParameters.setDefaultFeatureType((FeatureType)sourceFeatureStore.getDefaultFeatureTypeQuietly().getCopy().getEditable());
                targetExplorer.add(addParameters.getProviderName(), (NewDataStoreParameters)addParameters, true);
                FeatureSet features = sourceFeatureStore.getFeatureSet(filter);
                DataStoreParameters openParameters = dataManager.createStoreParameters("CSV");
                openParameters.fromJson(addParameters.toJson());
                targetStore = (FeatureStore)dataManager.openStore(openParameters.getProviderName(), openParameters);
                targetStore.edit(2);
                this.status.setRangeOfValues(0L, features.size64());
                this.status.setCurValue(0L);
                for (Feature feature : features) {
                    cod_data = feature.getString("COD_DATA");
                    if (this.status.isCancellationRequested()) {
                        this.status.cancel();
                        FeatureStore.cancelEditingQuietly((FeatureStore)targetStore);
                        break block9;
                    }
                    EditableFeature f = targetStore.createNewFeature();
                    f.copyFrom(feature);
                    f.set("DAT_REVNUMBER", (Object)revisionsMap.get(f.getString("COD_REVISION")));
                    targetStore.insert(f);
                    this.status.incrementCurrentValue();
                }
                targetStore.finishEditingQuietly();
            }
            catch (Exception ex) {
                try {
                    LOGGER.warn("Can't export '" + entity.getEntityName() + "' (cod_data=" + cod_data + ").", (Throwable)ex);
                    if (targetStore == null) throw ex;
                    try {
                        targetStore.cancelEditing();
                        throw ex;
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Can't cancel editing  '" + Objects.toString(targetFile) + "'.", (Throwable)ex);
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    DisposeUtils.dispose(sourceFeatureStore);
                    DisposeUtils.dispose(targetStore);
                    throw throwable;
                }
            }
            DisposeUtils.dispose((Disposable)sourceFeatureStore);
            DisposeUtils.dispose((Disposable)targetStore);
            return;
        }
        DisposeUtils.dispose((Disposable)sourceFeatureStore);
        DisposeUtils.dispose((Disposable)targetStore);
    }
}

