/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.prepareworkspace;

import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.impl.prepareworkspace.CategoriesChooserView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoriesChooserImpl
extends CategoriesChooserView {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoriesChooserImpl.class);
    private PickerController<VCSGisWorkspace> workspacePicker;

    public CategoriesChooserImpl() {
        this.initComponents();
    }

    private void initComponents() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspace, null);
        this.workspacePicker.addChangeListener(e -> this.doChangeWorkspace());
    }

    public VCSGisWorkspace getWorkspace() {
        return (VCSGisWorkspace)this.workspacePicker.get();
    }

    private void doChangeWorkspace() {
        try {
            DefaultListModel<String> model = new DefaultListModel<String>();
            VCSGisWorkspace ws = this.getWorkspace();
            if (ws == null) {
                this.lstCategories.setModel(model);
                return;
            }
            Collection categories = ws.getEntityCategories();
            for (String category : categories) {
                model.addElement(category);
            }
            this.lstCategories.setModel(model);
        }
        catch (Exception e2) {
            LOGGER.warn("Can't set workspace.", (Throwable)e2);
        }
    }

    public String getCategories() {
        List selection = this.lstCategories.getSelectedValuesList();
        if (selection == null || selection.isEmpty()) {
            return "";
        }
        String s = StringUtils.join(selection, (String)",");
        s = StringUtils.removeEnd((String)s, (String)",");
        return s;
    }
}

