/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.prepareworkspace;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.ComponentWithHistoryAndBookmarkController;
import org.gvsig.tools.swing.api.bookmarkshistory.TextFieldWithHistoryAndBookmarkController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.swing.VCSGisJPrepareWorkingcopy;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.prepareworkspace.CategoriesChooserImpl;
import org.gvsig.vcsgis.swing.impl.prepareworkspace.PrepareWorkspaceView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareWorkspaceImpl
extends PrepareWorkspaceView
implements VCSGisJPrepareWorkingcopy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrepareWorkspaceImpl.class);
    private static final String BOOKMARKSANDHISTORY_NAME = "VCSGis.gui.prepareworkspace.name";
    private static final String BOOKMARKSANDHISTORY_LABEL = "VCSGis.gui.prepareworkspace.label";
    private static final String BOOKMARKSANDHISTORY_CATEGORIES = "VCSGis.gui.prepareworkspace.categories";
    private static final String BOOKMARKSANDHISTORY_USER = "VCSGis.gui.prepareworkspace.user";
    private Dialog dialog;
    private boolean processing = false;
    private TextFieldWithHistoryAndBookmarkController urlrepositoryController;
    private DocumentListener textChangeListener;
    private ComponentWithHistoryAndBookmarkController nameController;
    private ComponentWithHistoryAndBookmarkController labelController;
    private ComponentWithHistoryAndBookmarkController categoriesController;
    private ComponentWithHistoryAndBookmarkController userController;

    public PrepareWorkspaceImpl() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblCategories);
        toolsSwingManager.translate(this.lblLabel);
        toolsSwingManager.translate(this.lblName);
        toolsSwingManager.translate(this.lblPassword);
        toolsSwingManager.translate(this.lblRepositoryURL);
        toolsSwingManager.translate(this.lblUser);
        toolsSwingManager.translate((AbstractButton)this.btnChooseCategories);
        this.urlrepositoryController = toolsSwingManager.createTextFieldWithHistoryAndBookmarkController("VCSGisRepositoryURL", (JTextComponent)this.txtRepositoryURL, this.btnURLRepositoryApply, this.btnURLRepositoryHistory, this.btnURLRepositoryBookmarks);
        this.urlrepositoryController.addActionListener(e -> this.doUpdateCompmentsEnabled());
        this.textChangeListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PrepareWorkspaceImpl.this.doUpdateCompmentsEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PrepareWorkspaceImpl.this.doUpdateCompmentsEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PrepareWorkspaceImpl.this.doUpdateCompmentsEnabled();
            }
        };
        this.btnChooseCategories.addActionListener(e -> this.doChooseCategories());
        this.nameController = toolsSwingManager.createComboBoxWithHistoryAndBookmarkController(BOOKMARKSANDHISTORY_NAME, this.cboName);
        this.labelController = toolsSwingManager.createComboBoxWithHistoryAndBookmarkController(BOOKMARKSANDHISTORY_LABEL, this.cboLabel);
        this.categoriesController = toolsSwingManager.createComboBoxWithHistoryAndBookmarkController(BOOKMARKSANDHISTORY_CATEGORIES, this.cboCategories);
        this.userController = toolsSwingManager.createComboBoxWithHistoryAndBookmarkController(BOOKMARKSANDHISTORY_USER, this.cboUser);
        this.getJTextComponent(this.cboName).getDocument().addDocumentListener(this.textChangeListener);
        this.getJTextComponent(this.cboLabel).getDocument().addDocumentListener(this.textChangeListener);
        this.getJTextComponent(this.cboCategories).getDocument().addDocumentListener(this.textChangeListener);
        this.btnCopyURL.addActionListener(e -> this.doCopyURL());
        this.doUpdateCompmentsEnabled();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)10, (int)70, (int)24, (int)100);
    }

    private JTextComponent getJTextComponent(JComboBox combo) {
        return (JTextComponent)combo.getEditor().getEditorComponent();
    }

    private void doUpdateCompmentsEnabled() {
        boolean enable;
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doUpdateCompmentsEnabled())) {
            return;
        }
        if (this.processing) {
            this.urlrepositoryController.setEnabled(false);
            this.cboName.setEnabled(false);
            this.cboLabel.setEnabled(false);
            this.cboCategories.setEnabled(false);
            this.btnChooseCategories.setEnabled(false);
            this.cboUser.setEnabled(false);
            this.txtPassword.setEnabled(false);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        boolean validUrl = false;
        try {
            URL url = new URL(this.txtRepositoryURL.getText());
            validUrl = true;
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        this.urlrepositoryController.setEnabled(true);
        this.cboName.setEnabled(true);
        this.cboLabel.setEnabled(true);
        this.cboCategories.setEnabled(true);
        this.cboUser.setEnabled(true);
        this.txtPassword.setEnabled(true);
        boolean bl = enable = validUrl && StringUtils.isNotBlank((CharSequence)this.getWorkingCopyName()) && StringUtils.isNotBlank((CharSequence)this.getWorkingCopyLabel()) && StringUtils.isNotBlank((CharSequence)this.getCategories()) && StringUtils.isNotBlank((CharSequence)this.txtRepositoryURL.getText());
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare() {
        URL url;
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        try {
            url = new URL(this.txtRepositoryURL.getText());
        }
        catch (MalformedURLException ex) {
            return 25;
        }
        String pass = String.valueOf(this.txtPassword.getPassword());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.getUsername()}) && StringUtils.isBlank((CharSequence)pass)) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            int n = dialogs.confirmDialog(i18n.getTranslation("_The_password_is_blank") + " " + i18n.getTranslation("_Do_you_want_to_continue"), i18n.getTranslation("_VCS_Prepare_workingcopy"), 0, 3);
            if (n != 0) {
                return 10000;
            }
        }
        try {
            this.processing = true;
            this.doUpdateCompmentsEnabled();
            int n = manager.preparedWorkingCopy(url, this.getWorkingCopyName(), this.getWorkingCopyLabel(), this.getCategories(), this.getUsername(), pass);
            this.nameController.addHistory(this.getWorkingCopyName());
            this.labelController.addHistory(this.getWorkingCopyLabel());
            this.categoriesController.addHistory(this.getCategories());
            this.userController.addHistory(this.getUsername());
            int n2 = n;
            return n2;
        }
        finally {
            this.processing = false;
            this.doUpdateCompmentsEnabled();
        }
    }

    private String getWorkingCopyName() {
        return (String)this.cboName.getSelectedItem();
    }

    private String getWorkingCopyLabel() {
        return (String)this.cboLabel.getSelectedItem();
    }

    private String getUsername() {
        return (String)this.cboUser.getSelectedItem();
    }

    private String getCategories() {
        return (String)this.cboCategories.getSelectedItem();
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void doCopyURL() {
        try {
            String s;
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            String pass = String.valueOf(this.txtPassword.getPassword());
            URL url = new URL(this.txtRepositoryURL.getText());
            URIBuilder builder = new URIBuilder();
            builder.setScheme(url.getProtocol());
            builder.setHost(url.getHost());
            builder.setPort(url.getPort());
            builder.setPath(url.getPath() + "/preparewc");
            builder.addParameter("name", this.getWorkingCopyName());
            builder.addParameter("label", this.getWorkingCopyLabel());
            builder.addParameter("username", this.getUsername());
            builder.addParameter("userpass", pass);
            builder.addParameter("categories", this.getCategories());
            URL targeturl = builder.build().toURL();
            int messageType = 1;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.getUsername()}) && StringUtils.isBlank((CharSequence)pass)) {
                s = i18n.getTranslation("_The_password_is_blank") + "\n\n" + targeturl.toString();
                messageType = 2;
            } else {
                s = targeturl.toString();
            }
            dialogs.messageDialog(s, "URL", messageType);
            ToolsSwingLocator.getToolsSwingManager().putInClipboard(targeturl.toString());
            this.nameController.addHistory(this.getWorkingCopyName());
            this.labelController.addHistory(this.getWorkingCopyLabel());
            this.categoriesController.addHistory(this.getCategories());
            this.userController.addHistory(this.getUsername());
        }
        catch (Exception ex) {
            LOGGER.warn("Can't put in clipboard url", (Throwable)ex);
        }
    }

    private void doChooseCategories() {
        CategoriesChooserImpl panel = new CategoriesChooserImpl();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog d = winManager.createDialog((JComponent)panel, "_Select_categories", null, 3);
        d.show(WindowManager.MODE.DIALOG);
        if (d.getAction() == 1) {
            this.cboCategories.setSelectedItem(panel.getCategories());
        }
    }
}

