/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.registrationOfEditingStores;

import java.awt.Cursor;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.swing.VCSGisPanel;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.registrationOfEditingStores.VCSGisJRegistrationOfEditingStoresView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJRegistrationOfEditingStoresImpl
extends VCSGisJRegistrationOfEditingStoresView
implements Component,
VCSGisPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJRegistrationOfEditingStoresImpl.class);
    private Dialog dialog;

    public VCSGisJRegistrationOfEditingStoresImpl() {
        this.translate();
        this.initComponents();
    }

    private void initComponents() {
        this.btnCancelEditing.setCursor(Cursor.getPredefinedCursor(12));
        this.btnFinishEditing.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRelease.setCursor(Cursor.getPredefinedCursor(12));
        this.btnRefresh.setCursor(Cursor.getPredefinedCursor(12));
        this.lstStores.addListSelectionListener(e -> this.doUpdateEnableComponents());
        this.btnCancelEditing.addActionListener(e -> {
            this.doCancelEditing();
            this.fillEditingStores();
            this.doUpdateEnableComponents();
        });
        this.btnFinishEditing.addActionListener(e -> {
            this.doFinishEditing();
            this.fillEditingStores();
            this.doUpdateEnableComponents();
        });
        this.btnRelease.addActionListener(e -> {
            this.doRelease();
            this.fillEditingStores();
            this.doUpdateEnableComponents();
        });
        this.btnRefresh.addActionListener(e -> {
            this.fillEditingStores();
            this.lstStores.getSelectionModel().clearSelection();
            this.doUpdateEnableComponents();
        });
        this.fillEditingStores();
        this.doUpdateEnableComponents();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)11, (int)60);
    }

    private void doRelease() {
        LabeledValue labeledStore = (LabeledValue)this.lstStores.getSelectedValue();
        if (labeledStore == null) {
            return;
        }
        FeatureStore store = (FeatureStore)labeledStore.getValue();
        if (store == null) {
            return;
        }
        if (store.getMode() != 0) {
            return;
        }
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        manager.forceRemoveFromEditingStores(store);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.fillEditingStores();
    }

    private void doFinishEditing() {
        LabeledValue labeledStore = (LabeledValue)this.lstStores.getSelectedValue();
        if (labeledStore == null) {
            return;
        }
        FeatureStore store = (FeatureStore)labeledStore.getValue();
        if (store == null) {
            return;
        }
        if (store.getMode() == 0) {
            return;
        }
        try {
            store.finishEditing();
        }
        catch (DataException ex) {
            LOGGER.warn("Can't force finish editing of '" + store.getName() + "'.", (Throwable)ex);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.fillEditingStores();
    }

    private void doCancelEditing() {
        LabeledValue labeledStore = (LabeledValue)this.lstStores.getSelectedValue();
        if (labeledStore == null) {
            return;
        }
        FeatureStore store = (FeatureStore)labeledStore.getValue();
        if (store == null) {
            return;
        }
        if (store.getMode() == 0) {
            return;
        }
        try {
            store.cancelEditing();
        }
        catch (DataException ex) {
            LOGGER.warn("Can't force cancel editing of '" + store.getName() + "'.", (Throwable)ex);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.fillEditingStores();
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateEnableComponents();
    }

    private void doUpdateEnableComponents() {
        LabeledValue labeledStore = (LabeledValue)this.lstStores.getSelectedValue();
        FeatureStore store = null;
        int mode = 0;
        if (labeledStore != null) {
            store = (FeatureStore)labeledStore.getValue();
            mode = store.getMode();
        }
        this.btnCancelEditing.setEnabled(store != null && mode != 0);
        this.btnFinishEditing.setEnabled(store != null && mode != 0);
        this.btnRelease.setEnabled(store != null && mode == 0);
        this.btnRefresh.setEnabled(true);
    }

    public JComponent asJComponent() {
        return this;
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnCancelEditing);
        swingManager.translate((AbstractButton)this.btnFinishEditing);
        swingManager.translate((AbstractButton)this.btnRelease);
        swingManager.translate((AbstractButton)this.btnRefresh);
        swingManager.translate((JComponent)this.lstStores);
    }

    private void fillEditingStores() {
        int n = this.lstStores.getSelectedIndex();
        this.lstStores.setSelectionMode(0);
        this.lstStores.getSelectionModel().addListSelectionListener(e -> this.doUpdateEnableComponents());
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingServices services = VCSGisSwingLocator.getVCSGisSwingManager().getDefaultServices();
        List stores_info = manager.getEditingStores();
        DefaultListModel<LabeledValueImpl> model = new DefaultListModel<LabeledValueImpl>();
        for (Pair store_info : stores_info) {
            String label;
            if (store_info == null) continue;
            FeatureStore store = (FeatureStore)((WeakReference)store_info.getLeft()).get();
            int mode = (Integer)store_info.getRight();
            if (store == null) {
                label = "unknown (" + this.getEditingModeLabel(mode) + ")";
            } else {
                label = mode == store.getMode() ? store.getName() + "(" + this.getEditingModeLabel(mode) + ")" : store.getName() + "(" + this.getEditingModeLabel(mode) + "/" + this.getEditingModeLabel(store.getMode()) + ") [*1]";
                if (!services.isInSomeDocument(store)) {
                    label = label + "[*2]";
                }
            }
            model.addElement(new LabeledValueImpl(label, (Object)store));
        }
        this.lstStores.setModel(model);
        try {
            if (n < 0) {
                n = 0;
            }
            if (n >= this.lstStores.getModel().getSize()) {
                n = this.lstStores.getModel().getSize() - 1;
            }
            this.lstStores.setSelectedIndex(n);
        }
        catch (Exception ex) {
            LOGGER.debug("", (Throwable)ex);
        }
    }

    private String getEditingModeLabel(int mode) {
        switch (mode) {
            case 0: {
                return "query";
            }
            case 1: {
                return "full-edit";
            }
            case 3: {
                return "pass-through";
            }
            case 2: {
                return "append";
            }
        }
        return "unknown";
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    public static void selfRegister() {
    }

    public boolean isProcessing() {
        return false;
    }
}

