/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.revisions;

import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ChangeListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingImplLibrary;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.revisions.RevisionsTableModel;
import org.h2.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJRevisionsController
implements ChangeListenerSupport,
Disposable {
    public static Logger LOGGER = LoggerFactory.getLogger(VCSGisJRevisionsController.class);
    private final JTable table;
    private final JButton btnMore;
    private final JButton btnFilter;
    private final JLabel lblMessages;
    private final ChangeListenerHelper changeListener;
    private VCSGisWorkspace workspace;
    private VCSGisEntity entity;
    private boolean processing;
    private boolean enabled;
    private String filter;

    public VCSGisJRevisionsController(JTable table, JButton btnMore, JButton btnFilter, JLabel lblMessages) {
        this.table = table;
        this.btnMore = btnMore;
        this.btnFilter = btnFilter;
        this.lblMessages = lblMessages;
        this.workspace = null;
        this.processing = false;
        this.changeListener = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.enabled = true;
        this.initComponents();
    }

    public void setWorkspace(VCSGisWorkspace workspace) {
        if (workspace == this.workspace) {
            return;
        }
        this.workspace = workspace;
        this.entity = null;
        if (this.entity != null && this.workspace != null) {
            this.doUpdateTable();
        } else {
            this.clearTable();
        }
    }

    public VCSGisWorkspace getWorkspace() {
        return this.workspace;
    }

    public void setEntity(VCSGisEntity entity) {
        if (entity != null && this.entity != null && entity.getEntityCode().equals(this.entity.getEntityCode())) {
            return;
        }
        this.entity = entity;
        if (this.entity != null && this.workspace != null) {
            this.doUpdateTable();
        } else {
            this.clearTable();
        }
    }

    public VCSGisEntity getEntity() {
        return this.entity;
    }

    private void initComponents() {
        this.btnFilter.setIcon(VCSGisSwingManagerImpl.loadImage("vcsgis-revisions-filter"));
        this.btnFilter.addActionListener(e -> this.doFilter());
        this.btnMore.setIcon(VCSGisSwingManagerImpl.loadImage("vcsgis-revisions-more"));
        this.btnMore.addActionListener(e -> this.doMore());
        this.clearTable();
        this.updateComponentsState();
    }

    private void doFilter() {
        VCSGisWorkspace ws = this.getWorkspace();
        if (ws == null) {
            return;
        }
        WindowManager_v2 winmanaser = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        FeatureStore store = ws.getRevisionsStore();
        JExpressionBuilder builder = dataSwingManager.createJExpressionBuilder(store);
        Dialog dialog = winmanaser.createDialog(builder.asJComponent(), "Revisions", null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                Expression exp = builder.getExpression();
                this.filter = ExpressionUtils.isEmpty((Expression)exp) ? null : exp.getPhrase();
                this.doUpdateTable();
            }
            DisposeUtils.dispose((Disposable)store);
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    private void doMore() {
        VCSGisWorkspace theWorkspace = this.workspace;
        VCSGisEntity theEntity = this.entity;
        if (theEntity == null || theWorkspace == null) {
            return;
        }
        Thread task = new Thread(() -> {
            try {
                this.setProcessing(true);
                this.updateComponentsState();
                theWorkspace.history(theEntity.getEntityName(), "ALL", -1, null);
                GetItemWithSize64 revisions = theWorkspace.getRevisions(theEntity.getEntityName(), "ALL", this.filter);
                this.doUpdateTable((GetItemWithSize64<VCSGisRevision>)revisions);
                DisposeUtils.disposeQuietly((Object)revisions);
            }
            finally {
                this.setProcessing(false);
                this.updateComponentsState();
            }
        }, "VCSGisRevisionsUpdateTable");
        this.clearTable();
        this.setProcessing(true);
        this.updateComponentsState();
        task.start();
    }

    private void setProcessing(boolean processing) {
        this.processing = processing;
        this.changeListener.fireEvent(new ChangeEvent(this));
    }

    public boolean isProcessing() {
        return this.processing;
    }

    private void clearTable() {
        this.setTableModel(null);
    }

    private void doUpdateTable() {
        VCSGisWorkspace theWorkspace = this.workspace;
        VCSGisEntity theEntity = this.entity;
        if (theEntity == null || theWorkspace == null) {
            return;
        }
        Thread task = new Thread(() -> {
            try {
                this.setProcessing(true);
                this.updateComponentsState();
                GetItemWithSize64 revisions = theWorkspace.getRevisions(theEntity.getEntityName(), "ALL", this.filter);
                String revcode = null;
                if (revisions.size64() >= 1L) {
                    try {
                        revcode = ((VCSGisRevision)revisions.get64(revisions.size64() - 1L)).getRevisionCode();
                    }
                    catch (Exception ex) {
                        revcode = null;
                    }
                }
                if (revisions.size64() == 0L || !StringUtils.equals(revcode, (String)theEntity.getRepositoryRevisionCode())) {
                    LocalDateTime end = LocalDateTime.now().plusDays(1L);
                    LocalDateTime start = end.minusDays(30L);
                    theWorkspace.history(theEntity.getEntityName(), "ALL", DataTypeUtils.toTimestamp((ChronoLocalDateTime)start), DataTypeUtils.toTimestamp((ChronoLocalDateTime)end), -1, null);
                    revisions = theWorkspace.getRevisions(theEntity.getEntityName(), "ALL", this.filter);
                }
                this.doUpdateTable((GetItemWithSize64<VCSGisRevision>)revisions);
            }
            finally {
                this.setProcessing(false);
                this.updateComponentsState();
            }
        }, "VCSGisRevisionsUpdateTable");
        this.clearTable();
        this.setProcessing(true);
        this.updateComponentsState();
        task.start();
    }

    private void doUpdateTable(GetItemWithSize64<VCSGisRevision> revisions) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doUpdateTable(revisions))) {
            return;
        }
        this.setTableModel(revisions);
    }

    private void setTableModel(GetItemWithSize64<VCSGisRevision> revisions) {
        DisposeUtils.disposeQuietly((Object)this.table.getModel());
        this.table.setModel(new RevisionsTableModel(this.workspace, revisions));
    }

    private void updateComponentsState() {
        boolean theEnabled = this.enabled && this.workspace != null && this.entity != null;
        theEnabled = theEnabled && !this.processing;
        this.table.setEnabled(theEnabled);
        this.btnFilter.setEnabled(theEnabled);
        this.btnMore.setEnabled(theEnabled);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListener.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListener.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListener.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListener.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListener.hasChangeListeners();
    }

    public static void selfRegister() {
        ToolsSwingUtils.registerIcons(VCSGisSwingImplLibrary.class, (String)"/org/gvsig/vcsgis/swing/impl/images", (String)"VCSGis", (String[][])new String[][]{{"vcsgis", "vcsgis-revisions-filter", "vcsgis-revisions"}, {"vcsgis", "vcsgis-revisions-more", "vcsgis-revisions"}});
        ToolsSwingUtils.registerSubgroupIconScreenshot(VCSGisSwingImplLibrary.class, (String)"vcsgis", (String)"vcsgis-revisions", (String)"/org/gvsig/vcsgis/swing/impl/screenshots/vcsgis-revisions.png");
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateComponentsState();
    }

    VCSGisRevision getSelectedRevision() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        RevisionsTableModel model = (RevisionsTableModel)this.table.getModel();
        return model.getSelectedRevision(row);
    }

    public void dispose() {
        DisposeUtils.disposeQuietly((Object)this.table.getModel());
    }
}

