/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.revisions;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.VCSGisJRevisions;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.revisions.VCSGisJRevisionsController;
import org.gvsig.vcsgis.swing.impl.revisions.VCSGisJRevisionsView;

public class VCSGisJRevisionsImpl
extends VCSGisJRevisionsView
implements VCSGisJRevisions {
    private boolean processing = false;
    private TaskStatusController taskStatusController;
    private PickerController<VCSGisWorkspace> workspacePicker;
    private VCSGisJRevisionsController revisionsController;
    private VCSGisEntitySelectorController entitySelector;

    public VCSGisJRevisionsImpl() {
        this.initComponents();
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                VCSGisJRevisionsImpl.this.dispose();
            }
        });
        VCSGisSwingManager vcsSwingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        this.taskStatusController = taskStatusManager.createTaskStatusController(null, this.lblMessages, null);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind(ToolsLocator.getTaskStatusManager());
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.workspacePicker = vcsSwingManager.createWorkspacePickerController(this.cboWorkspace, this.btnWorkspace);
        this.workspacePicker.addChangeListener(e -> {
            VCSGisWorkspace workspace = (VCSGisWorkspace)this.workspacePicker.get();
            this.entitySelector.setWorkspace(workspace);
            this.revisionsController.setEntity(null);
            this.revisionsController.setWorkspace(workspace);
        });
        this.entitySelector = vcsSwingManager.createEntitySelectorController(this.cboTables);
        this.entitySelector.setFilter(VCSGisEntitySelectorController.ALL_ENTITIES);
        this.entitySelector.setViewFilter(VCSGisEntitySelectorController.ALL_ENTITIES);
        this.entitySelector.setChecksEnabled(false);
        this.entitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 2: {
                    this.updateStateComponents();
                    break;
                }
                case 0: 
                case 1: {
                    this.revisionsController.setEntity(this.getSelectedTable());
                }
            }
        });
        this.entitySelector.addChangeListener(e -> this.updateStateComponents());
        this.revisionsController = new VCSGisJRevisionsController(this.tblRevisions, this.btnMore, this.btnFilter, this.lblMessages);
        this.revisionsController.addChangeListener(e -> {
            this.processing = this.revisionsController.isProcessing();
            this.updateStateComponents();
        });
        this.translate();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)15, (int)70);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((AbstractButton)this.btnMore);
        toolsSwingManager.translate((AbstractButton)this.btnFilter);
        toolsSwingManager.translate(this.lblTable);
        toolsSwingManager.translate(this.lblWorkspace);
    }

    private void updateStateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.updateStateComponents())) {
            return;
        }
        VCSGisWorkspace ws = (VCSGisWorkspace)this.workspacePicker.get();
        VCSGisEntity table = this.getSelectedTable();
        this.workspacePicker.setEnabled(!this.processing);
        this.entitySelector.setEnabled(!this.processing && ws != null);
        this.revisionsController.setEnabled(!this.processing && table != null);
    }

    private VCSGisEntity getSelectedTable() {
        VCSGisWorkspace ws = (VCSGisWorkspace)this.workspacePicker.get();
        if (ws == null) {
            return null;
        }
        return this.entitySelector.getSelectedEntity();
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    public static void selfRegister() {
        String[][] iconsInfo = new String[][]{{"VCSGis", "vcsgis", "vcsgis-revisions"}, {"VCSGis", "vcsgis", "vcsgis-revisions-more"}, {"VCSGis", "vcsgis", "vcsgis-revisions-filter"}};
        VCSGisSwingManagerImpl.registerIcons(iconsInfo);
    }

    private void message(String msg) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.message(msg))) {
            return;
        }
        this.getTaskStatusController().message(msg);
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblMessages.setVisible(visible);
    }

    public TaskStatusController getTaskStatusController() {
        return this.taskStatusController;
    }

    public VCSGisWorkspace getWorkspace() {
        VCSGisWorkspace ws = (VCSGisWorkspace)this.workspacePicker.get();
        return ws;
    }

    public void setDialog(Dialog dialog) {
    }

    public void dispose() {
        DisposeUtils.disposeQuietly((Disposable)this.revisionsController);
    }
}

