/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.setWorkingCopyOffline;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.BooleanUtils;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJSetWorkingCopyOffline;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.setWorkingCopyOffline.VCSGisJSetWorkingCopyOfflineView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJSetWorkingCopyOfflineImpl
extends VCSGisJSetWorkingCopyOfflineView
implements Component,
VCSGisJSetWorkingCopyOffline {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJSetWorkingCopyOfflineImpl.class);
    private Dialog dialog;
    private PickerController<VCSGisWorkspace> workspacePicker;

    public VCSGisJSetWorkingCopyOfflineImpl() {
        this.initComponents();
    }

    public VCSGisJSetWorkingCopyOfflineImpl(VCSGisWorkspace workspace, String model) {
        this();
        SwingUtilities.invokeLater(() -> this.workspacePicker.set((Object)workspace));
    }

    private void initComponents() {
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        this.translate();
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspaces, this.btnInitWorkspace);
        this.workspacePicker.addChangeListener(e -> {
            this.doUpdateComponents();
            this.doChangeWorkspace();
        });
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)3, (int)70);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateComponents();
    }

    private void doChangeWorkspace() {
        VCSGisWorkspace ws = this.getWorkspace();
        this.chkOffline.setSelected(ws.isOffline());
    }

    public VCSGisWorkspace getWorkspace() {
        return (VCSGisWorkspace)this.workspacePicker.get();
    }

    private void doUpdateComponents() {
        boolean canConnect;
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        VCSGisWorkspace workspace = this.getWorkspace();
        boolean bl = canConnect = workspace != null;
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, canConnect);
        }
    }

    public void setOffline() {
        VCSGisWorkspace workspace = this.getWorkspace();
        boolean offline = this.chkOffline.isSelected();
        workspace.setOffline(offline);
        workspace.setConfigValue("OFFLINE", BooleanUtils.toStringTrueFalse((boolean)offline));
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspace);
        swingManager.translate(this.lblOffline);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    public boolean isProcessing() {
        return false;
    }
}

