/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.storeactions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.future.FutureUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJLog;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisLogAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisLogAction.class);
    private final DALActionFactory.DALActionContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSGisLogAction(DALActionFactory.DALActionContext context) {
        VCSGisWorkspace ws = null;
        try {
            this.context = context;
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("ActionCommandKey", "VCSGisLog");
            this.putValue("ShortDescription", i18n.getTranslation("_Show_history"));
            this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getActive().get("vcsgis-revisions"));
            VCSGisManager vcsgismanager = VCSGisLocator.getVCSGisManager();
            if (context.getStore() instanceof FeatureStore) {
                FeatureStore store = (FeatureStore)context.getStore();
                ws = vcsgismanager.getWorkspace(store);
                if (ws == null) {
                    this.setEnabled(false);
                } else {
                    VCSGisEntity entity = ws.getEntity(store.getName());
                    if (entity == null) {
                        this.setEnabled(false);
                    }
                }
            }
        }
        finally {
            DisposeUtils.disposeQuietly(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        VCSGisWorkspace ws;
        block20: {
            block19: {
                block18: {
                    block17: {
                        ws = null;
                        try {
                            VCSGisManager vcsgismanager = VCSGisLocator.getVCSGisManager();
                            VCSGisSwingManager vcsgisswingmanager = VCSGisSwingLocator.getVCSGisSwingManager();
                            WindowManager windowManager = ToolsSwingLocator.getWindowManager();
                            int count = this.context.getSelectedsCount();
                            if (count != 1) {
                                return;
                            }
                            if (!(this.context.getStore() instanceof FeatureStore)) {
                                return;
                            }
                            FeatureStore store = (FeatureStore)this.context.getStore();
                            Feature f = this.context.getSelecteds().first();
                            if (f == null) {
                                return;
                            }
                            this.setEnabled(false);
                            ws = vcsgismanager.getWorkspace(store);
                            if (ws == null) {
                                DisposeUtils.disposeQuietly((Disposable)ws);
                                break block17;
                            }
                            VCSGisEntity entity = ws.getEntity(store.getName());
                            if (entity == null) {
                                DisposeUtils.disposeQuietly((Disposable)ws);
                                break block18;
                            }
                            String featureCode = f.getString(entity.getFeatureIdFieldName());
                            if (StringUtils.isBlank((CharSequence)featureCode)) {
                                DisposeUtils.disposeQuietly((Disposable)ws);
                                break block19;
                            }
                            VCSGisJLog panel = vcsgisswingmanager.createLogPanel();
                            panel.put(ws, entity, featureCode);
                            windowManager.showWindow(panel.asJComponent(), ToolsSwingUtils.makeTitle((String)"History", (String)store.getName(), (String)store.getLabel()), WindowManager.MODE.WINDOW);
                            DisposeUtils.disposeQuietly((Disposable)ws);
                            break block20;
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Can't show history", (Throwable)ex);
                            return;
                        }
                    }
                    this.setEnabled(true);
                    return;
                }
                this.setEnabled(true);
                return;
            }
            this.setEnabled(true);
            return;
        }
        this.setEnabled(true);
        return;
        finally {
            DisposeUtils.disposeQuietly(ws);
            this.setEnabled(true);
        }
    }

    public static class VCSGisLogActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "VCSGisLog";

        public VCSGisLogActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new VCSGisLogAction(context);
        }

        public boolean isApplicable(Object ... args) {
            if (!(args[0] instanceof DALActionFactory.DALActionContext)) {
                return false;
            }
            DALActionFactory.DALActionContext context = (DALActionFactory.DALActionContext)args[0];
            return StringUtils.equalsIgnoreCase((CharSequence)context.getName(), (CharSequence)"FormActionContext") || StringUtils.equalsIgnoreCase((CharSequence)context.getName(), (CharSequence)"FeatureStoreSearchPanel");
        }

        public static void selfRegister() {
            if (FutureUtils.use((String)"VCSGISLOG")) {
                DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
                dalSwingManager.registerStoreAction((DALActionFactory)new VCSGisLogActionFactory());
            }
        }
    }
}

