/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl.transparency;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.raster.api.RasterLayer;
import org.gvsig.fmap.mapcontext.raster.swing.impl.transparency.TransparencyPanelView;
import org.gvsig.fmap.mapcontext.raster.swing.transparency.TransparencyPanel;
import org.gvsig.raster.lib.legend.api.RasterLegend;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.api.Transparency;
import org.gvsig.raster.lib.legend.api.TransparencyRange;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransparencyPanelController
extends TransparencyPanelView
implements TransparencyPanel,
ActionListener,
ChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = -7509955533999332846L;
    private static final Logger LOG = LoggerFactory.getLogger(TransparencyPanelController.class);

    public TransparencyPanelController() {
        this.colorChooser.setPreviewPanel(new JPanel());
        this.initializeComponents();
        this.translate();
        this.invalidate();
    }

    private void initializeComponents() {
        this.initializeColorChooserPanel();
        this.chkNoDataTransparency.addActionListener(this);
        this.chkActivateOpacity.addActionListener(this);
        this.chkActivatePixelTransparency.addActionListener(this);
        this.sldOpacity.addChangeListener(this);
        this.spOpacity.addChangeListener(this);
        this.btnAdd.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.lstTransparencyRanges.getParent().setPreferredSize(new Dimension(210, this.lstTransparencyRanges.getParent().getHeight()));
        this.lstTransparencyRanges.setModel(new DefaultListModel());
        this.lstTransparencyRanges.addListSelectionListener(this);
    }

    private void initializeColorChooserPanel() {
        AbstractColorChooserPanel[] defaultPanels = ColorChooserComponentFactory.getDefaultChooserPanels();
        AbstractColorChooserPanel[] chooserPanelsCleaned = new AbstractColorChooserPanel[]{defaultPanels[3]};
        this.colorChooser.setChooserPanels(chooserPanelsCleaned);
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.chkNoDataTransparency.setText(i18nManager.getTranslation(this.chkNoDataTransparency.getText()));
        this.chkNoDataTransparency.setToolTipText(i18nManager.getTranslation(this.chkNoDataTransparency.getToolTipText()));
        this.lblOpacity.setText(i18nManager.getTranslation(this.lblOpacity.getText()));
        this.chkActivateOpacity.setText(i18nManager.getTranslation(this.chkActivateOpacity.getText()));
        this.chkActivateOpacity.setToolTipText(i18nManager.getTranslation(this.chkActivateOpacity.getToolTipText()));
        this.lblPixelTransparency.setText(i18nManager.getTranslation(this.lblPixelTransparency.getText()));
        this.chkActivatePixelTransparency.setText(i18nManager.getTranslation(this.chkActivatePixelTransparency.getText()));
        this.chkActivatePixelTransparency.setToolTipText(i18nManager.getTranslation(this.chkActivatePixelTransparency.getToolTipText()));
        this.btnAdd.setText(i18nManager.getTranslation(this.btnAdd.getText()));
        this.btnAdd.setToolTipText(i18nManager.getTranslation(this.btnAdd.getToolTipText()));
        this.btnRemove.setText(i18nManager.getTranslation(this.btnRemove.getText()));
        this.btnRemove.setToolTipText(i18nManager.getTranslation(this.btnRemove.getToolTipText()));
        this.btnExternalTool0.setText(i18nManager.getTranslation(this.btnExternalTool0.getText()));
        this.btnExternalTool0.setToolTipText(i18nManager.getTranslation(this.btnExternalTool0.getToolTipText()));
        this.btnExternalTool1.setText(i18nManager.getTranslation(this.btnExternalTool1.getText()));
        this.btnExternalTool1.setToolTipText(i18nManager.getTranslation(this.btnExternalTool1.getToolTipText()));
        this.btnExternalTool2.setText(i18nManager.getTranslation(this.btnExternalTool2.getText()));
        this.btnExternalTool2.setToolTipText(i18nManager.getTranslation(this.btnExternalTool2.getToolTipText()));
        this.rbtnAnd.setText(i18nManager.getTranslation(this.rbtnAnd.getText()));
        this.rbtnAnd.setToolTipText(i18nManager.getTranslation(this.rbtnAnd.getToolTipText()));
        this.rbtnOr.setText(i18nManager.getTranslation(this.rbtnOr.getText()));
        this.rbtnOr.setToolTipText(i18nManager.getTranslation(this.rbtnOr.getToolTipText()));
        this.chkRed.setText(i18nManager.getTranslation(this.chkRed.getText()));
        this.chkRed.setToolTipText(i18nManager.getTranslation(this.chkRed.getToolTipText()));
        this.chkGreen.setText(i18nManager.getTranslation(this.chkGreen.getText()));
        this.chkGreen.setToolTipText(i18nManager.getTranslation(this.chkGreen.getToolTipText()));
        this.chkBlue.setText(i18nManager.getTranslation(this.chkBlue.getText()));
        this.chkBlue.setToolTipText(i18nManager.getTranslation(this.chkBlue.getToolTipText()));
        this.chkAlpha.setText(i18nManager.getTranslation(this.chkAlpha.getText()));
        this.chkAlpha.setToolTipText(i18nManager.getTranslation(this.chkAlpha.getToolTipText()));
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }

    public void set(FLayer layer) {
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        RasterLayer rasterLayer = (RasterLayer)layer;
        RasterLegend legend = rasterLayer.getLegend();
        if (legend == null) {
            legend = legendManager.createLegend();
        }
        if (legend.areTransparentNoData()) {
            this.chkNoDataTransparency.doClick();
        }
        int alpha = 255;
        Transparency transparency = legend.getTransparency();
        if (transparency != null) {
            this.chkActivateOpacity.doClick();
            alpha = transparency.getAlpha();
            if (transparency.getTransparencyRanges() != null && transparency.getTransparencyRanges().size() > 0) {
                this.chkActivatePixelTransparency.doClick();
                for (TransparencyRange range : transparency.getTransparencyRanges()) {
                    ((DefaultListModel)this.lstTransparencyRanges.getModel()).addElement(range);
                }
            }
        }
        this.sldOpacity.setValue(alpha);
        this.spOpacity.setValue(alpha);
    }

    public boolean fetch(FLayer layer) {
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        RasterLegend legend = ((RasterLayer)layer).getLegend();
        if (legend == null) {
            legend = legendManager.createLegend();
        }
        legend.setTransparentNoData(this.chkNoDataTransparency.isSelected());
        Transparency transparency = legendManager.createTransparency();
        if (this.chkActivateOpacity.isSelected()) {
            transparency.setValue(((Integer)this.spOpacity.getValue()).intValue());
        }
        if (this.chkActivatePixelTransparency.isSelected()) {
            transparency.setTransparencyRanges(this.getTransparencyRanges());
        }
        legend.setTransparency(transparency);
        layer.getMapContext().invalidate();
        return true;
    }

    private List<TransparencyRange> getTransparencyRanges() {
        ArrayList<TransparencyRange> result = new ArrayList<TransparencyRange>();
        DefaultListModel model = (DefaultListModel)this.lstTransparencyRanges.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            result.add((TransparencyRange)model.get(i));
        }
        return result;
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean selected;
        if (e.getSource() == this.chkActivateOpacity) {
            selected = this.chkActivateOpacity.isSelected();
            this.sldOpacity.setEnabled(selected);
            this.spOpacity.setEnabled(selected);
        }
        if (e.getSource() == this.chkActivatePixelTransparency) {
            selected = this.chkActivatePixelTransparency.isSelected();
            this.colorChooser.setEnabled(selected);
            this.btnAdd.setEnabled(selected);
            this.btnRemove.setEnabled(selected);
            this.rbtnAnd.setEnabled(selected);
            this.rbtnOr.setEnabled(selected);
            this.chkRed.setEnabled(selected);
            this.chkGreen.setEnabled(selected);
            this.chkBlue.setEnabled(selected);
            this.chkAlpha.setEnabled(selected);
            this.lstTransparencyRanges.setEnabled(selected);
        }
        DefaultListModel transparencyListModel = (DefaultListModel)this.lstTransparencyRanges.getModel();
        if (e.getSource() == this.btnAdd) {
            int[] values;
            Color color = this.colorChooser.getColor();
            RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
            TransparencyRange range = legendManager.createTransparencyRange();
            if (this.chkRed.isSelected()) {
                values = new int[]{color.getRed(), color.getRed()};
                range.setRed(values);
            }
            if (this.chkGreen.isSelected()) {
                values = new int[]{color.getGreen(), color.getGreen()};
                range.setGreen(values);
            }
            if (this.chkBlue.isSelected()) {
                values = new int[]{color.getBlue(), color.getBlue()};
                range.setBlue(values);
            }
            range.setAnd(this.rbtnAnd.isSelected());
            if (this.chkAlpha.isSelected()) {
                range.setAlpha(color.getAlpha());
            } else {
                range.setAlpha(0);
            }
            int index = this.getIndex(range);
            if (index < 0) {
                transparencyListModel.addElement(range);
                this.lstTransparencyRanges.setSelectedIndex(transparencyListModel.getSize() - 1);
            } else {
                ((DefaultListModel)this.lstTransparencyRanges.getModel()).setElementAt(range, index);
                this.lstTransparencyRanges.setSelectedIndex(index);
            }
        }
        if (e.getSource() == this.btnRemove) {
            int selectedIndex = this.lstTransparencyRanges.getSelectedIndex();
            transparencyListModel.removeElementAt(selectedIndex);
        }
    }

    private int getIndex(TransparencyRange range) {
        for (int i = 0; i < this.lstTransparencyRanges.getModel().getSize(); ++i) {
            TransparencyRange element = (TransparencyRange)this.lstTransparencyRanges.getModel().getElementAt(i);
            if (!element.isSameRange(range)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Integer value;
        if (e.getSource() == this.sldOpacity && (value = (Integer)this.spOpacity.getValue()).intValue() != this.sldOpacity.getValue()) {
            this.spOpacity.setValue(this.sldOpacity.getValue());
        }
        if (e.getSource() == this.spOpacity) {
            value = (Integer)this.spOpacity.getValue();
            if (value <= 0) {
                this.spOpacity.setValue(0);
            }
            if (value >= 255) {
                this.spOpacity.setValue(255);
            }
            if (value.intValue() != this.sldOpacity.getValue()) {
                this.sldOpacity.setValue(value);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.lstTransparencyRanges) {
            int selectedIndex = this.lstTransparencyRanges.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.btnRemove.setEnabled(true);
                TransparencyRange range = (TransparencyRange)this.lstTransparencyRanges.getModel().getElementAt(selectedIndex);
                this.setRange(range);
            } else {
                this.btnRemove.setEnabled(false);
            }
        }
    }

    private void setRange(TransparencyRange range) {
        int alpha = range.getAlpha();
        int[] redValues = range.getRed();
        int red = 255;
        if (redValues[0] >= 0) {
            red = redValues[0];
            this.chkRed.setSelected(true);
        } else {
            this.chkRed.setSelected(false);
        }
        int[] greenValues = range.getGreen();
        int green = 255;
        if (greenValues[0] >= 0) {
            green = greenValues[0];
            this.chkGreen.setSelected(true);
        } else {
            this.chkGreen.setSelected(false);
        }
        int[] blueValues = range.getBlue();
        int blue = 255;
        if (blueValues[0] >= 0) {
            blue = blueValues[0];
            this.chkBlue.setSelected(true);
        } else {
            this.chkBlue.setSelected(false);
        }
        if (alpha >= 0) {
            this.setColor(new Color(red, green, blue, alpha));
            this.chkAlpha.setSelected(true);
        } else {
            this.setColor(new Color(red, green, blue));
            this.chkAlpha.setSelected(false);
        }
        if (range.isAnd()) {
            this.rbtnAnd.setSelected(true);
            this.rbtnOr.setSelected(false);
        } else {
            this.rbtnAnd.setSelected(false);
            this.rbtnOr.setSelected(true);
        }
    }

    public void setColor(Color color) {
        this.colorChooser.setColor(color);
    }
}

