/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog;

import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.commons.httpclient.HttpConnection;
import org.gvsig.catalog.drivers.DiscoveryServiceCapabilities;
import org.gvsig.catalog.drivers.IDiscoveryServiceDriver;
import org.gvsig.catalog.exceptions.NotSupportedProtocolException;
import org.gvsig.catalog.exceptions.NotSupportedVersionException;
import org.gvsig.catalog.exceptions.ServerIsNotReadyException;
import org.gvsig.catalog.querys.DiscoveryServiceQuery;
import org.gvsig.catalog.ui.search.SearchAditionalPropertiesPanel;
import org.gvsig.catalog.utils.URIUtils;

public class DiscoveryServiceClient {
    private URI uri = null;
    private IDiscoveryServiceDriver driver;
    private DiscoveryServiceCapabilities capabilities;
    private String serverStatus = null;

    public DiscoveryServiceClient(String sUri, IDiscoveryServiceDriver driver) {
        this.setDriver(driver);
        if (driver == null) {
            this.serverStatus = "errorServerNotFound";
        } else {
            try {
                this.uri = URIUtils.createUri(sUri, driver.getDefaultSchema(), driver.getDefaultPort());
            }
            catch (URISyntaxException e) {
                this.serverStatus = "errorServerNotFound";
            }
        }
    }

    public DiscoveryServiceCapabilities getCapabilities() throws ServerIsNotReadyException {
        if (this.serverIsReady()) {
            try {
                if (this.getDriver().isProtocolSupported(this.getUri())) {
                    this.capabilities = this.getDriver().getCapabilities(this.getUri());
                    return this.capabilities;
                }
            }
            catch (NotSupportedProtocolException e) {
                this.capabilities = new DiscoveryServiceCapabilities();
                this.capabilities.setAvailable(false);
                this.capabilities.setServerMessage("notSupportedProtocol");
            }
            catch (NotSupportedVersionException e) {
                this.capabilities = new DiscoveryServiceCapabilities();
                this.capabilities.setAvailable(false);
                this.capabilities.setServerMessage("notSupportedVersion");
            }
        }
        return this.capabilities;
    }

    public boolean serverIsReady() throws ServerIsNotReadyException {
        Properties systemSettings = System.getProperties();
        Object isProxyEnabled = systemSettings.get("http.proxySet");
        if (isProxyEnabled == null || isProxyEnabled.equals("false")) {
            Socket sock;
            try {
                sock = new Socket(this.getUri().getHost(), this.getUri().getPort());
            }
            catch (UnknownHostException e) {
                throw new ServerIsNotReadyException(e);
            }
            catch (IOException e) {
                throw new ServerIsNotReadyException(e);
            }
            return sock != null;
        }
        Object host = systemSettings.get("http.proxyHost");
        Object port = systemSettings.get("http.proxyPort");
        Object user = systemSettings.get("http.proxyUserName");
        Object password = systemSettings.get("http.proxyPassword");
        if (host != null && port != null) {
            int iPort = 80;
            try {
                iPort = Integer.parseInt((String)port);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HttpConnection connection = new HttpConnection(this.getUri().getHost(), this.getUri().getPort());
            connection.setProxyHost((String)host);
            connection.setProxyPort(iPort);
            Authenticator.setDefault(new SimpleAuthenticator(user, password));
            try {
                connection.open();
                connection.close();
            }
            catch (IOException e) {
                throw new ServerIsNotReadyException(e);
            }
        }
        return true;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getSUri() {
        return this.uri.toString();
    }

    protected IDiscoveryServiceDriver getDriver() {
        return this.driver;
    }

    protected void setDriver(IDiscoveryServiceDriver driver) {
        this.driver = driver;
    }

    public String getProtocol() {
        return this.driver.getServiceName();
    }

    public SearchAditionalPropertiesPanel getAditionalSearchPanel() {
        return this.driver.getAditionalSearchPanel();
    }

    public DiscoveryServiceQuery createQuery() {
        return this.driver.createQuery();
    }

    private class SimpleAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public SimpleAuthenticator(Object username, Object password) {
            if (username != null) {
                this.username = (String)username;
            }
            if (password != null) {
                this.password = (String)password;
            }
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }
}

