/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.csw.drivers;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.gvsig.catalog.csw.drivers.CSWCapabilities;
import org.gvsig.catalog.csw.drivers.CSWException;
import org.gvsig.catalog.csw.drivers.profiles.CSWAbstractProfile;
import org.gvsig.catalog.csw.messages.CSWAbstractMessages;
import org.gvsig.catalog.csw.messages.CSWMessagesFactory;
import org.gvsig.catalog.csw.parsers.CSWCapabilitiesParser;
import org.gvsig.catalog.csw.parsers.CSWDescribeRecordParser;
import org.gvsig.catalog.drivers.AbstractCatalogServiceDriver;
import org.gvsig.catalog.drivers.DiscoveryServiceCapabilities;
import org.gvsig.catalog.drivers.GetRecordsReply;
import org.gvsig.catalog.exceptions.NotSupportedVersionException;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.protocols.HTTPGetProtocol;
import org.gvsig.catalog.protocols.HTTPPostProtocol;
import org.gvsig.catalog.querys.CatalogQuery;

public abstract class CSWCatalogServiceDriver
extends AbstractCatalogServiceDriver {
    protected CSWCapabilities capabilities = null;
    protected CSWAbstractProfile profile = null;
    private static Hashtable servers = new Hashtable();

    @Override
    public DiscoveryServiceCapabilities getCapabilities(URI uri) throws NotSupportedVersionException {
        CSWException exception;
        URL url = null;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            this.setServerAnswerReady("errorServerNotFound");
            return null;
        }
        Collection nodes = new ArrayList();
        nodes = new HTTPGetProtocol().doQuery(url, CSWAbstractMessages.getHTTPGETCapabilities(), 0);
        CSWCapabilitiesParser parser = new CSWCapabilitiesParser(url, this);
        this.capabilities = parser.parse((XMLNode)nodes.toArray()[0]);
        if (!this.capabilities.isAvailable() && this.capabilities.getException() != null && (exception = this.capabilities.getException()).getCode().equals("8001") && exception.getSubcode().equals("5002")) {
            nodes = new HTTPGetProtocol().doQuery(url, CSWAbstractMessages.getHTTPGETCapabilitiesLower(), 0);
            this.capabilities = parser.parse((XMLNode)nodes.toArray()[0]);
        }
        this.setMessages(uri, url);
        return this.capabilities;
    }

    @Override
    public GetRecordsReply getRecords(URI uri, CatalogQuery query, int firstRecord) {
        URL url = this.capabilities.getOperations().getGetRecordsURLPost();
        this.setQuery(query);
        Collection nodes = new ArrayList();
        try {
            System.out.println(this.getMessages(uri).getHTTPPostGetRecordsMessage(this.capabilities, this.getQuery(), this.getServerData(), firstRecord));
            nodes = new HTTPPostProtocol().doQuery(url, this.getMessages(uri).getHTTPPostGetRecordsMessage(this.capabilities, this.getQuery(), this.getServerData(), firstRecord), firstRecord);
        }
        catch (NotSupportedVersionException notSupportedVersionException) {
            // empty catch block
        }
        if (nodes == null) {
            return null;
        }
        Object[] auxNodes = nodes.toArray();
        if (auxNodes.length == 0) {
            return null;
        }
        XMLNode root = (XMLNode)auxNodes[0];
        int numberOfRecords = this.getNumberOfRecords(root);
        if (numberOfRecords == -1) {
            return null;
        }
        this.getRecordsReply().setNumRecords(numberOfRecords);
        XMLNode[] results = this.retrieveResults(root);
        for (int i = 0; i < results.length; ++i) {
            this.getRecordsReply().addRecord(uri, results[i]);
        }
        return this.getRecordsReply();
    }

    protected abstract XMLNode[] retrieveResults(XMLNode var1);

    protected int getNumberOfRecords(XMLNode node) {
        int numberOfRecords = this.getNumberOfRecords(node, "csw:SearchResults", "numberOfRecordsMatched");
        if (numberOfRecords == -1) {
            numberOfRecords = this.getNumberOfRecords(node, "SearchResults", "numberOfRecordsMatched");
        }
        return numberOfRecords;
    }

    @Override
    public int getDefaultPort() {
        return 80;
    }

    @Override
    public String getDefaultSchema() {
        return "http";
    }

    @Override
    public boolean isProtocolSupported(URI uri) {
        return true;
    }

    private CSWAbstractMessages getMessages(URI uri) throws NotSupportedVersionException {
        if (servers.containsKey(uri)) {
            return (CSWAbstractMessages)servers.get(uri);
        }
        CSWAbstractMessages messages = CSWMessagesFactory.getMessages(this.capabilities.getVersion(), (CSWAbstractProfile)this.getProfile());
        servers.put(uri, messages);
        return messages;
    }

    private void setMessages(URI uri, URL url) throws NotSupportedVersionException {
        Collection nodes = new ArrayList();
        nodes = new HTTPGetProtocol().doQuery(url, CSWAbstractMessages.getHTTPGETDescribeRecord(this.capabilities.getVersion()), 0);
        CSWDescribeRecordParser parser = new CSWDescribeRecordParser(url, this);
        parser.parse((XMLNode)nodes.toArray()[0]);
    }
}

