/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.csw.messages;

import org.apache.commons.httpclient.NameValuePair;
import org.gvsig.catalog.csw.drivers.CSWCapabilities;
import org.gvsig.catalog.csw.drivers.profiles.CSWAbstractProfile;
import org.gvsig.catalog.languages.FilterEncoding;
import org.gvsig.catalog.querys.CatalogQuery;
import org.gvsig.catalog.querys.Search;
import org.gvsig.catalog.utils.Strings;
import org.gvsig.i18n.Messages;
import org.gvsig.utils.swing.jcomboServer.ServerData;

public abstract class CSWAbstractMessages {
    protected CSWCapabilities capabilities = null;
    protected CatalogQuery query = null;
    protected CSWAbstractProfile profile = null;

    public CSWAbstractMessages(CSWAbstractProfile profile) {
        this.profile = profile;
    }

    public static NameValuePair[] getHTTPGETCapabilities() {
        NameValuePair nvp1 = new NameValuePair("request", "GetCapabilities");
        NameValuePair nvp2 = new NameValuePair("service", "CSW");
        NameValuePair nvp3 = new NameValuePair("acceptFormats", "text/xml");
        return new NameValuePair[]{nvp1, nvp2, nvp3};
    }

    public static NameValuePair[] getHTTPGETCapabilitiesLower() {
        NameValuePair nvp1 = new NameValuePair("request", "getCapabilities");
        NameValuePair nvp2 = new NameValuePair("service", "CSW");
        NameValuePair nvp3 = new NameValuePair("acceptFormats", "text/xml");
        return new NameValuePair[]{nvp1, nvp2, nvp3};
    }

    public static NameValuePair[] getHTTPGETDescribeRecord(String version) {
        NameValuePair nvp1 = new NameValuePair("request", "DescribeRecord");
        NameValuePair nvp2 = new NameValuePair("service", "CSW");
        NameValuePair nvp3 = new NameValuePair("version", version);
        return new NameValuePair[]{nvp1, nvp2, nvp3};
    }

    public String getHTTPPostGetRecordsMessage(CSWCapabilities capabilities, CatalogQuery query, ServerData serverData, int firstRecord) {
        this.capabilities = capabilities;
        this.query = query;
        this.profile.setServerData(serverData);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.createGetRecordsHeader(firstRecord));
        return buffer.toString();
    }

    protected String createGetRecordsHeader(int firstRecord) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<csw:GetRecords");
        buffer.append(" service=\"CSW\" ");
        buffer.append("version=\"" + this.capabilities.getVersion() + "\" ");
        buffer.append("xmlns=\"http://www.opengis.net/cat/csw\" ");
        buffer.append("xmlns:csw=\"http://www.opengis.net/cat/csw\" ");
        buffer.append("xmlns:ogc=\"http://www.opengis.net/ogc\" ");
        buffer.append("xmlns:gml=\"http://www.opengis.net/gml\" ");
        buffer.append("startPosition='" + firstRecord + "' ");
        buffer.append("maxRecords='10' ");
        if (this.capabilities.getOutputFormat() != null) {
            buffer.append("outputFormat=\"" + this.capabilities.getOutputFormat() + "\" ");
        }
        if (this.getOutputSchema(this.capabilities.getOutputSchema()) != null) {
            buffer.append("outputSchema=\"" + this.getOutputSchema(this.capabilities.getOutputSchema()) + "\" ");
        } else {
            buffer.append("outputSchema=\"csw:IsoRecord\" ");
        }
        buffer.append("resultType=\"" + this.getResultType(this.capabilities.getResultType()) + "\">");
        buffer.append(this.createGetRecordsQuery());
        buffer.append("</csw:GetRecords>");
        return buffer.toString();
    }

    protected String getResultType(String[] resultType) {
        if (resultType == null) {
            return "results";
        }
        for (int i = 0; i < resultType.length; ++i) {
        }
        return resultType[0];
    }

    protected String getOutputSchema(String[] outputSchemas) {
        if (outputSchemas == null) {
            return null;
        }
        return outputSchemas[0];
    }

    protected String createGetRecordsQuery() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<csw:Query ");
        if (this.capabilities.getTypeNames() != null) {
            buffer.append("typeNames=\"" + Strings.getBlankSeparated(this.capabilities.getTypeNames()) + "\"");
        }
        buffer.append(">");
        buffer.append(this.getElementSetNameLabel(this.query.getService()));
        buffer.append(this.createGetRecordsConstraint());
        buffer.append("</csw:Query>");
        return buffer.toString();
    }

    protected String getElementSetNameLabel(Search searchType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<csw:ElementSetName>");
        buffer.append("full");
        buffer.append("</csw:ElementSetName>");
        if (this.profile.getElementName() != null) {
            buffer.append("<csw:ElementName>");
            buffer.append(this.profile.getElementName());
            buffer.append("</csw:ElementName>");
        }
        return buffer.toString();
    }

    protected String createGetRecordsConstraint() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<csw:Constraint");
        buffer.append(" version='" + this.getContraintVersion() + "'>");
        buffer.append(this.createFilterEncoding());
        buffer.append("</csw:Constraint>");
        return buffer.toString();
    }

    protected abstract String getContraintVersion();

    protected FilterEncoding getFilterEncoding() {
        return new FilterEncoding();
    }

    protected String createFilterEncoding() {
        FilterEncoding filter = this.getFilterEncoding();
        if (this.query.getTitle() != null) {
            filter.addClauses(this.profile.getTitle(), this.query.getTitle(), this.query.getTitleFilter(), "PropertyIsLike", "Literal", "And");
        }
        if (this.query.isMinimized()) {
            if (this.query.getAbstract() != null) {
                filter.addClauses(this.profile.getAbstract(), this.query.getAbstract(), "Y", "PropertyIsLike", "Literal", "Or");
            }
        } else {
            if (this.query.getAbstract() != null) {
                filter.addClauses(this.profile.getAbstract(), this.query.getAbstract(), "Y");
            }
            if (this.query.getThemeKey() != null) {
                filter.addClauses(this.profile.getKeywords(), this.query.getThemeKey(), "Y");
            }
            if (this.query.getTopic() != null && !this.query.getTopic().equals(Messages.getText((String)"cathegoryAny"))) {
                filter.addClauses(this.profile.getTopic(), this.profile.getTopicValue(this.query.getTopic()), "E");
            }
            if (this.query.getScale() != null) {
                filter.addClauses(this.profile.getScale(), this.query.getScale(), "E");
            }
            if (this.query.getProvider() != null) {
                filter.addClauses(this.profile.getProvider(), filter.getWildCard() + this.query.getProvider() + filter.getWildCard(), "E", "PropertyIsEqualTo", "Literal", "And");
            }
            if (this.query.getDateFrom() != null) {
                filter.addClauses(this.profile.getDateFrom(), this.query.getDateFrom(), "E", "PropertyIsGreaterThan", "Literal", "And");
            }
            if (this.query.getDateTo() != null) {
                filter.addClauses(this.profile.getDateTo(), this.query.getDateTo(), "E", "PropertyIsLessThan", "Literal", "And");
            }
        }
        if (this.query.getCoordenates() != null && this.query.isCoordinatesClicked()) {
            filter.addBoundingBox(this.query.getCoordenates(), this.profile.getCoordinates(), this.getCoordinatesOption(this.query.getCoordenatesFilter()));
        }
        return filter.toString();
    }

    protected boolean getCoordinatesOption(String coordinatesOption) {
        return !coordinatesOption.equals(Messages.getText((String)"coordinatesEqual")) && !coordinatesOption.equals(Messages.getText((String)"coordinatesContains")) && !coordinatesOption.equals(Messages.getText((String)"coordinatesEnclose"));
    }
}

