/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.csw.messages;

import org.gvsig.catalog.csw.drivers.profiles.CSWAbstractProfile;
import org.gvsig.catalog.csw.messages.CSWAbstractMessages;
import org.gvsig.catalog.languages.FilterEncoding;
import org.gvsig.catalog.utils.Strings;
import org.gvsig.i18n.Messages;

public class CSWMessages2_0_2
extends CSWAbstractMessages {
    public CSWMessages2_0_2(CSWAbstractProfile profile) {
        super(profile);
    }

    @Override
    protected String getContraintVersion() {
        return "1.1.0";
    }

    @Override
    protected String createGetRecordsHeader(int firstRecord) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<csw:GetRecords");
        buffer.append(" service=\"CSW\" ");
        buffer.append("version=\"" + this.capabilities.getVersion() + "\" ");
        buffer.append("xmlns=\"http://www.opengis.net/cat/csw/2.0.2\" ");
        buffer.append("xmlns:csw=\"http://www.opengis.net/cat/csw/2.0.2\" ");
        buffer.append("xmlns:ogc=\"http://www.opengis.net/ogc\" ");
        buffer.append("xmlns:gml=\"http://www.opengis.net/gml\" ");
        buffer.append("startPosition='" + firstRecord + "' ");
        buffer.append("maxRecords='10' ");
        if (this.capabilities.getOutputFormat() != null) {
            buffer.append("outputFormat=\"" + this.capabilities.getOutputFormat() + "\" ");
        }
        if (this.getOutputSchema(this.capabilities.getOutputSchema()) != null) {
            buffer.append("outputSchema=\"" + this.getOutputSchema(this.capabilities.getOutputSchema()) + "\" ");
        } else {
            buffer.append("outputSchema=\"csw:IsoRecord\" ");
        }
        buffer.append("resultType=\"" + this.getResultType(this.capabilities.getResultType()) + "\">");
        buffer.append(this.createGetRecordsQuery());
        buffer.append("</csw:GetRecords>");
        return buffer.toString();
    }

    @Override
    protected String createGetRecordsQuery() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<csw:Query ");
        if (this.capabilities.getTypeNames() != null && this.capabilities.getTypeNames().length > 0) {
            String[] auxTypeNames = new String[this.capabilities.getTypeNames().length - 1];
            for (int i = 1; i < this.capabilities.getTypeNames().length; ++i) {
                auxTypeNames[i - 1] = this.capabilities.getTypeNames()[i];
            }
            buffer.append("typeNames=\"" + Strings.getBlankSeparated(auxTypeNames) + "\"");
        }
        buffer.append(">");
        buffer.append(this.getElementSetNameLabel(this.query.getService()));
        buffer.append(this.createGetRecordsConstraint());
        buffer.append("</csw:Query>");
        return buffer.toString();
    }

    @Override
    protected String createFilterEncoding() {
        FilterEncoding filter = this.getFilterEncoding();
        if (this.query.getTitle() != null) {
            filter.addClauses(this.profile.getTitle(), this.query.getTitle(), this.query.getTitleFilter(), "PropertyIsLike", "Literal", "And");
        }
        if (this.query.isMinimized()) {
            if (this.query.getAbstract() != null) {
                filter.addClauses(this.profile.getAbstract(), this.query.getAbstract(), "Y", "PropertyIsLike", "Literal", "Or");
            }
        } else {
            if (this.query.getAbstract() != null) {
                filter.addClauses(this.profile.getAbstract(), this.query.getAbstract(), "Y");
            }
            if (this.query.getThemeKey() != null) {
                filter.addClauses(this.profile.getKeywords(), this.query.getThemeKey(), "Y");
            }
            if (this.query.getTopic() != null && !this.query.getTopic().equals(Messages.getText((String)"cathegoryAny"))) {
                filter.addClauses(this.profile.getTopic(), this.profile.getTopicValue(this.query.getTopic()), "E");
            }
            if (this.query.getScale() != null) {
                filter.addClauses(this.profile.getScale(), this.query.getScale(), "E");
            }
            if (this.query.getProvider() != null) {
                filter.addClauses(this.profile.getProvider(), filter.getWildCard() + this.query.getProvider() + filter.getWildCard(), "E", "PropertyIsEqualTo", "Literal", "And");
            }
            if (this.query.getDateFrom() != null) {
                filter.addClauses(this.profile.getDateFrom(), this.query.getDateFrom(), "E", "PropertyIsGreaterThan", "Literal", "And");
            }
            if (this.query.getDateTo() != null) {
                filter.addClauses(this.profile.getDateTo(), this.query.getDateTo(), "E", "PropertyIsLessThan", "Literal", "And");
            }
        }
        if (this.query.getCoordenates() != null && this.query.isCoordinatesClicked()) {
            filter.addBoundingBox(this.query.getCoordenates(), this.profile.getCoordinates(), this.getCoordinatesOption(this.query.getCoordenatesFilter()));
        }
        return filter.toString();
    }

    @Override
    protected String getResultType(String[] resultType) {
        return "results";
    }
}

