/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.languages;

import java.util.Iterator;
import org.gvsig.catalog.languages.AbstractGeneralLanguage;
import org.gvsig.catalog.querys.Coordinates;

public class FilterEncoding
extends AbstractGeneralLanguage {
    public static final String PROPERTY_IS_LIKE = "PropertyIsLike";
    public static final String PROPERTY_IS_LESS = "PropertyIsLess";
    public static final String PROPERTY_IS_GREATER = "PropertyIsGreater";
    public static final String PROPERTY_IS_GREATER_THAN = "PropertyIsGreaterThan";
    public static final String PROPERTY_IS_LESS_THAN = "PropertyIsLessThan";
    public static final String PROPERTY_IS_EQUALS_TO = "PropertyIsEqualTo";
    public static final String TYPE_LITERAL = "Literal";
    public static final String TYPE_TWO_PROPERTIES = "PropertyName";
    public static final String DEFAULT_PREFIX = "ogc";
    public static final String DEFAULT_WILDCARD = "*";
    public static final String DEFAULT_SINGLECHAR = "?";
    public static final String DEFAULT_ESCAPE = "\\";
    public static final String DEFAULT_NAMESPACE = "xmlns:ogc=\"http://www.opengis.net/ogc\"";
    private static final String FILTER = "Filter";
    private String prefix = null;
    private String wildCard = null;
    private String singleChar = null;
    private String escape = null;
    private String namespace = null;
    private String wildCardLabel = "wildCard";
    private String escapeCharLabel = "escapeChar";
    private String singleCharLabel = "singleChar";

    public FilterEncoding(String prefix, String wildCard, String singleChar, String escape) {
        this.prefix = prefix + ":";
        this.wildCard = wildCard;
        this.singleChar = singleChar;
        this.escape = escape;
    }

    public FilterEncoding() {
        this.prefix = "ogc:";
        this.wildCard = DEFAULT_WILDCARD;
        this.singleChar = DEFAULT_SINGLECHAR;
        this.escape = DEFAULT_ESCAPE;
    }

    public void addClauses(String propertyName, String propertyValue, String concordancia, String relationship, String type, String operator) {
        this.currentClause = null;
        Iterator values = this.parseValues(propertyValue, concordancia, relationship, this.wildCard);
        this.addClauses(propertyName, values, concordancia, relationship, type, operator);
    }

    public void addClauses(String propertyName, String propertyValue, String concordancia) {
        this.addClauses(propertyName, propertyValue, concordancia, PROPERTY_IS_LIKE, TYPE_LITERAL, "And");
    }

    public void addClauses(String propertyName, Iterator propertyValues, String concordancia, String relationship, String type, String operator) {
        while (propertyValues.hasNext()) {
            this.addTerm(propertyName, (String)propertyValues.next(), concordancia, relationship, type);
        }
        this.addCurrentClauseQuery(operator);
    }

    private void addTerm(String propertyName, String propertyValue, String concordancia, String relationship, String type) {
        StringBuffer term = new StringBuffer();
        term.append(this.propertyIsXXX(relationship, propertyName, propertyValue, type));
        if (this.currentClause == null) {
            this.currentClause = term.toString();
        } else {
            this.currentClause = this.currentClause + term.toString();
            this.currentClause = this.enterLabel(this.currentClause, this.getOperator(concordancia));
        }
    }

    protected void addCurrentClauseQuery(String operator) {
        if (this.currentClause != null) {
            if (this.currentQuery == null) {
                this.currentQuery = this.currentClause;
            } else {
                this.currentQuery = this.currentQuery + this.currentClause;
                this.currentQuery = this.enterLabel(this.currentQuery, operator);
            }
        }
    }

    @Override
    public String toString() {
        return this.enterLabel(this.currentQuery, FILTER);
    }

    private String enterLabel(String query, String label) {
        if (label.equals(FILTER) && this.namespace != null) {
            return "<" + this.prefix + label + " " + this.namespace + ">" + query + "</" + this.prefix + label + ">";
        }
        return "<" + this.prefix + label + ">" + query + "</" + this.prefix + label + ">";
    }

    private String propertyIsXXX(String relationship, String propertyName, String propertyValue, String type) {
        String cadena = "";
        cadena = "<" + this.prefix + relationship;
        if (relationship.equals(PROPERTY_IS_LIKE)) {
            if (this.wildCard != null) {
                cadena = cadena + " " + this.getWildCardLabel() + "=\"" + this.wildCard + "\"";
            }
            if (this.singleChar != null) {
                cadena = cadena + " " + this.getSingleCharLabel() + "=\"" + this.singleChar + "\"";
            }
            if (this.escape != null) {
                cadena = cadena + " " + this.getEscapeCharLabel() + "=\"" + this.escape + "\"";
            }
        }
        cadena = cadena + ">" + this.enterLabel(propertyName, TYPE_TWO_PROPERTIES);
        cadena = cadena + this.enterLabel(propertyValue, type);
        return cadena + "</" + this.prefix + relationship + ">";
    }

    public void addBoundingBox(Coordinates coordinates, String propertyName, boolean not) {
        String bbox = "<ogc:BBOX><ogc:PropertyName>" + propertyName + "</ogc:PropertyName>" + "<gml:Box>" + "<gml:coord>" + "<gml:X>" + coordinates.ulx + "</gml:X>" + "<gml:Y>" + coordinates.bry + "</gml:Y>" + "</gml:coord>" + "<gml:coord>" + "<gml:X>" + coordinates.brx + "</gml:X>" + "<gml:Y>" + coordinates.uly + "</gml:Y>" + "</gml:coord>" + "</gml:Box>" + "</ogc:BBOX>";
        if (not) {
            bbox = "<ogc:Not>" + bbox + "</ogc:Not>";
        }
        if (this.currentQuery == null) {
            this.currentQuery = bbox;
        } else {
            this.currentQuery = this.currentQuery + bbox;
            this.currentQuery = this.enterLabel(this.currentQuery, "And");
        }
    }

    public String getWildCard() {
        return this.wildCard;
    }

    public String getWildCardLabel() {
        return this.wildCardLabel;
    }

    public void setWildCardLabel(String wildCardLabel) {
        this.wildCardLabel = wildCardLabel;
    }

    public String getEscapeCharLabel() {
        return this.escapeCharLabel;
    }

    public void setEscapeCharLabel(String escapeCharLabel) {
        this.escapeCharLabel = escapeCharLabel;
    }

    public String getSingleCharLabel() {
        return this.singleCharLabel;
    }

    public void setSingleCharLabel(String singleCharLabel) {
        this.singleCharLabel = singleCharLabel;
    }
}

