/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.protocols;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.messaging.Message;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.util.xml.XMLParserUtils;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.protocols.IProtocols;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SOAPProtocol
implements IProtocols {
    @Override
    public Collection doQuery(URL url, Object object, int firstRecord) {
        String message = (String)object;
        File fileAnswer = null;
        try {
            String line;
            ByteArrayInputStream buffer = new ByteArrayInputStream(message.getBytes());
            DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
            Document doc = xdb.parse(new InputSource(buffer));
            if (doc == null) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "parsing error");
            }
            Envelope msgEnv = Envelope.unmarshall((Node)doc.getDocumentElement());
            Message msg = new Message();
            msg.send(url, "urn:this-is-the-action-uri", msgEnv);
            SOAPTransport st = msg.getSOAPTransport();
            BufferedReader br = st.receive();
            fileAnswer = new File("auxiliar");
            FileWriter fwAnswer = new FileWriter(fileAnswer);
            fwAnswer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                fwAnswer.write(line);
                fwAnswer.flush();
            }
            fwAnswer.close();
        }
        catch (Exception e) {
            return null;
        }
        ArrayList<XMLNode> col = new ArrayList<XMLNode>();
        col.add(XMLTree.xmlToTree(fileAnswer));
        return col;
    }

    public static boolean isProtocolSupported(URL url) {
        return true;
    }

    public static String setSOAPMessage(String message, String[] schemas) {
        String soap = "<SOAP:Envelope xmlns:SOAP=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        if (schemas != null) {
            for (int i = 0; i < schemas.length; ++i) {
                soap = soap + " " + schemas[i];
            }
        }
        soap = soap + ">";
        soap = soap + "<SOAP:Body>" + message + "</SOAP:Body>" + "</SOAP:Envelope>";
        return soap;
    }
}

