/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.schemas;

import java.net.URI;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.querys.Coordinates;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.schemas.Resource;

public class Iso19139_119Record
extends Record {
    public Iso19139_119Record() {
    }

    public Iso19139_119Record(URI uri, XMLNode node) {
        super(uri, node);
        this.setTitle(node.searchNodeValue("identificationInfo->SV_ServiceIdentification->citation->CI_Citation->title->CharacterString"));
        this.setAbstract_(node.searchNodeValue("identificationInfo->SV_ServiceIdentification->abstract->gco:CharacterString"));
        this.setPurpose(node.searchNodeValue("dataIdInfo->idPurp"));
        this.setKeyWords(node.searchMultipleNodeValue("identificationInfo->SV_ServiceIdentification->descriptiveKeywords->MD_Keywords->keyword->gco:CharacterString"));
        this.setResources(this.getResources("distributionInfo->MD_Distribution->transferOptions->MD_DigitalTransferOptions->onLine->CI_OnlineResource", "identificationInfo->SV_ServiceIdentification"));
        this.setFileID(node.searchNodeValue("mdFileID"));
        this.setImageURL(node.searchNodeValue("dataIdInfo->graphOver"));
    }

    private Resource[] getResources(String label_layers, String label_services) {
        XMLNode[] nodes = XMLTree.searchMultipleNode(this.getNode(), label_layers);
        Coordinates coordinates = null;
        String srs = null;
        if (nodes == null) {
            return null;
        }
        Resource[] resources = new Resource[nodes.length + 1];
        if (nodes.length > 0) {
            srs = XMLTree.searchNodeValue(this.getNode(), "refSysInfo->MdCoRefSys->refSysID->identCode");
            coordinates = new Coordinates(XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->westBL"), XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->northBL"), XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->eastBL"), XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->southBL"));
        }
        for (int i = 0; i < resources.length - 1; ++i) {
            String linkage = XMLTree.searchNodeValue(nodes[i], "linkage->URL");
            String protocol = XMLTree.searchNodeValue(nodes[i], "protocol->gco:CharacterString");
            String name = XMLTree.searchNodeValue(nodes[i], "name->gco:CharacterString");
            String description = XMLTree.searchNodeValue(nodes[i], "description->gco:CharacterString");
            String function = XMLTree.searchNodeAtribute(nodes[i], "orFunct->OnFunctCd", "value");
            if (linkage == null) {
                linkage = "";
            }
            if (protocol == null) {
                protocol = "";
            }
            if (name == null) {
                name = "";
            }
            if (description == null) {
                description = "";
            }
            if (function == null) {
                function = "";
            }
            resources[i] = new Resource(linkage, protocol, name, description, function, srs, coordinates);
        }
        XMLNode node = XMLTree.searchNode(this.getNode(), label_services);
        if (node == null) {
            return null;
        }
        String service_name = XMLTree.searchNodeValue(node, "srv:serviceType->gco:LocalName");
        String[] operations = XMLTree.searchMultipleNodeValue(node, "srv:containsOperations->srv:SV_OperationMetadata->srv:operationName->gco:CharacterString");
        XMLNode[] operations_nodes = XMLTree.searchMultipleNode(node, "srv:containsOperations->srv:SV_OperationMetadata");
        String capabilities_url = "";
        for (int i = 0; i < operations_nodes.length; ++i) {
            String operation_name = XMLTree.searchNodeValue(operations_nodes[i], "srv:operationName->gco:CharacterString");
            if (!operation_name.toUpperCase().equals("GETCAPABILITIES")) continue;
            capabilities_url = XMLTree.searchNodeValue(operations_nodes[i], "srv:connectPoint->gmd:CI_OnlineResource->gmd:linkage->gmd:URL");
            break;
        }
        int last_index = nodes.length;
        resources[last_index] = new Resource(capabilities_url, "OGC:WMS_SERVICE", null, null, null, null, null);
        resources[last_index].setType("OGC:WMS_SERVICE");
        return resources;
    }

    @Override
    public boolean accept(URI uri, XMLNode node) {
        return node.getName().endsWith("MD_Metadata") && node.searchNode("identificationInfo->SV_ServiceIdentification->citation->CI_Citation->title") != null;
    }
}

