/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.srw.drivers;

import org.apache.commons.httpclient.NameValuePair;
import org.gvsig.catalog.drivers.IProtocolMessages;
import org.gvsig.catalog.protocols.SOAPProtocol;
import org.gvsig.catalog.querys.CatalogQuery;
import org.gvsig.catalog.srw.drivers.SRWCatalogServiceDriver;
import org.gvsig.catalog.srw.filters.IDEESRWFilter;
import org.gvsig.catalog.srw.filters.SRWFilter;

public class SRWMessages
implements IProtocolMessages {
    private SRWCatalogServiceDriver driver;

    public SRWMessages(SRWCatalogServiceDriver driver) {
        this.driver = driver;
    }

    @Override
    public NameValuePair[] getHTTPGETCapabilities(boolean upper) {
        NameValuePair nvp1 = new NameValuePair("OPERATION", "explain");
        NameValuePair nvp2 = new NameValuePair("VERSION", this.driver.getVersion());
        return new NameValuePair[]{nvp1, nvp2};
    }

    @Override
    public NameValuePair[] getHTTPGETDescribeRecords() {
        return null;
    }

    @Override
    public NameValuePair[] getHTTPGETRecords(CatalogQuery query, int firstRecord) {
        NameValuePair nvp1 = new NameValuePair("operation", "searchRetrieve");
        NameValuePair nvp2 = new NameValuePair("version", this.driver.getVersion());
        NameValuePair nvp3 = new NameValuePair("query", new SRWFilter().getQuery(query));
        NameValuePair nvp4 = new NameValuePair("maximumRecords", "10");
        NameValuePair nvp5 = new NameValuePair("recordPacking", this.driver.getOutputFormat());
        NameValuePair nvp6 = new NameValuePair("startRecord", new String(new Integer(firstRecord).toString()));
        return new NameValuePair[]{nvp1, nvp2, nvp3, nvp4, nvp5, nvp6};
    }

    @Override
    public String getHTTPPOSTCapabilities() {
        return null;
    }

    @Override
    public String getHTTPPOSTDescribeRecords() {
        return null;
    }

    @Override
    public String getHTTPPOSTRecords(CatalogQuery query, int firstRecord) {
        return null;
    }

    @Override
    public String getSOAPCapabilities() {
        String soapMessage = "<SRW:explainRequest xmlns:SRW=\"http://www.loc.gov/zing/srw/\"><SRW:version>" + this.driver.getVersion() + "</SRW:version>" + "</SRW:explainRequest>";
        return SOAPProtocol.setSOAPMessage(soapMessage, null);
    }

    @Override
    public String getSOAPDescribeRecords() {
        return null;
    }

    @Override
    public String getSOAPRecords(CatalogQuery query, int firstRecord) {
        String soapMessage = "<srw:searchRetrieveRequest xmlns:srw=\"http://www.loc.gov/zing/srw/\"><srw:query><![CDATA[" + new IDEESRWFilter().getQuery(query) + "]]></srw:query>" + "<srw:sortKeys xsi:nil=\"true\"/>" + "<srw:startRecord>" + this.driver.getStartPosition() + "</srw:startRecord>" + "<srw:maximumRecords>" + this.driver.getMaxRecords() + "</srw:maximumRecords>" + "<srw:recordPacking>" + this.driver.getOutputFormat() + "</srw:recordPacking>" + "<srw:recordSchema>" + this.driver.getOutputSchema()[0] + "</srw:recordSchema>" + "<srw:resultSetTTL>" + this.driver.getResultSetTTL() + "</srw:resultSetTTL>" + "</srw:searchRetrieveRequest>";
        return SOAPProtocol.setSOAPMessage(soapMessage, null);
    }
}

