/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.ui.chooseresource;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.catalog.utils.resourcestable.TableModel;
import org.gvsig.i18n.Messages;

public class ChooseResourcePanel
extends JPanel {
    private JTable table = null;
    private JScrollPane tablePane = null;
    private Collection resources = new ArrayList();

    public ChooseResourcePanel(Collection resources) {
        this.resources = resources;
        this.initialize();
    }

    private TableModel createTableModel() {
        Object[][] columnValues = new Object[this.resources.size()][3];
        String[] columnNames = new String[]{Messages.getText((String)"resourceTypeColumn"), Messages.getText((String)"resourceLinkColumn"), Messages.getText((String)"resourceShowColumn")};
        for (int i = 0; i < this.resources.size(); ++i) {
            Resource resource = (Resource)this.resources.toArray()[i];
            String protocol = resource.getProtocol();
            if (StringUtils.isBlank((CharSequence)protocol)) {
                protocol = "WWW:DOWNLOAD";
            }
            columnValues[i][0] = protocol;
            columnValues[i][1] = resource.getLinkage();
            columnValues[i][2] = this.getNameButton(protocol);
        }
        return new TableModel(columnValues, columnNames);
    }

    private String getNameButton(String protocol) {
        if (protocol.toUpperCase().contains("OGC:WCS")) {
            return Messages.getText((String)"wcsColumn");
        }
        if (protocol.toUpperCase().contains("OGC:WMS_SERVICE")) {
            return Messages.getText((String)"Servicio WMS");
        }
        if (protocol.toUpperCase().contains("OGC:WMS")) {
            return Messages.getText((String)"wmsColumn");
        }
        if (protocol.toUpperCase().contains("OGC:WFS")) {
            return Messages.getText((String)"wfsColumn");
        }
        if (protocol.toUpperCase().contains("POSTGIS")) {
            return Messages.getText((String)"postgisColumn");
        }
        if (protocol.toUpperCase().contains("WWW:LINK")) {
            return Messages.getText((String)"linkColumn");
        }
        if (protocol.toUpperCase().contains("WWW:DOWNLOAD")) {
            return Messages.getText((String)"downloadColumn");
        }
        if (protocol.toUpperCase().contains("ESRI:AIMS--HTTP-GET-IMAGE")) {
            return Messages.getText((String)"arcims_image_resource");
        }
        if (protocol.toUpperCase().contains("ESRI:AIMS--HTTP-GET-FEATURE")) {
            return Messages.getText((String)"arcims_vect_resource");
        }
        return Messages.getText((String)"unknown");
    }

    private void initialize() {
        this.setLayout(new BorderLayout(2, 2));
        this.setPreferredSize(new Dimension(510, 125));
        this.add((Component)this.getTablePane(), "Center");
    }

    public JScrollPane getTablePane() {
        if (this.tablePane == null) {
            this.tablePane = new JScrollPane(this.getTable());
            this.tablePane.setPreferredSize(new Dimension(575, 100));
        }
        return this.tablePane;
    }

    public JTable getTable() {
        if (this.table == null) {
            this.table = new JTable(this.createTableModel());
        }
        return this.table;
    }

    public JButton[] getButtons() {
        JButton[] buttons = new JButton[this.resources.size()];
        for (int i = 0; i < this.resources.size(); ++i) {
            buttons[i] = (JButton)this.getTable().getModel().getValueAt(i, 2);
        }
        return buttons;
    }
}

