/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.ui.serverconnect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.gvsig.catalog.CatalogClient;
import org.gvsig.catalog.CatalogLocator;
import org.gvsig.catalog.CatalogManager;
import org.gvsig.catalog.drivers.DiscoveryServiceCapabilities;
import org.gvsig.catalog.drivers.ICatalogServiceDriver;
import org.gvsig.catalog.ui.search.SearchDialog;
import org.gvsig.catalog.ui.serverconnect.ServerConnectPanel;
import org.gvsig.catalog.ui.serverproperties.ServerPropertiesDialog;
import org.gvsig.i18n.Messages;
import org.gvsig.utils.swing.jcomboServer.ServerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectDialogPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1224880378648403038L;
    private static Logger logger = LoggerFactory.getLogger(ServerConnectDialogPanel.class);
    private static final CatalogManager catalogManager = CatalogLocator.getCatalogManager();
    private ServerConnectPanel controlsPanel = null;
    private JFrame parent = null;
    protected CatalogClient client = null;
    protected String currentServer = "";
    private ConnectThread connectThread = null;

    public ServerConnectDialogPanel(JFrame parent) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getControlsPanel(), "Center");
        int n_servers = this.loadServerList();
        this.controlsPanel.loadDrivers(catalogManager.getDrivers());
        this.getControlsPanel().setPropertiesIcon(this.getPropertiesIcon());
        if (n_servers == 0) {
            return;
        }
        this.controlsPanel.updateProtocol();
        this.enableServerPropertiesButton();
    }

    protected Icon getPropertiesIcon() {
        return new ImageIcon("./gvSIG/extensiones/org.gvsig.catalog/images/serverProperties.png");
    }

    public ServerConnectPanel getControlsPanel() {
        if (this.controlsPanel == null) {
            this.controlsPanel = new ServerConnectPanel();
            this.controlsPanel.addActionListener(this);
            this.controlsPanel.enableSearchButton(false);
        }
        return this.controlsPanel;
    }

    private int loadServerList() {
        Map<String, ServerData> serversMap = catalogManager.getServersPersistence();
        if (serversMap != null) {
            for (String key : serversMap.keySet()) {
                ServerData server = serversMap.get(key);
                this.controlsPanel.addServer(server);
            }
            return serversMap.size();
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("connect") == 0) {
            this.connectButtonActionPerformed();
        } else if (e.getActionCommand().compareTo("search") == 0) {
            this.searchButtonActionPerformed();
        } else if (e.getActionCommand().compareTo("close") == 0) {
            this.closeButtonActionPerformed();
        } else if (e.getActionCommand().compareTo("protocolCombo") == 0) {
            this.enableServerPropertiesButton();
        } else if (e.getActionCommand().compareTo("serverProperties") == 0) {
            this.serverPropertiesButtonActionPerformed();
        } else if (e.getActionCommand().compareTo("serverCombo") == 0) {
            this.controlsPanel.updateProtocol();
        }
    }

    private void enableServerPropertiesButton() {
        if (((ICatalogServiceDriver)this.controlsPanel.getDriver()).getProfile() == null) {
            this.controlsPanel.enableServerPropertiesButton(false);
        } else {
            this.controlsPanel.enableServerPropertiesButton(true);
        }
    }

    protected void searchButtonActionPerformed() {
        this.setEnabled(false);
        new SearchDialog(this.client, this.parent);
    }

    protected void serverPropertiesButtonActionPerformed() {
        this.createClient();
        new ServerPropertiesDialog(this.controlsPanel.getServer(), this.client, ((ICatalogServiceDriver)this.controlsPanel.getDriver()).getProfile());
    }

    protected void connectButtonActionPerformed() {
        this.controlsPanel.enableSearchButton(false);
        this.createClient();
        if (this.connectThread != null) {
            this.connectThread.stop();
        }
        this.connectThread = new ConnectThread();
        this.setCursor(new Cursor(3));
    }

    protected void createClient() {
        ServerData serverData = null;
        if (this.client != null) {
            serverData = this.client.getServerData();
        }
        this.client = new CatalogClient(this.controlsPanel.getServerAddress(), this.controlsPanel.getDatabase(), (ICatalogServiceDriver)this.controlsPanel.getDriver());
        this.client.setServerData(serverData);
    }

    protected void closeButtonActionPerformed() {
        this.parent.setVisible(false);
        System.exit(0);
    }

    public String getCurrentServer() {
        return this.currentServer;
    }

    public CatalogClient getClient() {
        return this.client;
    }

    private class ConnectThread
    implements Runnable {
        volatile Thread myThread = new Thread(this);

        public ConnectThread() {
            this.myThread.start();
        }

        public void stop() {
            this.myThread.stop();
        }

        @Override
        public void run() {
            try {
                DiscoveryServiceCapabilities capabilities = ServerConnectDialogPanel.this.client.getCapabilities();
                if (capabilities.isAvailable()) {
                    ServerConnectDialogPanel.this.controlsPanel.enableSearchButton(true);
                    ServerConnectDialogPanel.this.currentServer = ServerConnectDialogPanel.this.controlsPanel.getServerAddress();
                    ServerConnectDialogPanel.this.searchButtonActionPerformed();
                }
                ServerConnectDialogPanel.this.setCursor(new Cursor(0));
                ServerConnectDialogPanel.this.controlsPanel.setServerReply(capabilities.getServerMessage());
            }
            catch (Exception e) {
                ServerConnectDialogPanel.this.controlsPanel.setServerReply(Messages.getText((String)e.toString()));
                e.printStackTrace();
            }
        }
    }
}

