/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.ui.serverconnect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gvsig.catalog.CatalogLocator;
import org.gvsig.catalog.CatalogManager;
import org.gvsig.catalog.drivers.ICatalogServiceDriver;
import org.gvsig.catalog.drivers.IDiscoveryServiceDriver;
import org.gvsig.catalog.utils.CatalogConstants;
import org.gvsig.i18n.Messages;
import org.gvsig.utils.swing.jcomboServer.JComboServer;
import org.gvsig.utils.swing.jcomboServer.ServerData;

public class ServerConnectPanel
extends JPanel {
    private static final CatalogManager catalogManager = CatalogLocator.getCatalogManager();
    private JPanel centerPanel;
    private JButton closeButton;
    private JButton connectButton;
    private JLabel dataBaseLabel;
    private JPanel dataBasePanel;
    private JTextField dataBaseText;
    private JScrollPane jScrollPane1;
    private JPanel lowerPanel;
    protected JComboBox protocolCombo;
    protected JLabel protocolLabel;
    private JPanel protocolPanel;
    private JLabel replyLabel;
    private JEditorPane replyText;
    private JButton searchButton;
    private JComboServer serverCombo;
    protected JLabel serverLabel;
    private JPanel serverPanel;
    private JButton serverPropertiesButton;
    private JPanel upperPanel;

    public ServerConnectPanel() {
        this.initComponents();
        this.initLabels();
        this.initButtonSize();
        this.initDefaultValues();
    }

    private void initComponents() {
        this.upperPanel = new JPanel();
        this.serverPanel = new JPanel();
        this.serverLabel = new JLabel();
        this.serverCombo = new JComboServer();
        this.protocolPanel = new JPanel();
        this.protocolLabel = new JLabel();
        this.protocolCombo = new JComboBox();
        this.serverPropertiesButton = new JButton();
        this.dataBasePanel = new JPanel();
        this.dataBaseLabel = new JLabel();
        this.dataBaseText = new JTextField();
        this.centerPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.replyText = new JEditorPane();
        this.replyLabel = new JLabel();
        this.lowerPanel = new JPanel();
        this.connectButton = new JButton();
        this.searchButton = new JButton();
        this.closeButton = new JButton();
        this.setLayout(new BorderLayout(0, 5));
        this.upperPanel.setLayout(new GridBagLayout());
        this.serverPanel.setLayout(new GridBagLayout());
        this.serverLabel.setText("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 2, 2);
        this.serverPanel.add((Component)this.serverLabel, gridBagConstraints);
        this.serverCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Art\u00edculo 1", "Art\u00edculo 2", "Art\u00edculo 3", "Art\u00edculo 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.serverPanel.add((Component)this.serverCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.weightx = 0.3;
        this.upperPanel.add((Component)this.serverPanel, gridBagConstraints);
        this.protocolPanel.setLayout(new GridBagLayout());
        this.protocolLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 2, 2);
        this.protocolPanel.add((Component)this.protocolLabel, gridBagConstraints);
        this.protocolCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Art\u00edculo 1", "Art\u00edculo 2", "Art\u00edculo 3", "Art\u00edculo 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 4);
        this.protocolPanel.add((Component)this.protocolCombo, gridBagConstraints);
        this.serverPropertiesButton.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 3);
        this.protocolPanel.add((Component)this.serverPropertiesButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.upperPanel.add((Component)this.protocolPanel, gridBagConstraints);
        this.dataBasePanel.setLayout(new GridBagLayout());
        this.dataBaseLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 2, 2);
        this.dataBasePanel.add((Component)this.dataBaseLabel, gridBagConstraints);
        this.dataBaseText.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.dataBasePanel.add((Component)this.dataBaseText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        this.upperPanel.add((Component)this.dataBasePanel, gridBagConstraints);
        this.add((Component)this.upperPanel, "North");
        this.centerPanel.setLayout(new BorderLayout(2, 4));
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 5));
        this.jScrollPane1.setViewportView(this.replyText);
        this.centerPanel.add((Component)this.jScrollPane1, "Center");
        this.replyLabel.setText("jLabel1");
        this.centerPanel.add((Component)this.replyLabel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.lowerPanel.setLayout(new FlowLayout(2, 5, 0));
        this.lowerPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.connectButton.setText("jButton1");
        this.lowerPanel.add(this.connectButton);
        this.searchButton.setText("jButton2");
        this.lowerPanel.add(this.searchButton);
        this.closeButton.setText("jButton3");
        this.lowerPanel.add(this.closeButton);
        this.add((Component)this.lowerPanel, "South");
    }

    private void initLabels() {
        this.serverLabel.setText(Messages.getText((String)"serverURLCat"));
        this.protocolLabel.setText(Messages.getText((String)"protocolsGroup"));
        this.dataBaseLabel.setText(Messages.getText((String)"database"));
        this.replyLabel.setText(Messages.getText((String)"serverReply"));
        this.connectButton.setText(Messages.getText((String)"connectButton"));
        this.searchButton.setText(Messages.getText((String)"searchButton"));
        this.closeButton.setText(Messages.getText((String)"close"));
    }

    private void initDefaultValues() {
        this.dataBaseText.setText("");
        this.protocolCombo.removeAllItems();
        this.serverCombo.removeAllItems();
        this.serverCombo.setEditable(true);
        this.replyText.setEditable(false);
    }

    private void initButtonSize() {
        this.connectButton.setPreferredSize(CatalogConstants.BUTTON_SIZE);
        this.searchButton.setPreferredSize(CatalogConstants.BUTTON_SIZE);
        this.closeButton.setPreferredSize(CatalogConstants.BUTTON_SIZE);
    }

    protected void setDatabaseVisible(boolean isVisible) {
        this.dataBaseLabel.setVisible(false);
        this.dataBaseText.setVisible(false);
        this.dataBasePanel.setVisible(false);
    }

    public void addServer(ServerData serverData) {
        this.serverCombo.addServer(serverData);
    }

    public void loadDrivers(Object[] drivers) {
        for (int i = 0; i < drivers.length; ++i) {
            this.protocolCombo.addItem(drivers[i]);
        }
    }

    public void setProtocol(String protocol) {
        ICatalogServiceDriver driver = catalogManager.getDriver(protocol);
        if (driver != null) {
            for (int i = 0; i < this.protocolCombo.getItemCount(); ++i) {
                IDiscoveryServiceDriver auxDriver = (IDiscoveryServiceDriver)this.protocolCombo.getItemAt(i);
                if (auxDriver.getServiceName().toLowerCase().compareTo(driver.getServiceName().toLowerCase()) != 0) continue;
                this.protocolCombo.setSelectedItem(auxDriver);
            }
        }
    }

    public void setPropertiesIcon(Icon icon) {
        this.serverPropertiesButton.setIcon(icon);
    }

    public void updateProtocol() {
        ServerData server = this.getServer();
        if (server != null) {
            this.setProtocol(server.getServiceSubType());
        }
    }

    public void updateServerByProtocol() {
        ServerData serverData;
        IDiscoveryServiceDriver discoveryServiceDriver = (IDiscoveryServiceDriver)this.protocolCombo.getSelectedItem();
        if (discoveryServiceDriver != null && (serverData = discoveryServiceDriver.getOneServer()) != null) {
            this.serverCombo.setSelectedItem((Object)serverData);
        }
    }

    public ServerData getServer() {
        return this.serverCombo.getSelectedServer();
    }

    public ServerData[] getAllServers() {
        return this.serverCombo.getAllServers();
    }

    public Object getDriver() {
        return this.protocolCombo.getSelectedItem();
    }

    public String getServerAddress() {
        return this.serverCombo.getSelectedServer().getServerAddress();
    }

    public String getDatabase() {
        return this.dataBaseText.getText();
    }

    public void setServerReply(String text) {
        this.replyText.setText(text);
    }

    public void addActionListener(ActionListener listener) {
        this.serverCombo.addActionListener(listener);
        this.serverCombo.setActionCommand("serverCombo");
        this.protocolCombo.addActionListener(listener);
        this.protocolCombo.setActionCommand("protocolCombo");
        this.connectButton.addActionListener(listener);
        this.connectButton.setActionCommand("connect");
        this.searchButton.addActionListener(listener);
        this.searchButton.setActionCommand("search");
        this.closeButton.addActionListener(listener);
        this.closeButton.setActionCommand("close");
        this.serverPropertiesButton.addActionListener(listener);
        this.serverPropertiesButton.setActionCommand("serverProperties");
    }

    public void enableSearchButton(boolean isEnabled) {
        this.searchButton.setEnabled(isEnabled);
    }

    public void enableServerPropertiesButton(boolean isEnabled) {
        this.serverPropertiesButton.setEnabled(isEnabled);
    }

    public void setServerPropertiesButtonVisible(boolean isVisible) {
        this.serverPropertiesButton.setVisible(isVisible);
    }

    public void setServerTextEnabled(boolean isEnabled) {
        this.serverCombo.setEnabled(isEnabled);
    }
}

