/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.ui.showresults;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.gvsig.catalog.CatalogClient;
import org.gvsig.catalog.drivers.GetRecordsReply;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.catalog.ui.chooseresource.ChooseResourceDialog;
import org.gvsig.catalog.ui.showresults.ShowResultsPanel;
import org.gvsig.catalog.ui.showtree.ShowTreeDialog;

public class ShowResultsDialogPanel
extends JPanel
implements ActionListener {
    private JDialog parent;
    protected ShowResultsPanel controlsPanel = null;
    private CatalogClient client = null;
    private int currentRecord = 0;
    private JButton nextButton = null;
    private JButton lastButton = null;
    private JButton descriptionButton = null;
    private JButton mapButton = null;
    private JButton closeButton = null;
    protected GetRecordsReply recordsReply = null;

    public ShowResultsDialogPanel(CatalogClient client, GetRecordsReply recordsReply, int currentRecord) {
        this.recordsReply = recordsReply;
        this.client = client;
        this.currentRecord = currentRecord;
        this.controlsPanel = new ShowResultsPanel(client, recordsReply.getRecordsNumber());
        this.controlsPanel.loadTextNewRecord(recordsReply.getRecordAt(currentRecord - 1));
        this.setDefaultButtonListeners();
        this.enableLoadResourcesButton();
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)this.controlsPanel, "Center");
    }

    public void enableLoadResourcesButton() {
        this.getMapButton().setEnabled(false);
        if (this.controlsPanel.getRecord() != null) {
            Resource[] resources = this.controlsPanel.getRecord().getResources();
            if (resources == null) {
                return;
            }
            for (Resource resource : resources) {
                String protocol = resource.getProtocol();
                if (protocol != null && !protocol.toUpperCase().contains("OGC:WMS") && !protocol.toUpperCase().contains("OGC:WFS") && !protocol.toUpperCase().contains("OGC:WCS") && !protocol.toUpperCase().contains("POSTGIS") && !protocol.toUpperCase().contains("WWW:LINK") && !protocol.toUpperCase().contains("ESRI:AIMS--HTTP-GET-IMAGE") && !protocol.toUpperCase().contains("ESRI:AIMS--HTTP-GET-FEATURE") && !protocol.toUpperCase().contains("WWW:DOWNLOAD")) continue;
                this.getMapButton().setEnabled(true);
                return;
            }
        }
    }

    public void setDefaultButtonListeners() {
        this.nextButton = this.controlsPanel.getNextButton();
        this.lastButton = this.controlsPanel.getPreviousButton();
        this.descriptionButton = this.controlsPanel.getDescriptionButton();
        this.mapButton = this.controlsPanel.getMapButton();
        this.closeButton = this.controlsPanel.getCloseButton();
        this.nextButton.addActionListener(this);
        this.lastButton.addActionListener(this);
        this.descriptionButton.addActionListener(this);
        this.mapButton.addActionListener(this);
        this.closeButton.addActionListener(this);
    }

    public JButton getDescriptionButton() {
        return this.descriptionButton;
    }

    public JButton getMapButton() {
        return this.mapButton;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public void createNewSearch(int firstRecord) {
        this.recordsReply = this.client.getRecords(null, firstRecord);
    }

    public int getCurrentNode() {
        return this.currentRecord - 1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("next")) {
            this.nextButtonActionPerformed();
        }
        if (e.getActionCommand().equals("previous")) {
            this.lastButtonActionPerformed();
        }
        if (e.getActionCommand().equals("description")) {
            this.descriptionButtonActionPerformed();
        }
        if (e.getActionCommand().equals("layer")) {
            this.mapButtonActionPerformed();
        }
        if (e.getActionCommand().equals("close")) {
            this.closeButtonActionPerformed();
        }
    }

    protected void nextButtonActionPerformed() {
        ++this.currentRecord;
        if (this.currentRecord == this.recordsReply.getRecordsNumber()) {
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
        this.lastButton.setEnabled(true);
        if (this.currentRecord % 10 == 1 && this.recordsReply.getRetrievedRecordsNumber() + 1 == this.currentRecord) {
            this.createNewSearch(this.currentRecord);
        }
        this.controlsPanel.loadTextNewRecord(this.recordsReply.getRecordAt(this.getCurrentNode()));
        this.controlsPanel.actualizaLabel(this.currentRecord);
        this.enableLoadResourcesButton();
    }

    protected void lastButtonActionPerformed() {
        --this.currentRecord;
        if (this.currentRecord == 1) {
            this.lastButton.setEnabled(false);
        } else {
            this.lastButton.setEnabled(true);
        }
        this.nextButton.setEnabled(true);
        this.controlsPanel.loadTextNewRecord(this.recordsReply.getRecordAt(this.getCurrentNode()));
        this.controlsPanel.actualizaLabel(this.currentRecord);
        this.enableLoadResourcesButton();
    }

    protected void descriptionButtonActionPerformed() {
        Record record = this.recordsReply.getRecordAt(this.getCurrentNode());
        if (record != null) {
            new ShowTreeDialog(record.getNode());
        }
    }

    protected void mapButtonActionPerformed() {
        Resource[] resources = this.controlsPanel.getRecord().getResources();
        ArrayList<Resource> col = new ArrayList<Resource>();
        col.addAll(Arrays.asList(resources));
        new ChooseResourceDialog(col);
    }

    protected void closeButtonActionPerformed() {
        this.parent.setVisible(false);
    }

    public void setParent(JDialog parent) {
        this.parent = parent;
    }
}

