/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.utils.xmltreetable;

import java.awt.Font;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import next.swing.AbstractTreeTableModel;
import next.swing.TreeTableModel;
import org.amic.util.date.Date;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.utils.Strings;
import org.gvsig.catalog.utils.xmltreetable.XMLTreeTable;
import org.gvsig.catalog.utils.xmltreetable.XMLTreeTableCellRenderer;

public class XMLTreeTableModel
extends AbstractTreeTableModel {
    private Vector columns = null;
    private String[] allowed = null;
    private String[] forbidden = null;
    private boolean dynamic = false;
    public final int ALIGN_LEFT = 2;
    public final int ALIGN_RIGHT = 4;
    public final int ALIGN_CENTER = 0;

    public XMLTreeTableModel(XMLNode node) {
        this(node, -1, null, null);
    }

    public XMLTreeTableModel(XMLNode node, int level, String[] allowed, String[] forbidden) {
        super((Object)new DefaultMutableTreeNode(node));
        this.allowed = allowed;
        this.forbidden = forbidden;
        this.processChildren((DefaultMutableTreeNode)this.getRoot(), level);
    }

    public void setDynamic(boolean value) {
        this.dynamic = value;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0 && !this.dynamic;
    }

    public boolean processChildren(DefaultMutableTreeNode node, int level) {
        int i;
        String name;
        if (level == 0) {
            return true;
        }
        boolean doIt = true;
        XMLNode n = (XMLNode)node.getUserObject();
        if (this.allowed != null) {
            name = n.getName();
            doIt = false;
            for (i = 0; i < this.allowed.length; ++i) {
                if (!this.allowed[i].equals(name)) continue;
                doIt = true;
                break;
            }
        }
        if (this.forbidden != null) {
            name = n.getName();
            for (i = 0; i < this.forbidden.length; ++i) {
                if (!this.forbidden[i].equals(name)) continue;
                doIt = false;
                break;
            }
        }
        if (!doIt) {
            return false;
        }
        XMLNode[] nodes = n.getSubnodes();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(nodes[i2]);
            if (!this.processChildren(newNode, level - 1)) continue;
            node.add(newNode);
        }
        return true;
    }

    public void configureView(XMLTreeTable ctt) {
        TableColumnModel tcm = ctt.getColumnModel();
        ctt.setRowHeight(20);
        int total = 0;
        for (int i = 1; i < tcm.getColumnCount(); ++i) {
            Column col = (Column)this.columns.elementAt(i - 1);
            tcm.getColumn(i).setPreferredWidth(50);
            total += col.width;
            tcm.getColumn(i).setCellRenderer(new XMLTreeTableCellRenderer());
        }
        tcm.getColumn(0).setWidth(100);
        this.setExpandedTree((DefaultMutableTreeNode)this.getRoot(), ctt.getTree());
    }

    public boolean setExpandedTree(DefaultMutableTreeNode node, JTree tree) {
        boolean isExpanded = false;
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (!this.setExpandedTree(child, tree) || isExpanded) continue;
            isExpanded = true;
        }
        if (node.isLeaf() && (this.isValueAt(node) || this.isAttributeAt(node))) {
            tree.expandPath(new TreePath(node.getPath()));
            return true;
        }
        if (isExpanded) {
            tree.expandPath(new TreePath(node.getPath()));
        }
        return isExpanded;
    }

    public void addJScrollPaneColumn(String name, String attribute, String label, int width) {
        this.addColumn(new Column(name, attribute, label, 2, width, JScrollPane.class, null));
    }

    public void addStringColumn(String name, String attribute, String label, int width) {
        this.addColumn(new Column(name, attribute, label, 2, width, String.class, null));
    }

    public void addNumberColumn(String name, String attribute, String label, int width, String format) {
        this.addColumn(new Column(name, attribute, label, 4, width, Double.class, format));
    }

    public void addDateColumn(String name, String attribute, String label, int width, String format) {
        this.addColumn(new Column(name, attribute, label, 2, width, Date.class, format));
    }

    public void addColumn(Column column) {
        if (this.columns == null) {
            this.columns = new Vector();
        }
        this.columns.add(column);
    }

    public int getChildCount(Object parent) {
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    public Object getChild(Object parent, int index) {
        return ((DefaultMutableTreeNode)parent).getChildAt(index);
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "";
        }
        return ((Column)this.columns.elementAt((int)(column - 1))).label;
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return TreeTableModel.class;
        }
        return ((Column)this.columns.elementAt((int)(column - 1))).jClass;
    }

    public boolean isValueAt(Object node) {
        XMLNode xr;
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
        return currentNode.getUserObject() instanceof XMLNode && (xr = (XMLNode)currentNode.getUserObject()) != null && xr.getText() != null && !Strings.replace(xr.getText(), " ", "").equals("");
    }

    public boolean isAttributeAt(Object node) {
        XMLNode xr;
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
        return currentNode.getUserObject() instanceof XMLNode && (xr = (XMLNode)currentNode.getUserObject()) != null && this.getAttribute(xr) != null && !Strings.replace(this.getAttribute(xr), " ", "").equals("");
    }

    public String getValueAt(Object node) {
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
        if (currentNode.getUserObject() instanceof XMLNode) {
            XMLNode xr = (XMLNode)currentNode.getUserObject();
            return xr.getText();
        }
        return null;
    }

    public Object getValueAt(Object node, int column) {
        JEditorPane editor = new JEditorPane();
        editor.setEditable(false);
        JScrollPane scroll = new JScrollPane(editor);
        scroll.setBorder(null);
        JLabel text = new JLabel();
        text.setFont(new Font(null, 0, 12));
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
        if (currentNode.getUserObject() instanceof XMLNode) {
            XMLNode xr = (XMLNode)currentNode.getUserObject();
            if (column == 0) {
                return xr.toString();
            }
            Column col = (Column)this.columns.elementAt(column - 1);
            String att = col.attribute;
            try {
                if (att.equals("tag-name")) {
                    if (xr.getName().trim().length() > 40) {
                        editor.setText(xr.getName());
                        editor.setCaretPosition(0);
                        return scroll;
                    }
                    text.setText(xr.getName());
                    return text;
                }
                if (att.equals("tag-value")) {
                    if (xr.getText().trim().length() > 40) {
                        editor.setText(xr.getText());
                        editor.setCaretPosition(0);
                        return scroll;
                    }
                    text.setText(xr.getText());
                    return text;
                }
                if (this.getAttribute(xr).trim().length() > 40) {
                    editor.setText(this.getAttribute(xr));
                    editor.setCaretPosition(0);
                    return scroll;
                }
                text.setText(this.getAttribute(xr));
                return text;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getAttribute(XMLNode node) {
        String attributes = "";
        Vector vAttributes = node.getAttributeNames();
        for (int i = 0; i < vAttributes.size(); ++i) {
            String att = (String)vAttributes.get(i);
            String val = node.getAttribute(att);
            attributes = attributes + att + "=" + val + " ";
        }
        return attributes;
    }

    public int getColumnCount() {
        if (this.columns == null) {
            return 1;
        }
        return this.columns.size() + 1;
    }

    public class Column {
        int align;
        int width;
        Class jClass;
        String name;
        String attribute;
        String label;
        String format;

        Column(String name, String attribute, String label, int align, int width, Class jClass, String format) {
            this.name = name;
            this.attribute = attribute;
            this.label = label;
            this.align = align;
            this.width = width;
            this.jClass = jClass;
            this.format = format;
        }
    }
}

