/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.datum.PrimeMeridian;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.NonInvertibleOperationException;

public class LongitudeRotation
extends AbstractCoordinateOperation {
    private static final Identifier opId = new Identifier("EPSG", "9601", "Longitude Rotation", "Rotation");
    private double rotationAngle;

    public LongitudeRotation(double rotation) {
        super(opId);
        this.rotationAngle = rotation;
        this.precision = 1.0E-9;
    }

    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord == null || coord.length < 2) {
            throw new CoordinateDimensionException(coord, 2);
        }
        coord[1] = coord[1] + this.rotationAngle;
        return coord;
    }

    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        return new LongitudeRotation(-this.rotationAngle);
    }

    public static LongitudeRotation getLongitudeRotationTo(PrimeMeridian targetPM) {
        return new LongitudeRotation(-targetPM.getLongitudeFromGreenwichInRadians());
    }

    public static LongitudeRotation getLongitudeRotationFrom(PrimeMeridian targetPM) {
        return new LongitudeRotation(targetPM.getLongitudeFromGreenwichInRadians());
    }

    public String toString() {
        return this.getName() + " ( " + this.rotationAngle * 180.0 / Math.PI + "\u00b0 )";
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LongitudeRotation) {
            LongitudeRotation lr = (LongitudeRotation)o;
            return this.getRotationAngle() == lr.getRotationAngle();
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.rotationAngle) ^ Double.doubleToLongBits(this.rotationAngle) >>> 32);
        return hash;
    }
}

