/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.units.Quantity;
import org.cts.units.Unit;

public class UnitConversion
extends AbstractCoordinateOperation {
    private Unit[] sourceUnit;
    private Unit[] targetUnit;

    private UnitConversion(Unit[] sourceUnit, Unit[] targetUnit) {
        super(new Identifier(UnitConversion.class, sourceUnit[0].getName() + " to " + targetUnit[0].getName()));
        assert (sourceUnit.length == targetUnit.length) : "sourceUnit[] and targetUnit[] must have the same size";
        this.sourceUnit = sourceUnit;
        this.targetUnit = targetUnit;
    }

    private UnitConversion(Identifier identifier, Unit[] sourceUnit, Unit[] targetUnit) {
        super(identifier);
        assert (sourceUnit.length == targetUnit.length) : "sourceUnit[] and targetUnit[] must have the same size";
        this.sourceUnit = sourceUnit;
        this.targetUnit = targetUnit;
    }

    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord == null || coord.length == 0) {
            throw new CoordinateDimensionException("" + coord + " is an invalid coordinate");
        }
        int length = Math.min(coord.length, this.sourceUnit.length);
        for (int i = 0; i < length; ++i) {
            if (Double.isNaN(coord[i])) continue;
            coord[i] = coord[i] * this.sourceUnit[i].getScale() / this.targetUnit[i].getScale();
        }
        return coord;
    }

    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        return new UnitConversion(this.targetUnit, this.sourceUnit);
    }

    public static UnitConversion createUnitConverter(Unit sourceUnit, Unit targetUnit) {
        assert (sourceUnit.isComparable(targetUnit)) : "source and target units must be comparable";
        if (sourceUnit.getQuantity().equals(Quantity.LENGTH)) {
            Identifier identifier = new Identifier(UnitConversion.class, sourceUnit.getName() + " to " + targetUnit.getName());
            return new UnitConversion(identifier, new Unit[]{sourceUnit, sourceUnit, sourceUnit}, new Unit[]{targetUnit, targetUnit, targetUnit});
        }
        if (sourceUnit.getQuantity().equals(Quantity.ANGLE)) {
            Identifier identifier = new Identifier(UnitConversion.class, sourceUnit.getName() + " to " + targetUnit.getName());
            return new UnitConversion(identifier, new Unit[]{sourceUnit, sourceUnit, Unit.METER}, new Unit[]{targetUnit, targetUnit, Unit.METER});
        }
        throw new IllegalArgumentException("Source or target unit represents an unknown quantity : " + sourceUnit.getQuantity());
    }

    public static UnitConversion createUnitConverter(Unit planiSourceUnit, Unit planiTargetUnit, Unit altiSourceUnit, Unit altiTargetUnit) {
        Identifier identifier;
        assert (planiSourceUnit.isComparable(planiTargetUnit)) : "source and target horizontal units must be comparable";
        assert (altiSourceUnit.isComparable(altiTargetUnit)) : "source and target vertical units must be comparable";
        if (planiSourceUnit.getQuantity().equals(Quantity.LENGTH)) {
            identifier = new Identifier(UnitConversion.class, planiSourceUnit.getName() + " to " + planiTargetUnit.getName());
        } else if (planiSourceUnit.getQuantity().equals(Quantity.ANGLE)) {
            identifier = new Identifier(UnitConversion.class, planiSourceUnit.getName() + " to " + planiTargetUnit.getName());
        } else {
            throw new IllegalArgumentException("Source or target unit represents an unknown quantity : " + planiSourceUnit.getQuantity());
        }
        return new UnitConversion(identifier, new Unit[]{planiSourceUnit, planiSourceUnit, altiSourceUnit}, new Unit[]{planiTargetUnit, planiTargetUnit, altiTargetUnit});
    }
}

