/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.CoordinateOperation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Mercator1SP;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MillerCylindrical
extends Projection {
    public static final Identifier MILL = new Identifier("EPSG", "9818", "Miller Cylindrical", "MILL");
    protected final double lat0;
    protected final double lon0 = this.getCentralMeridian();
    protected final double FE;
    protected final double FN;
    protected final double n;
    protected final double[] invcoeff;

    public MillerCylindrical(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(MILL, ellipsoid, parameters);
        this.lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        double k0 = this.getScaleFactor();
        double a = this.getSemiMajorAxis();
        this.n = k0 * a;
        this.invcoeff = Mercator1SP.getInverseMercatorCoeff(ellipsoid);
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.PSEUDOCYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.APHYLACTIC;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double lon = coord[1];
        double lat = Math.abs(coord[0]) > 1.4835298641951802 ? 1.4835298641951802 : coord[0];
        double E = this.n * (lon - this.lon0);
        double N = this.n * this.ellipsoid.isometricLatitude(lat * 0.8) / 0.8;
        coord[0] = this.FE + E;
        coord[1] = this.FN + N;
        return coord;
    }

    @Override
    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        return new MillerCylindrical(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double ki;
                double t = Math.exp(0.8 * (this.FN - coord[1]) / this.n);
                double lat = ki = 1.5707963267948966 - 2.0 * Math.atan(t);
                for (int i = 1; i < 5; ++i) {
                    lat += this.invcoeff[i] * Math.sin((double)(2 * i) * ki);
                }
                coord[1] = (coord[0] - this.FE) / this.n + this.lon0;
                coord[0] = lat / 0.8;
                return coord;
            }
        };
    }
}

