/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.CoordinateOperation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;
import org.cts.util.Complex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewZealandMapGrid
extends Projection {
    public static final Identifier NZMG = new Identifier("EPSG", "9811", "New Zealand Map Grid", "NZMG");
    protected final double lat0;
    protected final double lon0 = this.getCentralMeridian();
    protected final double FE;
    protected final double FN;
    protected final Complex[] B;

    public NewZealandMapGrid(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(NZMG, ellipsoid, parameters);
        this.lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        this.B = new Complex[7];
        this.B[1] = new Complex(0.7557853228);
        this.B[2] = new Complex(0.249204646, 0.003371507);
        this.B[3] = new Complex(-0.001541739, 0.04105856);
        this.B[4] = new Complex(-0.10162907, 0.01727609);
        this.B[5] = new Complex(-0.26623489, -0.36249218);
        this.B[6] = new Complex(-0.6870983, -1.1651967);
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.MISCELLANEOUS;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double lambda = coord[1] - this.lon0;
        double isoPhi = this.ellipsoid.isometricLatitude(coord[0]) - this.ellipsoid.isometricLatitude(this.lat0);
        Complex zeta = new Complex(isoPhi, lambda);
        Complex origin = new Complex(this.FN, this.FE);
        Complex z = this.B[6].axpb(zeta, this.B[5]).axpb(zeta, this.B[4]).axpb(zeta, this.B[3]).axpb(zeta, this.B[2]).axpb(zeta, this.B[1]).times(zeta).times(this.ellipsoid.getSemiMajorAxis());
        Complex coordi = origin.plus(z);
        coord[0] = coordi.im();
        coord[1] = coordi.re();
        return coord;
    }

    @Override
    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        return new NewZealandMapGrid(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                Complex z = new Complex(coord[1] - this.FN, coord[0] - this.FE).divideBy(new Complex(this.ellipsoid.getSemiMajorAxis()));
                Complex[] b = new Complex[7];
                b[1] = new Complex(1.3231270439);
                b[2] = new Complex(-0.577245789, -0.007809598);
                b[3] = new Complex(0.508307513, -0.112208952);
                b[4] = new Complex(-0.15094762, 0.18200602);
                b[5] = new Complex(1.01418179, 1.64497696);
                b[6] = new Complex(1.9660549, 2.5127645);
                Complex zeta = b[6].axpb(z, b[5]).axpb(z, b[4]).axpb(z, b[3]).axpb(z, b[2]).axpb(z, b[1]).times(z);
                zeta = this.B[6].times(5.0).axpb(zeta, this.B[5].times(4.0)).axpb(zeta, this.B[4].times(3.0)).axpb(zeta, this.B[3].times(2.0)).axpb(zeta, this.B[2]).times(zeta).axpb(zeta, z).divideBy(this.B[6].times(6.0).axpb(zeta, this.B[5].times(5.0)).axpb(zeta, this.B[4].times(4.0)).axpb(zeta, this.B[3].times(3.0)).axpb(zeta, this.B[2].times(2.0)).axpb(zeta, this.B[1]));
                zeta = this.B[6].times(5.0).axpb(zeta, this.B[5].times(4.0)).axpb(zeta, this.B[4].times(3.0)).axpb(zeta, this.B[3].times(2.0)).axpb(zeta, this.B[2]).times(zeta).axpb(zeta, z).divideBy(this.B[6].times(6.0).axpb(zeta, this.B[5].times(5.0)).axpb(zeta, this.B[4].times(4.0)).axpb(zeta, this.B[3].times(3.0)).axpb(zeta, this.B[2].times(2.0)).axpb(zeta, this.B[1]));
                double lon = zeta.im();
                double isoLat = zeta.re();
                coord[0] = this.ellipsoid.latitude(isoLat + this.ellipsoid.isometricLatitude(this.lat0));
                coord[1] = this.lon0 + lon;
                return coord;
            }
        };
    }
}

