/*
 * Decompiled with CFR 0.152.
 */
package org.cts.parser.prj;

public final class PrjWriter {
    public static String roundToString(double number, double tol) {
        StringBuilder w = new StringBuilder();
        if (PrjWriter.isInteger(number, tol)) {
            w.append(Math.round(number));
        } else {
            double res = 1.0 / tol;
            w.append(Math.rint(number * res) / res);
        }
        return w.toString();
    }

    private static boolean isInteger(double a, double tol) {
        return Math.abs(a - Math.rint(a)) < tol;
    }

    public static String formatWKT(String wkt) {
        StringBuilder w = new StringBuilder();
        int n = 0;
        boolean dontAddAlinea = false;
        String[] wktexp = wkt.split("]],");
        for (int i = 0; i < wktexp.length; ++i) {
            int index = wktexp[i].indexOf("[");
            String begin = wktexp[i].substring(0, index + 1);
            w.append(begin);
            String end = wktexp[i].substring(index + 1);
            int ind = end.indexOf(",");
            while (ind != -1) {
                begin = end.substring(0, ind + 1);
                index = end.indexOf("[");
                end = end.substring(ind + 1);
                if (dontAddAlinea) {
                    w.append("\n").append(PrjWriter.indent(n)).append(begin);
                } else if (ind < index || index == -1) {
                    w.append(begin);
                } else {
                    w.append("\n").append(PrjWriter.indent(++n)).append(begin);
                }
                dontAddAlinea = begin.substring(begin.length() - 2).equals("],");
                ind = end.indexOf(",");
            }
            n = PrjWriter.checkIndent(end, n);
            w.append(end);
            if (i == wktexp.length - 1) continue;
            w.append("]],\n").append(PrjWriter.indent(--n));
        }
        return w.toString();
    }

    private static String indent(int n) {
        StringBuilder w = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            w = w.append("    ");
        }
        return w.toString();
    }

    private static int checkIndent(String end, int n) {
        int k = end.length() - 1;
        while (end.substring(k, k + 1).equals("]")) {
            --n;
            --k;
        }
        return n;
    }

    private PrjWriter() {
    }
}

