/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.tools.util.GetItemByKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSymbolTable
implements SymbolTable,
GetItemByKey<String, Object> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSymbolTable.class);
    private final String name;
    protected Map<String, Object> vars;
    protected List<SymbolTable> symbolTables;
    protected Map<String, Function> functions;
    protected Map<String, Function> functionAlias;

    public AbstractSymbolTable() {
        this(null);
    }

    public AbstractSymbolTable(String name) {
        this.name = name == null ? "Anonymous" : name;
        this.symbolTables = new ArrayList<SymbolTable>();
        this.vars = null;
        this.functions = null;
        this.functionAlias = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addFunction(Function function) {
        if (function == null) {
            throw new IllegalArgumentException("function can't be null");
        }
        this.getFunctions().put(function.name().toUpperCase(), function);
        List<String> aliases = function.aliases();
        if (aliases == null || aliases.isEmpty()) {
            return;
        }
        Map<String, Function> theFunctionAlias = this.getFunctionAlias();
        for (String alias : aliases) {
            if (alias == null) continue;
            theFunctionAlias.put(alias, function);
        }
    }

    public void addFunctions(Collection<Function> functions) {
        for (Function function : functions) {
            this.addFunction(function);
        }
    }

    public void removeFunction(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name can't be null");
        }
        this.functions.remove(name.toUpperCase());
    }

    @Override
    public boolean addSymbolTable(SymbolTable symbolTable) {
        if (symbolTable == null) {
            throw new IllegalArgumentException("Invalid symbol table (null)");
        }
        if (this == symbolTable && this.symbolTables.contains(symbolTable)) {
            return false;
        }
        this.symbolTables.add(0, symbolTable);
        return true;
    }

    @Override
    public boolean containsSymbolTable(SymbolTable symbolTable) {
        return this.symbolTables.contains(symbolTable);
    }

    @Override
    public boolean removeSymbolTable(SymbolTable symbolTable) {
        boolean n = this.symbolTables.remove(symbolTable);
        return n;
    }

    protected Map<String, Object> getVars() {
        if (this.vars == null) {
            this.vars = new HashMap<String, Object>();
        }
        return this.vars;
    }

    public void setVar(String name, Object value) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name can't be null");
        }
        this.getVars().put(name.toUpperCase(), value);
    }

    public void removeVar(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name can't be null");
        }
        this.getVars().remove(name.toUpperCase());
    }

    protected Map<String, Function> getFunctions() {
        if (this.functions == null) {
            this.functions = new HashMap<String, Function>();
        }
        return this.functions;
    }

    protected Map<String, Function> getFunctionAlias() {
        if (this.functionAlias == null) {
            this.functionAlias = new HashMap<String, Function>();
        }
        return this.functionAlias;
    }

    @Override
    public boolean exists(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        if (this.getVars().containsKey(name.toUpperCase())) {
            return true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"$symboltable")) {
            return true;
        }
        for (SymbolTable other : this.symbolTables) {
            if (other == this || !other.exists(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object value(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        name = name.toUpperCase();
        if (this.getVars().containsKey(name)) {
            return this.getVars().get(name);
        }
        if (name.equals("$SYMBOLTABLE")) {
            return this;
        }
        for (SymbolTable other : this.symbolTables) {
            if (other.exists(name)) {
                return other.value(name);
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)other.getName())) continue;
            return other;
        }
        return null;
    }

    public Object get(String name) {
        return this.value(name);
    }

    @Override
    public Function function(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        if (this.functions != null && this.functions.containsKey(name = name.toUpperCase())) {
            return this.functions.get(name);
        }
        if (this.functionAlias != null && this.functionAlias.containsKey(name = name.toUpperCase())) {
            return this.functionAlias.get(name);
        }
        for (SymbolTable other : this.symbolTables) {
            Function fn = other.function(name);
            if (fn == null) continue;
            return fn;
        }
        return null;
    }

    @Override
    public Collection<String> variables() {
        HashSet<String> theVars = new HashSet<String>();
        for (SymbolTable symbolTable : this.symbolTables) {
            theVars.addAll(symbolTable.variables());
        }
        theVars.addAll(this.localvariables());
        return Collections.unmodifiableCollection(theVars);
    }

    @Override
    public Collection<Function> functions() {
        HashSet<Function> theFunctions = new HashSet<Function>();
        for (SymbolTable symbolTable : this.symbolTables) {
            theFunctions.addAll(symbolTable.functions());
        }
        if (this.functions != null) {
            theFunctions.addAll(this.functions.values());
        }
        return Collections.unmodifiableCollection(theFunctions);
    }

    @Override
    public Collection<Function> localfunctions() {
        if (this.functions == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.functions.values());
    }

    @Override
    public Collection<String> localvariables() {
        if (this.getVars().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.getVars().keySet());
    }

    @Override
    public Iterator<Function> iterator() {
        return this.functions().iterator();
    }

    @Override
    public SymbolTable clone() throws CloneNotSupportedException {
        AbstractSymbolTable other = (AbstractSymbolTable)super.clone();
        if (this instanceof MutableSymbolTable) {
            if (this.vars != null) {
                other.vars = new HashMap<String, Object>(this.vars);
            }
            if (this.functions != null) {
                other.functions = new HashMap<String, Function>(this.functions);
            }
            if (this.functionAlias != null) {
                other.functionAlias = new HashMap<String, Function>(this.functionAlias);
            }
        }
        other.symbolTables = new ArrayList<SymbolTable>();
        if (this.symbolTables != null) {
            for (SymbolTable symbolTable : this.symbolTables) {
                other.symbolTables.add(symbolTable.clone());
            }
        }
        return other;
    }

    @Override
    public boolean isSQLCompatible(String name) {
        Function f = this.function(name);
        if (f != null) {
            return f.isSQLCompatible();
        }
        return true;
    }

    public List<SymbolTable> getSymbolTables() {
        return Collections.unmodifiableList(this.symbolTables);
    }

    public String toString() {
        return this.name;
    }

    protected void fixSymbolTables(Set<SymbolTable> visiteds) {
        if (visiteds == null) {
            visiteds = new HashSet<SymbolTable>();
        }
        visiteds.add(this);
        ArrayList<SymbolTable> toRemove = new ArrayList<SymbolTable>();
        for (SymbolTable other : this.symbolTables) {
            if (other == null) continue;
            if (visiteds.contains(other)) {
                toRemove.add(other);
                LOGGER.trace("Remove symbol table '" + other.getName() + "', recursive reference.");
                continue;
            }
            if (!(other instanceof AbstractSymbolTable)) continue;
            ((AbstractSymbolTable)other).fixSymbolTables(visiteds);
        }
        for (SymbolTable symbolTable : toRemove) {
            this.symbolTables.remove(symbolTable);
        }
    }

    public void fixSymbolTables() {
        this.fixSymbolTables(null);
    }
}

