/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi.formatter.value;

import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.spi.formatter.value.Case;
import org.gvsig.expressionevaluator.spi.formatter.value.Date;
import org.gvsig.expressionevaluator.spi.formatter.value.Dict;
import org.gvsig.expressionevaluator.spi.formatter.value.Extract;
import org.gvsig.expressionevaluator.spi.formatter.value.GetItem;
import org.gvsig.expressionevaluator.spi.formatter.value.Getattr;
import org.gvsig.expressionevaluator.spi.formatter.value.Time;
import org.gvsig.expressionevaluator.spi.formatter.value.Timestamp;
import org.gvsig.expressionevaluator.spi.formatter.value.Tuple;

public class BaseFormatter
implements Formatter<ExpressionBuilder.Value> {
    private final Formatter<ExpressionBuilder.Value>[] formatters;

    public BaseFormatter() {
        this(null);
    }

    public BaseFormatter(Formatter<ExpressionBuilder.Value> formatter) {
        if (formatter == null || ExpressionBuilder.EMPTY_FORMATTER == formatter) {
            formatter = this;
        }
        this.formatters = new Formatter[]{new Time(formatter), new Date(formatter), new Timestamp(formatter), new Extract(formatter), new Getattr(formatter), new GetItem(formatter), new Dict(formatter), new Tuple(formatter), new Case(formatter)};
    }

    @Override
    public boolean canApply(ExpressionBuilder.Value value) {
        for (Formatter<ExpressionBuilder.Value> formatter : this.formatters) {
            if (!formatter.canApply(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String format(ExpressionBuilder.Value value) {
        for (Formatter<ExpressionBuilder.Value> formatter : this.formatters) {
            if (!formatter.canApply(value)) continue;
            return formatter.format(value);
        }
        return value.toString(this);
    }
}

