/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl.coercion;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.codec.binary.Hex;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToLocale;

public class CoerceToString
extends AbstractCoercion {
    @Override
    public Object coerce(Object value) throws CoercionException {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof Number) {
            return this.coerce(value, DataTypeUtils.coerceContextDefaultDecimal());
        }
        return this.coerce(value, DataTypeUtils.coerceContextDefaultLocale());
    }

    @Override
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof byte[]) {
            return "0x#" + Hex.encodeHexString((byte[])((byte[])value)) + "#";
        }
        if (context == null) {
            context = value instanceof Number ? DataTypeUtils.coerceContextDefaultDecimal() : DataTypeUtils.coerceContextDefaultLocale();
        }
        try {
            String s;
            Locale locale;
            Locale originalLocale = null;
            if (context instanceof CoercionContextLocale) {
                originalLocale = locale = ((CoercionContextLocale)context).locale();
            } else {
                locale = Locale.getDefault();
            }
            if (value instanceof Time) {
                s = this.getTimeFormat(locale).format(value);
            } else if (value instanceof Timestamp) {
                s = originalLocale == null ? String.valueOf(value) : this.getDateTimeFormat(locale).format(value);
            } else if (value instanceof Date) {
                s = this.getDateFormat(locale).format(value);
            } else if (value instanceof java.util.Date) {
                s = this.getDateTimeFormat(locale).format(value);
            } else if (value instanceof Float || value instanceof Double) {
                double d = ((Number)value).doubleValue();
                NumberFormat nf = NumberFormat.getInstance(locale);
                if (d > 1.8014398509481984E16 || d < -1.8014398509481984E16) {
                    s = String.format("%E", d);
                } else {
                    nf.setMaximumFractionDigits(16);
                    nf.setGroupingUsed(false);
                    s = nf.format(((Number)value).doubleValue());
                }
            } else if (value instanceof BigDecimal) {
                DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
                char decimalSeparator = dfs.getDecimalSeparator();
                s = ((BigDecimal)value).toPlainString();
                if (decimalSeparator != '.') {
                    s = s.replace('.', decimalSeparator);
                }
            } else {
                s = value instanceof Locale ? CoerceToLocale.toString((Locale)value) : value.toString();
            }
            return s;
        }
        catch (Exception e) {
            throw new CoercionException(e);
        }
    }

    private DateFormat getTimeFormat(Locale locale) {
        DateFormat df = DateFormat.getTimeInstance(2, locale);
        try {
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            String s = sdf.toPattern();
            if (!s.contains("HH") && s.contains("H")) {
                s = s.replace("H", "HH");
            }
            if (!s.contains("mm") && s.contains("m")) {
                s = s.replace("m", "mm");
            }
            if (!s.contains("ss") && s.contains("s")) {
                s = s.replace("s", "ss");
            }
            if (!s.contains("SSS")) {
                if (s.contains("SS")) {
                    s = s.replace("SS", "SSS");
                } else if (s.contains("S")) {
                    s = s.replace("S", "SSS");
                }
            }
            sdf.applyPattern(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return df;
    }

    private DateFormat getDateFormat(Locale locale) {
        DateFormat df = DateFormat.getDateInstance(3, locale);
        try {
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            String s = sdf.toPattern();
            if (!s.contains("yyyy")) {
                if (s.contains("yy")) {
                    s = s.replace("yy", "yyyy");
                } else if (s.contains("y")) {
                    s = s.replace("y", "yyyy");
                }
            }
            if (!s.contains("dd") && s.contains("d")) {
                s = s.replace("d", "dd");
            }
            if (!s.contains("MM") && s.contains("M")) {
                s = s.replace("M", "MM");
            }
            sdf.applyPattern(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return df;
    }

    private DateFormat getDateTimeFormat(Locale locale) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 2, locale);
        try {
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            String s = sdf.toPattern();
            if (!s.contains("yyyy")) {
                if (s.contains("yy")) {
                    s = s.replace("yy", "yyyy");
                } else if (s.contains("y")) {
                    s = s.replace("y", "yyyy");
                }
            }
            if (!s.contains("dd") && s.contains("d")) {
                s = s.replace("d", "dd");
            }
            if (!s.contains("MM") && s.contains("M")) {
                s = s.replace("M", "MM");
            }
            if (!s.contains("HH") && s.contains("H")) {
                s = s.replace("H", "HH");
            }
            if (!s.contains("mm") && s.contains("m")) {
                s = s.replace("m", "mm");
            }
            if (!s.contains("ss") && s.contains("s")) {
                s = s.replace("s", "ss");
            }
            if (!s.contains("SSS")) {
                if (s.contains("SS")) {
                    s = s.replace("SS", "SSS");
                } else if (s.contains("S")) {
                    s = s.replace("S", "SSS");
                }
            }
            sdf.applyPattern(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return df;
    }

    public static void main(String[] args) throws CoercionException {
        CoerceToString toString = new CoerceToString();
        Date d = new Date(new java.util.Date().getTime());
        String x = (String)toString.coerce(d);
        System.out.println("Date");
        System.out.println(d);
        System.out.println(x);
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        x = (String)toString.coerce(ts);
        System.out.println("Timestamp");
        System.out.println(d);
        System.out.println(x);
        Time t = new Time(new java.util.Date().getTime());
        x = (String)toString.coerce(t);
        System.out.println("Time");
        System.out.println(d);
        System.out.println(x);
        java.util.Date d0 = new java.util.Date();
        x = (String)toString.coerce(d0);
        System.out.println("DateTime");
        System.out.println(d);
        System.out.println(x);
    }
}

