/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.exception;

import java.util.Objects;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;

public class DynFieldValidateException
extends DynMethodException {
    private static final long serialVersionUID = -5033443492130842514L;
    private static final String MESSAGE_FORMAT = "Field '%(field)' of type %(fieldtype) has a invalid value of '%(value)'.";
    private static final String MESSAGE_KEY = "_Field_XfieldX_of_type_XfieldtypeX_has_a_invalid_value_of_XvalueX";

    protected DynFieldValidateException(String messagefmt, String key, long code) {
        super(messagefmt, key, code);
    }

    protected DynFieldValidateException(String messagefmt, Throwable cause, String key, long code) {
        super(messagefmt, cause, key, code);
    }

    public DynFieldValidateException(Object value, DynField field, Throwable cause) {
        super(MESSAGE_FORMAT, MESSAGE_KEY, -5033443492130842514L);
        if (cause != null) {
            this.initCause(cause);
        }
        this.setValue("field", field.getName());
        this.setValue(value);
        if (field.getAvailableValues() != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(ToolsLocator.getDataTypesManager().getTypeName(field.getType()));
            buffer.append(" ( ");
            for (int i = 0; i < field.getAvailableValues().length; ++i) {
                DynObjectValueItem availableValue = field.getAvailableValues()[i];
                if (availableValue == null) continue;
                buffer.append(Objects.toString(availableValue.getValue()));
                buffer.append(", ");
            }
            buffer.append(")");
            this.setValue("fieldtype", buffer.toString());
        } else if (field.getMaxValue() != null && field.getMinValue() != null) {
            this.setValue("fieldtype", ToolsLocator.getDataTypesManager().getTypeName(field.getType()) + "  (  " + field.getMinValue().toString() + " <= x <=  " + field.getMaxValue().toString() + ")");
        } else {
            this.setValue("fieldtype", ToolsLocator.getDataTypesManager().getTypeName(field.getType()));
        }
        if (value == null) {
            this.setValue("valuetype", "null");
        } else {
            this.setValue("valuetype", value.getClass().getName());
        }
    }

    private void setValue(Object value) {
        try {
            if (value instanceof DynObject) {
                this.setValue("value", this.getDynClassValueText(((DynObject)value).getDynClass()));
                return;
            }
            if (value instanceof DynClass) {
                this.setValue("value", this.getDynClassValueText((DynStruct)value));
                return;
            }
            if (value instanceof DynStruct) {
                this.setValue("value", this.getDynClassValueText((DynStruct)value));
                return;
            }
            if (value == null) {
                this.setValue("value", "null");
            } else {
                this.setValue("value", value.toString());
            }
        }
        catch (Exception e) {
            this.setValue("value", "(unknow)");
        }
    }

    private String getDynClassValueText(DynStruct definition) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(definition.getName()).append("\n  ");
        buffer.append("Mandatory values are: ");
        DynField[] fields = definition.getDynFields();
        if (fields == null || fields.length == 0) {
            buffer.append("(none)\n");
            return buffer.toString();
        }
        String DEL = ",  ";
        StringBuffer items = new StringBuffer();
        buffer.append("[");
        for (int i = 0; i < fields.length; ++i) {
            DynField field = fields[i];
            if (!field.isMandatory()) continue;
            items.append(field.getName());
            items.append(DEL);
        }
        buffer.append(items);
        buffer.append("]");
        return buffer.toString();
    }

    private String getDynObjectValueText(DynObject dynObject) {
        String space = "  ";
        StringBuffer buffer = new StringBuffer();
        buffer.append(dynObject.getDynClass().getName()).append("\n");
        DynField[] fields = dynObject.getDynClass().getDynFields();
        if (fields == null || fields.length == 0) {
            return buffer.toString();
        }
        buffer.append("(\n");
        for (int i = 0; i < fields.length; ++i) {
            DynField field = fields[i];
            Object value = null;
            try {
                value = dynObject.getDynValue(field.getName());
                field.validate(value);
                continue;
            }
            catch (DynFieldValidateException ex) {
                if (value instanceof DynObject) {
                    buffer.append(space).append(this.getDynObjectValueText((DynObject)value));
                    continue;
                }
                buffer.append(space).append(ex.getLocalizedMessageStack());
                continue;
            }
            catch (DynFieldNotFoundException ex2) {
                if (value instanceof DynObject) {
                    buffer.append(space).append(this.getDynObjectValueText((DynObject)value));
                    continue;
                }
                buffer.append(space).append(ex2.getLocalizedMessageStack());
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public DynFieldValidateException(Object value, DynField field) {
        this(value, field, null);
    }
}

