/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectRuntimeException;
import org.gvsig.tools.dynobject.DynObject_v2;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.exception.DynMethodNotSupportedException;
import org.gvsig.tools.dynobject.impl.DefaultDynClass;
import org.gvsig.tools.dynobject.impl.DefaultDynObjectManager;

public class DefaultDynObject
implements DelegatedDynObject,
DynObject_v2 {
    protected DynClass dynClass;
    protected Map values;
    protected DynObject[] delegateds;

    public DefaultDynObject(DynStruct dynClass) {
        this.dynClass = (DynClass)dynClass;
        this.delegateds = null;
        this.values = this.createValues(null);
    }

    private Map createValues(Map oldValues) {
        HashMap extended = new HashMap();
        if (oldValues != null) {
            extended.putAll(oldValues);
        }
        return extended;
    }

    @Override
    public void implement(DynClass dynClass) {
        this.dynClass = (DefaultDynClass)((DefaultDynObjectManager)((DefaultDynClass)dynClass).getManager()).get(new DynClass[]{this.dynClass, dynClass});
        this.values = this.createValues(this.values);
    }

    @Override
    public Object getDynValue(String name) throws DynFieldNotFoundException {
        boolean defined = false;
        Object defaultValue = null;
        DynField field = this.dynClass.getDynField(name = name.toLowerCase());
        if (field != null) {
            if (field instanceof DynField_v2 && ((DynField_v2)field).isCalculated()) {
                return ((DynField_v2)field).getCalculatedValue(this);
            }
            if (this.values.containsKey(name)) {
                return this.values.get(name);
            }
            defined = true;
            defaultValue = field instanceof DynField_v2 ? ((DynField_v2)field).getCoercedDefaultValue() : field.getDefaultValue();
        }
        if (this.delegateds != null) {
            for (int i = 0; i < this.delegateds.length; ++i) {
                DynObject dynObj = this.delegateds[i];
                try {
                    if (dynObj.hasDynValue(name)) {
                        return dynObj.getDynValue(name);
                    }
                    defined = true;
                    defaultValue = dynObj.getDynValue(name);
                    continue;
                }
                catch (DynFieldNotFoundException dynFieldNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (defined) {
            return defaultValue;
        }
        throw new DynFieldNotFoundException(name, this.dynClass.getName());
    }

    @Override
    public void setDynValue(String name, Object value) throws DynFieldNotFoundException {
        if (this.dynClass.getDynField(name = name.toLowerCase()) == null) {
            throw new DynFieldNotFoundException(name, this.getDynClass().getName());
        }
        try {
            this.values.put(name, this.dynClass.getDynField(name).coerce(value));
        }
        catch (CoercionException e) {
            throw new CoerceValueException(this.dynClass, name, value, e);
        }
    }

    public boolean instanceOf(DynClass dynClass) {
        return dynClass.isInstance(this);
    }

    @Override
    public DynClass getDynClass() {
        return this.dynClass;
    }

    @Override
    public boolean hasDynMethod(String name) {
        name = name.toLowerCase();
        try {
            DynMethod method = this.dynClass.getDynMethod(name);
            if (method != null) {
                return true;
            }
        }
        catch (DynMethodException dynMethodException) {
            // empty catch block
        }
        if (this.delegateds != null) {
            for (DynObject dynObj : this.delegateds) {
                try {
                    DynClass dynClass;
                    if (dynObj instanceof DynObject_v2 ? ((DynObject_v2)dynObj).hasDynMethod(name) : (dynClass = dynObj.getDynClass()).getDynMethod(name) != null) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasDynValue(String name) throws DynFieldNotFoundException {
        boolean defined = false;
        DynField field = this.dynClass.getDynField(name = name.toLowerCase());
        if (field != null) {
            if (this.values.containsKey(name)) {
                return true;
            }
            defined = true;
        }
        if (this.delegateds != null) {
            for (int i = 0; i < this.delegateds.length; ++i) {
                DynObject dynObj = this.delegateds[i];
                try {
                    if (dynObj.hasDynValue(name)) {
                        return true;
                    }
                    defined = true;
                    continue;
                }
                catch (DynFieldNotFoundException dynFieldNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (defined) {
            return false;
        }
        throw new DynFieldNotFoundException(name, this.dynClass.getName());
    }

    @Override
    public void delegate(DynObject dynObjects) {
        if (this.delegateds == null) {
            this.delegateds = new DynObject[1];
            this.delegateds[0] = dynObjects;
            return;
        }
        DynObject[] newValues = new DynObject[this.delegateds.length + 1];
        System.arraycopy(this.delegateds, 0, newValues, 0, this.delegateds.length);
        newValues[this.delegateds.length] = dynObjects;
        this.delegateds = newValues;
    }

    @Override
    public Object invokeDynMethod(String name, Object[] args) throws DynMethodException {
        return this.invokeDynMethod((Object)this, name, args);
    }

    @Override
    public Object invokeDynMethod(int code, Object[] args) throws DynMethodException {
        return this.invokeDynMethod((Object)this, code, args);
    }

    @Override
    public Object invokeDynMethod(Object self, String methodName, Object[] args) throws DynMethodException {
        DynMethod method = this.dynClass.getDynMethod(methodName);
        if (method != null) {
            return method.invoke((DynObject)self, args);
        }
        if (this.delegateds != null) {
            for (int i = 0; i < this.delegateds.length; ++i) {
                try {
                    return this.delegateds[i].invokeDynMethod(methodName, args);
                }
                catch (DynMethodNotSupportedException dynMethodNotSupportedException) {
                    continue;
                }
            }
        }
        throw new DynMethodNotSupportedException(methodName, self.getClass().getName());
    }

    @Override
    public Object invokeDynMethod(Object self, int methodCode, Object[] args) throws DynMethodException {
        DynMethod method = this.dynClass.getDynMethod(methodCode);
        if (method != null) {
            return method.invoke((DynObject)self, args);
        }
        if (this.delegateds != null) {
            for (int i = 0; i < this.delegateds.length; ++i) {
                try {
                    return this.delegateds[i].invokeDynMethod(methodCode, args);
                }
                catch (DynMethodNotSupportedException dynMethodNotSupportedException) {
                    continue;
                }
            }
        }
        throw new DynMethodNotSupportedException(methodCode, self.getClass().getName());
    }

    @Override
    public void clear() {
        DynField[] fields = this.getDynClass().getDeclaredDynFields();
        for (int i = 0; i < fields.length; ++i) {
            this.setDynValue(fields[i].getName(), fields[i].getDefaultValue());
        }
    }

    public String toString() {
        return DefaultDynObject.toString(this);
    }

    public static String toString(DynObject obj) {
        StringBuffer buffer = new StringBuffer();
        DynClass dynClass = obj.getDynClass();
        buffer.append("DynClass name: ").append(dynClass.getName()).append(";  Fields: ");
        DynField[] fields = dynClass.getDynFields();
        if (fields == null || fields.length == 0) {
            buffer.append("(none)");
        } else {
            buffer.append("[");
            for (int i = 0; i < fields.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(fields[i].getName()).append(" = ").append(obj.getDynValue(fields[i].getName()));
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    public boolean hasEmptyValues() {
        return this.values.isEmpty();
    }

    public class CoerceValueException
    extends DynObjectRuntimeException {
        private static final long serialVersionUID = 8974502669097158348L;

        public CoerceValueException(DynStruct dynStruct, String fieldName, Object value, Throwable cause) {
            super("Can't convert value %(value) for field %(field) of class %(class).", cause, "Cant_convert_value_XvalueX_for_field_XfieldX_of_class_XclassX", 8974502669097158348L);
            this.setValue("field", fieldName);
            this.setValue("class", dynStruct.getFullName());
            try {
                this.setValue("value", value.toString());
            }
            catch (Exception e1) {
                this.setValue("value", "???");
            }
        }
    }
}

