/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.identitymanagement.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.evaluator.SimpleEvaluatorData;
import org.gvsig.tools.identitymanagement.Rule;
import org.gvsig.tools.identitymanagement.SimpleIdentity;
import org.gvsig.tools.util.GetItemByKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRule
implements Rule {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericRule.class);
    protected String name;
    protected String description;
    protected String actionFilter;
    protected String resourceFilter;
    protected Evaluator filter;
    protected SimpleEvaluatorData filterSymbolTable;
    protected List<String> requires;

    public GenericRule(String name, String description, String actionFilter, String resourceFilter, Evaluator filter, String requires) {
        this(name, description, actionFilter, resourceFilter, filter, GenericRule.toList(requires));
    }

    public GenericRule(String name, String description, String actionFilter, String resourceFilter, Evaluator filter, List<String> requires) {
        this.name = name;
        this.description = description;
        this.actionFilter = actionFilter;
        this.resourceFilter = StringUtils.isBlank((CharSequence)resourceFilter) ? null : resourceFilter;
        this.filter = filter;
        this.filterSymbolTable = this.filter == null ? null : new SimpleEvaluatorData();
        this.requires = requires;
    }

    public GenericRule(GetItemByKey values) {
        String theName = StringUtils.trimToNull((String)Objects.toString(values.get("Name")));
        String theDescription = StringUtils.trimToNull((String)Objects.toString(values.get("Description")));
        String theActionFilter = StringUtils.trimToNull((String)Objects.toString(values.get("Action")));
        String theResourceFilter = StringUtils.trimToNull((String)Objects.toString(values.get("Resource")));
        String theFilter = Objects.toString(values.get("filter"));
        String theRequires = StringUtils.trimToNull((String)Objects.toString(values.get("Requires")));
        if (theName == null) {
            throw new IllegalArgumentException("'name' null not allowed in rule");
        }
        if (theActionFilter == null) {
            throw new IllegalArgumentException("'actionName' null not allowed in rule");
        }
        this.name = theName;
        this.description = theDescription;
        this.actionFilter = theActionFilter;
        this.resourceFilter = theResourceFilter == null ? null : theResourceFilter;
        if (theFilter instanceof Evaluator) {
            this.filter = (Evaluator)((Object)theFilter);
        } else if (theFilter instanceof CharSequence) {
            this.filter = ToolsLocator.getScriptManager().createEvaluator(theFilter.toString());
        }
        this.filterSymbolTable = this.filter == null ? null : new SimpleEvaluatorData();
        this.requires = GenericRule.toList(theRequires);
    }

    private static List<String> toList(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            String[] ss;
            ArrayList<String> l = new ArrayList<String>();
            for (String s1 : ss = StringUtils.split((String)s, (String)",")) {
                if (StringUtils.isBlank((CharSequence)s1)) continue;
                l.add(s1.trim().toLowerCase());
            }
            return l;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isAuthorized(SimpleIdentity identity, String actionName, Object resource, String resourceName) {
        if (!FilenameUtils.wildcardMatch((String)actionName, (String)this.actionFilter, (IOCase)IOCase.INSENSITIVE)) {
            return true;
        }
        if (this.resourceFilter != null && !FilenameUtils.wildcardMatch((String)resourceName, (String)this.resourceFilter, (IOCase)IOCase.INSENSITIVE)) {
            return true;
        }
        if (this.filter != null) {
            this.filterSymbolTable.set("rule", (Object)this);
            this.filterSymbolTable.set("identity", (Object)identity);
            this.filterSymbolTable.set("actionName", (Object)actionName);
            this.filterSymbolTable.set("resourceName", (Object)resourceName);
            this.filterSymbolTable.set("resource", resource);
            Object x = false;
            try {
                x = this.filter.evaluate(this.filterSymbolTable);
            }
            catch (EvaluatorException ex) {
                LOGGER.debug("Can't evaluate filter", (Throwable)ex);
            }
            if (!DataTypeUtils.toBoolean(x, false)) {
                return true;
            }
        }
        String identityId = identity.getID();
        for (String required : this.requires) {
            if (StringUtils.equals((CharSequence)required, (CharSequence)"*")) {
                return true;
            }
            if (required.startsWith("@")) {
                int len = required.length();
                if (len <= 1) continue;
                required = required.substring(1);
                List<String> identityRoles = identity.getRoles();
                if (identityRoles == null) continue;
                for (String identityRole : identityRoles) {
                    if (!FilenameUtils.wildcardMatch((String)identityRole, (String)required, (IOCase)IOCase.INSENSITIVE)) continue;
                    return true;
                }
                continue;
            }
            if (!FilenameUtils.wildcardMatch((String)identityId, (String)required, (IOCase)IOCase.INSENSITIVE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(String actionName) {
        return FilenameUtils.wildcardMatch((String)actionName, (String)this.actionFilter, (IOCase)IOCase.INSENSITIVE);
    }
}

