/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.gvsig.tools.persistence.spi.PersistenceManagerServices;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedContainer {
    private static final Logger logger = LoggerFactory.getLogger(DelegatedContainer.class);
    private final PersistentContextServices context;
    private final PersistenceManagerServices manager;

    public DelegatedContainer(PersistenceManagerServices manager, PersistentContextServices context) {
        this.manager = manager;
        this.context = context;
    }

    protected PersistenceManagerServices getManager() {
        return this.manager;
    }

    protected PersistentContextServices getContext() {
        return this.context;
    }

    protected Object getObject(Object wrapper) {
        if (wrapper instanceof PersistentContextServices.ObjectReference) {
            PersistentContextServices.ObjectReference ref = (PersistentContextServices.ObjectReference)wrapper;
            try {
                return ref.getObject();
            }
            catch (Exception ex) {
                String msg = MessageFormat.format("Can''t retrieve object from persistent state of id {0}.", ref.getId().toString());
                if (logger.isDebugEnabled()) {
                    logger.warn(msg, (Throwable)ex);
                } else {
                    logger.warn(msg);
                }
                throw ex;
            }
        }
        if (wrapper instanceof Map.Entry) {
            return new WrappedEntry((Map.Entry)wrapper);
        }
        return wrapper;
    }

    protected Object getWrapper(Object obj) {
        PersistentContextServices.ObjectReference ref = this.context.get(obj);
        if (ref == null) {
            return obj;
        }
        return ref;
    }

    private class WrappedEntry
    implements Map.Entry {
        private final Map.Entry entry;

        public WrappedEntry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            return DelegatedContainer.this.getObject(this.entry.getKey());
        }

        public Object getValue() {
            return DelegatedContainer.this.getObject(this.entry.getValue());
        }

        public Object setValue(Object arg0) {
            throw new UnsupportedOperationException();
        }
    }
}

