/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import org.gvsig.tools.util.MappedIterator;
import org.gvsig.tools.util.UnmodifiableBasicCollection;
import org.gvsig.tools.util.UnmodifiableBasicSet;

public class UnmodifiableBasicSetMapped<S, T>
implements UnmodifiableBasicSet<T> {
    private final Collection<S> source1;
    private final UnmodifiableBasicCollection<S> source2;
    private final Function<S, T> mapping;

    public UnmodifiableBasicSetMapped(Collection<S> source, Function<S, T> mapping) {
        this.source1 = source;
        this.source2 = null;
        this.mapping = mapping;
    }

    public UnmodifiableBasicSetMapped(UnmodifiableBasicCollection<S> source, Function<S, T> mapping) {
        this.source1 = null;
        this.source2 = source;
        this.mapping = mapping;
    }

    @Override
    public boolean isEmpty() {
        if (this.source1 != null) {
            return this.source1.isEmpty();
        }
        return this.source2.isEmpty();
    }

    @Override
    public int size() {
        if (this.source1 != null) {
            return this.source1.size();
        }
        return this.source2.size();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.source1 != null) {
            return new MappedIterator<S, T>(this.source1.iterator(), this.mapping);
        }
        return new MappedIterator(this.source2.iterator(), this.mapping);
    }
}

