/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.lib.impl;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.compat.se.net.downloader.se.AbstractSEDownloaderTask;
import org.gvsig.compat.se.net.downloader.se.SEDownloader;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderAuthenticationFactory;
import org.gvsig.downloader.DownloaderAuthenticationRequester;
import org.gvsig.downloader.DownloaderCredentials;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.lib.impl.SEAuthDownloaderTask;
import org.gvsig.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloaderManagerImpl
extends SEDownloader
implements DownloaderManager {
    private static final Logger LOG = LoggerFactory.getLogger(DownloaderManagerImpl.class);
    private final List<DownloaderCredentials> credentials = new ArrayList<DownloaderCredentials>();
    private final Map<String, DownloaderAuthenticationFactory> authenticationTypes = new HashMap<String, DownloaderAuthenticationFactory>();
    private final List<DownloaderAuthenticationConfig> authenticationConfigurationServices = new ArrayList<DownloaderAuthenticationConfig>();

    protected Runnable createDownloaderTask(SEDownloader downloader, Executor executor, URL url, String data, File target, Object groupID, int maxbytes) {
        SEAuthDownloaderTask t = new SEAuthDownloaderTask(downloader, executor, url, data, target, groupID);
        t.setMaxbytes(maxbytes);
        return t;
    }

    protected Runnable createDownloaderTask(SEDownloader downloader, Executor executor, URL url, String method, ContentType contenttype, String data, File target, Object groupID, int maxbytes) {
        return this.createDownloaderTask(downloader, executor, url, method, contenttype, data, target, groupID, maxbytes, true);
    }

    protected Runnable createDownloaderTask(SEDownloader downloader, Executor executor, URL url, String method, ContentType contenttype, String data, File target, Object groupID, int maxbytes, boolean logErrors) {
        SEAuthDownloaderTask t = new SEAuthDownloaderTask(downloader, executor, url, method, contenttype, data, target, groupID, logErrors);
        t.setMaxbytes(maxbytes);
        return t;
    }

    public void addOrReplaceCredentials(DownloaderCredentials credentials) {
        if (credentials == null) {
            LOG.warn("Invalid credentials (null).");
            return;
        }
        for (int i = 0; i < this.credentials.size(); ++i) {
            DownloaderCredentials x = this.credentials.get(i);
            if (!DownloaderManager.areSameURLs((String)credentials.getServiceUrl(), (String)x.getServiceUrl())) continue;
            this.credentials.set(i, credentials);
            return;
        }
        this.credentials.add(credentials);
    }

    public void removeCredentials(DownloaderCredentials credentials) {
        if (credentials == null) {
            return;
        }
        Iterator<DownloaderCredentials> it = this.credentials.iterator();
        while (it.hasNext()) {
            DownloaderCredentials next = it.next();
            if (!DownloaderManager.areSameURLs((String)credentials.getServiceUrl(), (String)next.getServiceUrl())) continue;
            it.remove();
        }
    }

    public void removeCredentials(String serviceUrl) {
        if (StringUtils.isBlank((CharSequence)serviceUrl)) {
            return;
        }
        Iterator<DownloaderCredentials> it = this.credentials.iterator();
        while (it.hasNext()) {
            DownloaderCredentials next = it.next();
            if (!DownloaderManager.areSameURLs((String)serviceUrl, (String)next.getServiceUrl())) continue;
            it.remove();
        }
    }

    public DownloaderCredentials getCredentials(URL url) {
        return this.getCredentials(url.toExternalForm());
    }

    public DownloaderCredentials getCredentials(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        DownloaderAuthenticationConfig config = this.getAuthenticationConfigurationService(url);
        if (config == null) {
            return null;
        }
        for (DownloaderCredentials theCredentials : this.credentials) {
            if (!theCredentials.isCompatible(config)) continue;
            return theCredentials;
        }
        for (DownloaderCredentials theCredentials : this.credentials) {
            if (!DownloaderManager.urlStartsWith((String)url, (String)theCredentials.getServiceUrl())) continue;
            return theCredentials;
        }
        for (DownloaderCredentials theCredentials : this.credentials) {
            DownloaderCredentials x = theCredentials.createCredentials(config);
            if (x == null) continue;
            this.addOrReplaceCredentials(x);
            return x;
        }
        return null;
    }

    public void registerAuthenticationConfigurationService(DownloaderAuthenticationConfig config) {
        if (config == null) {
            LOG.warn("Invalid config (null).");
            return;
        }
        for (int i = 0; i < this.authenticationConfigurationServices.size(); ++i) {
            DownloaderAuthenticationConfig x = this.authenticationConfigurationServices.get(i);
            if (!DownloaderManager.areSameURLs((String)config.getServiceUrl(), (String)x.getServiceUrl())) continue;
            this.authenticationConfigurationServices.set(i, config);
            return;
        }
        this.authenticationConfigurationServices.add(config);
    }

    public void removeAuthenticationConfigurationService(DownloaderAuthenticationConfig config) {
        if (config == null) {
            return;
        }
        Iterator<DownloaderAuthenticationConfig> it = this.authenticationConfigurationServices.iterator();
        while (it.hasNext()) {
            DownloaderAuthenticationConfig next = it.next();
            if (!DownloaderManager.areSameURLs((String)config.getServiceUrl(), (String)next.getServiceUrl())) continue;
            it.remove();
        }
    }

    public void registerAuthenticationType(DownloaderAuthenticationFactory factory) {
        this.authenticationTypes.put(factory.getProviderName().toLowerCase(), factory);
    }

    public DownloaderAuthenticationConfig getAuthenticationConfigurationService(String baseUrl) {
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            return null;
        }
        for (DownloaderAuthenticationConfig theConfig : this.authenticationConfigurationServices) {
            if (!DownloaderManager.urlStartsWith((String)baseUrl, (String)theConfig.getServiceUrl())) continue;
            return theConfig;
        }
        return null;
    }

    public Collection<DownloaderAuthenticationFactory> getAuthenticationTypes() {
        return this.authenticationTypes.values();
    }

    public Collection<DownloaderAuthenticationConfig> getAuthenticationConfigurationServices() {
        return this.authenticationConfigurationServices;
    }

    public Collection<DownloaderCredentials> getCredentials() {
        return this.credentials;
    }

    public DownloaderAuthenticationConfig requestAutenticationConfig(URL url) {
        return null;
    }

    public DownloaderAuthenticationFactory getDownloaderAuthenticationFactory(String providerName) {
        return this.authenticationTypes.get(providerName.toLowerCase());
    }

    public void registerAuthenticationConfigurationService(String config) {
        DownloaderAuthenticationConfig downloaderConfig;
        if (StringUtils.isNotBlank((CharSequence)config) && (downloaderConfig = (DownloaderAuthenticationConfig)Json.toObject((String)config)) != null) {
            this.registerAuthenticationConfigurationService(downloaderConfig);
        }
    }

    public String getAuthenticationConfigurationServiceAsString(String baseUrl) {
        DownloaderAuthenticationConfig downloaderConfig = this.getAuthenticationConfigurationService(baseUrl);
        if (downloaderConfig != null) {
            return downloaderConfig.toJson().toString();
        }
        return null;
    }

    public synchronized File downloadFile(URL url, String method, ContentType contenttype, String data, String name, ICancellable cancel, int maxbytes) throws IOException, ConnectException, UnknownHostException {
        return this.downloadFile(url, method, contenttype, data, name, cancel, maxbytes, true);
    }

    public synchronized File downloadFile(URL url, String method, ContentType contenttype, String data, String name, ICancellable cancel, int maxbytes, boolean useCache, boolean logErrors) throws IOException, ConnectException, UnknownHostException {
        File target;
        LOG.info("Download file " + Objects.toString(url));
        if (useCache && (target = this.getPreviousDownloadedURL(url, data)) != null) {
            LOG.info("CACHED " + url.toString() + " at '" + target.getAbsolutePath() + "'");
            return target;
        }
        target = new File(name);
        if (!target.isAbsolute()) {
            target = this.getUniqueTemporaryFile(name);
        }
        if (cancel == null) {
            cancel = ICancellable.DUMB;
        }
        AbstractSEDownloaderTask task = (AbstractSEDownloaderTask)this.createDownloaderTask(this, new MyExecutor(), url, method, contenttype, data, target, cancel.getID(), maxbytes, logErrors);
        task.run();
        Exception lastException = task.getLastException();
        if (lastException instanceof IOException) {
            throw (IOException)lastException;
        }
        if (lastException != null) {
            throw new IOException("Can't download file", lastException);
        }
        return target;
    }

    public void propagateCredentials(String sourceServiceUrl, Collection<String> targetServicesUrls) {
        if (StringUtils.isBlank((CharSequence)sourceServiceUrl)) {
            return;
        }
        DownloaderAuthenticationConfig sourceConfig = this.getAuthenticationConfigurationService(sourceServiceUrl);
        if (sourceConfig == null) {
            return;
        }
        DownloaderCredentials sourceCredentials = this.getCredentials(sourceServiceUrl);
        for (String targetServiceUrl : targetServicesUrls) {
            DownloaderCredentials targetCredentials;
            if (StringUtils.isBlank((CharSequence)targetServiceUrl)) continue;
            DownloaderAuthenticationConfig targetConfig = this.getAuthenticationConfigurationService(targetServiceUrl);
            if (targetConfig == null && (targetConfig = sourceConfig.createAuthenticationConfig(targetServiceUrl)) != null) {
                this.registerAuthenticationConfigurationService(targetConfig);
            }
            if (sourceCredentials == null || (targetCredentials = this.getCredentials(targetServiceUrl)) != null || (targetCredentials = sourceCredentials.createCredentials(targetServiceUrl)) == null) continue;
            this.addOrReplaceCredentials(targetCredentials);
        }
    }

    public String getAuthenticatedUser(URL url) {
        DownloaderCredentials theCredentials = this.getAuthenticatedCredentials(url);
        if (theCredentials == null) {
            return null;
        }
        return theCredentials.getUserid();
    }

    public String getAuthorizationToken(URL url) {
        DownloaderCredentials theCredentials = this.getAuthenticatedCredentials(url);
        if (theCredentials == null) {
            return null;
        }
        return theCredentials.getAuthorizationToken();
    }

    public DownloaderCredentials getAuthenticatedCredentials(URL url) {
        DownloaderCredentials theCredentials = this.getCredentials(url);
        if (theCredentials != null && !theCredentials.isAuthorizationTokenExpired()) {
            return theCredentials;
        }
        DownloaderAuthenticationConfig authConfig = this.getAuthenticationConfigurationService(url.toString());
        if (authConfig == null) {
            return null;
        }
        DownloaderAuthenticationRequester requester = authConfig.create();
        if (requester == null || !requester.requestAuthorization((Executor)new MyExecutor())) {
            return null;
        }
        theCredentials = requester.getCredentials();
        this.addOrReplaceCredentials(theCredentials);
        return theCredentials;
    }

    private static class MyExecutor
    implements Executor {
        private MyExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    command.run();
                } else {
                    SwingUtilities.invokeAndWait(command);
                }
            }
            catch (Throwable th) {
                LOG.warn("Can't run command in Swing thread", th);
            }
        }
    }
}

