/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.lib.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.gvsig.compat.se.net.downloader.se.AbstractSEDownloaderTask;
import org.gvsig.compat.se.net.downloader.se.SEDownloader;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderAuthenticationRequester;
import org.gvsig.downloader.DownloaderCredentials;
import org.gvsig.downloader.IOExceptionWithStatus;
import org.gvsig.downloader.lib.impl.DownloaderManagerImpl;

final class SEAuthDownloaderTask
extends AbstractSEDownloaderTask
implements Runnable {
    public SEAuthDownloaderTask(SEDownloader downloader, Executor executor, URL url, String data, File dstFile, Object groupID) {
        super(downloader, executor, url, data, dstFile, groupID);
    }

    public SEAuthDownloaderTask(SEDownloader downloader, Executor executor, URL url, String method, ContentType contenttype, String data, File dstFile, Object groupID, boolean logErrors) {
        super(downloader, executor, url, method, contenttype, data, dstFile, groupID, logErrors);
    }

    private DownloaderManagerImpl getDownloader() {
        return (DownloaderManagerImpl)this.downloader;
    }

    private DownloaderCredentials getCredentials(URL url) {
        return this.getDownloader().getCredentials(url);
    }

    private void addOrReplaceCredentials(DownloaderCredentials credentials) {
        this.getDownloader().addOrReplaceCredentials(credentials);
    }

    private DownloaderAuthenticationConfig getServiceAuthorizationConfig(URL url) {
        return this.getDownloader().getAuthenticationConfigurationService(url.toString());
    }

    private void authorize(URL url) {
        try {
            LOGGER.info("AUTHORIZATION REQUIRED");
            DownloaderAuthenticationConfig config = this.getServiceAuthorizationConfig(url);
            if (config == null && (config = this.getDownloader().requestAutenticationConfig(url)) == null) {
                throw new AuthenticationException("Not service authentication configured for url '" + url + "'.");
            }
            DownloaderAuthenticationRequester authorizationRequester = config.create();
            if (authorizationRequester == null) {
                throw new AuthenticationException("Can't configure service authentication for url '" + url + "'.");
            }
            LOGGER.info("AUTHORIZATION REQUESTER TYPE: " + authorizationRequester.getProviderName());
            if (!authorizationRequester.requestAuthorization(this.getExecutor())) {
                return;
            }
            DownloaderCredentials credentials = authorizationRequester.getCredentials();
            this.addOrReplaceCredentials(credentials);
            LOGGER.info("CREDENTIALS: " + credentials.toString());
        }
        catch (Exception ex) {
            LOGGER.warn("Can't authorize", (Throwable)ex);
        }
    }

    private CloseableHttpClient createHttpClient(int timeout) {
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(sslContext).setDefaultRequestConfig(requestConfig).build();
            return httpClient;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create http client.", ex);
        }
    }

    private void setCredentials(HttpUriRequest request) throws MalformedURLException {
        URL theUrl = request.getURI().toURL();
        String token = this.getDownloader().getAuthorizationToken(theUrl);
        if (token != null) {
            request.addHeader("Authorization", token);
        }
    }

    private DownloaderResponseHandler executeRequest(HttpUriRequest request) throws IOException {
        int timeout = this.getTimeout();
        CloseableHttpClient httpClient = this.createHttpClient(timeout);
        this.setCredentials(request);
        DownloaderResponseHandler responseHandler = new DownloaderResponseHandler();
        LOGGER.info("REQUEST " + request.getMethod() + " " + request.getURI().toString());
        LOGGER.info("TIMEOUT " + timeout);
        for (Header header : request.getAllHeaders()) {
            LOGGER.info(header.getName() + ": " + header.getValue());
        }
        if (request instanceof HttpEntityEnclosingRequestBase) {
            InputStream content = ((HttpEntityEnclosingRequestBase)request).getEntity().getContent();
            LOGGER.info("BODY data " + StringUtils.join((Iterable)IOUtils.readLines((InputStream)content, (String)"utf-8"), (String)"\n"));
        }
        LOGGER.info("DOWNLOAD TO " + Objects.toString(this.dstFile));
        long t1 = System.currentTimeMillis();
        try {
            httpClient.execute(request, (ResponseHandler)responseHandler);
        }
        catch (SocketTimeoutException | ConnectTimeoutException ex) {
            LOGGER.info("RESPONSE TIMEOUT");
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.info("RESPONSE ERROR " + ex.getLocalizedMessage());
            throw ex;
        }
        long t2 = System.currentTimeMillis();
        int status = responseHandler.getStatus();
        if (status == 307 || status == 308) {
            LOGGER.info("RESPONSE LOCATION " + Objects.toString(responseHandler.getRedirectionLocation()));
        }
        LOGGER.info("RESPONSE CODE " + status + " " + (t2 - t1) + "ms (" + new Timestamp(t2).toString() + ")");
        if (status >= 300) {
            String s = this.getContentAsString(this.dstFile, 1000);
            if (s == null) {
                LOGGER.info("RESPONSE CONTENT: empty or can't read");
            } else {
                LOGGER.info("RESPONSE CONTENT:\n" + s + "\n");
            }
        }
        return responseHandler;
    }

    /*
     * Exception decompiling
     */
    private String getContentAsString(File dstFile, int chars) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URI urlToUri(URL url) throws URISyntaxException {
        try {
            URI uri = url.toURI();
            return uri;
        }
        catch (URISyntaxException ex) {
            String s = url.toExternalForm();
            return new URI(s);
        }
    }

    private File send(String method, ContentType contentType, String data) throws IOExceptionWithStatus {
        int status = 500;
        URL theUrl = this.url;
        try {
            URI theUri = this.urlToUri(theUrl);
            int numretries = 3;
            for (int retries = 0; retries < numretries; ++retries) {
                HttpDelete request;
                switch (method.toUpperCase()) {
                    case "DELETE": {
                        request = new HttpDelete(theUri);
                        break;
                    }
                    case "PUT": {
                        request = new HttpPut(theUri);
                        request.setHeader("Content-type", contentType.toString());
                        ((HttpPut)request).setEntity((HttpEntity)new StringEntity(data, contentType));
                        break;
                    }
                    case "POST": {
                        request = new HttpPost(theUri);
                        request.setHeader("SOAPAction", "post");
                        request.setHeader("Content-type", contentType.toString());
                        ((HttpPost)request).setEntity((HttpEntity)new StringEntity(data, contentType));
                        break;
                    }
                    default: {
                        request = new HttpGet(theUri);
                    }
                }
                request.setHeader("User-Agent", "gvSIG-desktop");
                request.setHeader("Referer", "http://www.gvsig.com");
                DownloaderResponseHandler responseHandler = this.executeRequest((HttpUriRequest)request);
                status = responseHandler.getStatus();
                if (status >= 200 && status < 300) {
                    return this.dstFile;
                }
                if (status == 307 || status == 308) {
                    String redirection = responseHandler.getRedirectionLocation();
                    if (StringUtils.isBlank((CharSequence)redirection)) {
                        throw new IOExceptionWithStatus(status, "Can't call method " + method + " " + Objects.toString(theUrl) + "' HTTPStatus = " + status + " redirect to blank URL.", this.dstFile);
                    }
                    try {
                        theUrl = new URL(redirection);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new IOExceptionWithStatus(status, "Can't call method " + method + " " + Objects.toString(theUrl) + "' HTTPStatus = " + status + " redirect to invalid URL " + redirection, this.dstFile);
                    }
                }
                if (status >= 300 && status < 400) {
                    throw new IOExceptionWithStatus(status, "Can't call method " + method + " " + Objects.toString(theUrl) + "' HTTPStatus = " + status, this.dstFile);
                }
                if (status == 401 || status == 403) {
                    if (retries >= numretries - 1) continue;
                    this.authorize(theUrl);
                    continue;
                }
                if (status >= 400 && status < 500) {
                    throw new IOExceptionWithStatus(status, "Can't call method " + method + " " + Objects.toString(theUrl) + "' HTTPStatus = " + status, this.dstFile);
                }
                if (status >= 500 && status < 600) {
                    throw new IOExceptionWithStatus(status, "Can't call method " + method + " " + Objects.toString(theUrl) + "' HTTPStatus = " + status, this.dstFile);
                }
                throw new IOExceptionWithStatus(status, "Can't call method " + method + " " + Objects.toString(theUrl) + "' HTTPStatus = " + status, this.dstFile);
            }
            throw new IOExceptionWithStatus(status, "Can't call method " + method + " " + Objects.toString(theUrl) + "' too many retries, last status " + status, this.dstFile);
        }
        catch (IOExceptionWithStatus ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IOExceptionWithStatus(status, "Can't call method " + method + " " + Objects.toString(theUrl) + "' last status " + status, ex, this.dstFile);
        }
    }

    @Override
    public void run() {
        try {
            this.send(this.method, this.contenttype, this.data);
            this.postdownload();
        }
        catch (Exception e) {
            this.exception(e);
        }
    }

    private class DownloaderResponseHandler
    implements ResponseHandler<Object> {
        private int status = 0;
        private HttpResponse response;

        public Object handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            this.status = response.getStatusLine().getStatusCode();
            this.response = response;
            try {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    SEAuthDownloaderTask.this.download(null);
                } else {
                    InputStream content = entity.getContent();
                    SEAuthDownloaderTask.this.download(content);
                }
            }
            catch (IOExceptionWithStatus ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOExceptionWithStatus(this.status, ex.getLocalizedMessage(), (Throwable)ex);
            }
            return null;
        }

        public int getStatus() {
            return this.status;
        }

        public String getRedirectionLocation() {
            try {
                Header header = this.response.getFirstHeader("Location");
                if (header != null) {
                    return header.getValue();
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Can't get redirection location", (Throwable)ex);
            }
            return null;
        }
    }
}

