/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.ExtentElement;
import org.gvsig.sldsupport.impl.sld.parsing.FilterElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.constraints.SLDFeatureTypeConstraint;
import org.gvsig.sldsupport.sld.extent.SLDExtent;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FeatureTypeConstraintElement {
    public static void append(SLDFeatureTypeConstraint obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("FeatureTypeConstraint");
        if (obj.getFeatureTypeName() != null) {
            xb.writeTag("FeatureTypeName", obj.getFeatureTypeName());
        }
        if (obj.getFilter() != null) {
            FilterElement.append(obj.getFilter(), xb, version);
        }
        for (int i = 0; i < obj.getExtents().size(); ++i) {
            ExtentElement.append((SLDExtent)obj.getExtents().get(i), xb, version);
        }
        xb.closeTag();
    }

    public static SLDFeatureTypeConstraint parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "FeatureTypeConstraint");
        int tag = 0;
        SLDFeatureTypeConstraint resp = new SLDFeatureTypeConstraint();
        tag = parser.nextTag();
        String name = parser.getName();
        String txt = null;
        while (!SLDUtils.isStr(name, "FeatureTypeConstraint") || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "FeatureTypeName")) {
                        txt = parser.nextText();
                        resp.setFeatureTypeName(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Filter")) {
                        txt = parser.nextText();
                        resp.setFeatureTypeName(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Extent")) {
                        SLDExtent ext = ExtentElement.parse(parser, version);
                        resp.getExtents().add(ext);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in featuretype constraints: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

