/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.GraphicFillElement;
import org.gvsig.sldsupport.impl.sld.parsing.SvgCssParameterElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.graphic.SLDGraphicFill;
import org.gvsig.sldsupport.sld.symbol.misc.SLDFill;
import org.gvsig.sldsupport.sld.symbol.misc.SLDSvgCssParameter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FillElement {
    public static void append(SLDFill obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        SLDSvgCssParameter p;
        xb.openTag("Fill");
        if (obj.getFillGraphic() != null) {
            GraphicFillElement.append(new SLDGraphicFill(obj.getFillGraphic()), xb, version);
        }
        if (obj.getFillColor() != null) {
            p = new SLDSvgCssParameter();
            p.setName("fill");
            p.getExpressionList().add(obj.getFillColor());
            SvgCssParameterElement.append(p, xb, version);
        }
        if (obj.getOpacity() != null) {
            p = new SLDSvgCssParameter();
            p.setName("fill-opacity");
            p.getExpressionList().add(obj.getOpacity());
            SvgCssParameterElement.append(p, xb, version);
        }
        xb.closeTag();
    }

    public static SLDFill parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "Fill");
        int tag = 0;
        SLDFill resp = new SLDFill();
        tag = parser.nextTag();
        String name = parser.getName();
        Object txt = null;
        Object attName = null;
        while (!SLDUtils.isStr(name, "Fill") || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "GraphicFill")) {
                        SLDGraphicFill gf = GraphicFillElement.parse(parser, version);
                        resp.setFillGraphic(gf.getGraphic());
                        break;
                    }
                    if (SLDUtils.isStr(name, "CssParameter") || SLDUtils.isStr(name, "SvgParameter")) {
                        SLDSvgCssParameter sp = SvgCssParameterElement.parse(parser, version);
                        if (SLDUtils.isStr(sp.getName(), "fill")) {
                            if (sp.getExpressionList().size() <= 0) break;
                            resp.setFillColor((SLDExpression)sp.getExpressionList().get(0));
                            break;
                        }
                        if (!SLDUtils.isStr(sp.getName(), "fill-opacity") || sp.getExpressionList().size() <= 0) break;
                        resp.setOpacity((SLDExpression)sp.getExpressionList().get(0));
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in fill element: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

