/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.List;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.AnchorPointElement;
import org.gvsig.sldsupport.impl.sld.parsing.DisplacementElement;
import org.gvsig.sldsupport.impl.sld.parsing.ExternalGraphicElement;
import org.gvsig.sldsupport.impl.sld.parsing.MarkElement;
import org.gvsig.sldsupport.impl.sld.parsing.ParameterValueElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.graphic.SLDAnchorPoint;
import org.gvsig.sldsupport.sld.graphic.SLDDisplacement;
import org.gvsig.sldsupport.sld.graphic.SLDExternalGraphic;
import org.gvsig.sldsupport.sld.graphic.SLDGraphic;
import org.gvsig.sldsupport.sld.graphic.SLDMark;
import org.gvsig.sldsupport.sld.symbol.misc.SLDParameterValue;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GraphicElement {
    public static void append(SLDGraphic obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("Graphic");
        List list = obj.getElementStack();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof SLDExternalGraphic) {
                ExternalGraphicElement.append((SLDExternalGraphic)list.get(i), xb, version);
                continue;
            }
            if (!(list.get(i) instanceof SLDMark)) continue;
            MarkElement.append((SLDMark)list.get(i), xb, version);
        }
        if (obj.getOpacity() != null) {
            ParameterValueElement.append("Opacity", obj.getOpacity(), xb, version);
        }
        if (obj.getSize() != null) {
            ParameterValueElement.append("Size", obj.getSize(), xb, version);
        }
        if (obj.getRotation() != null) {
            ParameterValueElement.append("Rotation", obj.getRotation(), xb, version);
        }
        if (version != null && version.compareToIgnoreCase("1.1.0") == 0) {
            if (obj.getAnchor() != null) {
                AnchorPointElement.append(obj.getAnchor(), xb, version);
            }
            if (obj.getDisplacement() != null) {
                DisplacementElement.append(obj.getDisplacement(), xb, version);
            }
        }
        xb.closeTag();
    }

    public static SLDGraphic parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "Graphic");
        int tag = 0;
        SLDGraphic resp = new SLDGraphic();
        tag = parser.nextTag();
        String name = parser.getName();
        Object txt = null;
        while (!SLDUtils.isStr(name, "Graphic") || tag != 3) {
            switch (tag) {
                case 2: {
                    SLDParameterValue pv;
                    if (SLDUtils.isStr(name, "ExternalGraphic")) {
                        SLDExternalGraphic ext = ExternalGraphicElement.parse(parser, version);
                        resp.getElementStack().add(ext);
                        break;
                    }
                    if (SLDUtils.isStr(name, "Mark")) {
                        SLDMark mk = MarkElement.parse(parser, version);
                        resp.getElementStack().add(mk);
                        break;
                    }
                    if (SLDUtils.isStr(name, "Opacity")) {
                        pv = ParameterValueElement.parse(parser, version);
                        resp.setOpacity(pv);
                        break;
                    }
                    if (SLDUtils.isStr(name, "Size")) {
                        pv = ParameterValueElement.parse(parser, version);
                        resp.setSize(pv);
                        break;
                    }
                    if (SLDUtils.isStr(name, "Rotation")) {
                        pv = ParameterValueElement.parse(parser, version);
                        resp.setRotation(pv);
                        break;
                    }
                    if (SLDUtils.isStr(name, "AnchorPoint")) {
                        SLDAnchorPoint ap = AnchorPointElement.parse(parser, version);
                        resp.setAnchor(ap);
                        break;
                    }
                    if (SLDUtils.isStr(name, "Displacement")) {
                        SLDDisplacement di = DisplacementElement.parse(parser, version);
                        resp.setDisplacement(di);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in graphic: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        if (resp.getElementStack().size() == 0) {
            resp.setDefaultMark();
        }
        return resp;
    }
}

